/*
txtutil.c
source for todos.obj, tomac.obj and tounix.obj
--ak (2002/01)
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <malloc.h>

#define FILE_END   10
#define BUFF_FUL   11
#define LINE_END   12

#define LBUF       2048
#define RSIZ       2040

char *template="TTXXXXXX";

/* return value
FILE_END : End of file
BUFF_FUL : Buffer full
LINE_END : End of line
*/
int ffgets(char *buf, int size, FILE *fi)
{
  char *p;
  int  c;
  int  n;

  n = 0;
  p = buf;
  *p = '\0';

  while(1) {
    c = getc(fi);
    if(c == 26)
      continue;
    n++;
    if(c == EOF) {
      *p = '\0';
      return FILE_END;
    }
    else if(c == 0x0d || c == 0x0a) {
      *p = '\0';
      if(c == 0x0d) {
	c = getc(fi);
	if(c != 0x0a)
	  ungetc(c, fi);
      }
      return LINE_END;
    }
    else if(n == (size - 3)) {
      *p++ = c; *p = '\0';
      return BUFF_FUL;
    }
    else *p++ = c;
  }
}

/*
Check file or directory
*/
int isfile(char *name)
{
  struct _stat s;

  if( _stat(name, &s) != 0) {
    return 0;
  }

  if(s.st_mode & _S_IFDIR)
    return 0;

  return 1;
}

int main(int argc, char *argv[])
{
  int   i, j, k, len;
  char  *buff;
  FILE  *fi, *fo;
  char  *fname;

  if(argc == 1) {
    printf("Usage: %s file1.txt file2.txt ...\n", argv[0]);
    printf("\n");
#ifdef TXTDOS
    printf("Convert end of line of text file(s) to 0x0d0x0a.\n");
#endif
#ifdef TXTMAC
    printf("Convert end of line of text file(s) to 0x0d.\n");
#endif
#ifdef TXTUNIX
    printf("Convert end of line of text file(s) to 0x0a.\n");
#endif
    printf("End of line of input text files can be arbitrary.\n");
    printf("Input text files must be writable.\n");
    printf("Original files are not saved.\n");
    printf("Shell characters \"* and ?\" are supported.\n");
    exit (0);
  }
 
  buff = (char *)malloc(LBUF);
  if(buff == NULL) {
    printf("Memory allocation error.\n");
    exit (1);
  }

  fname = _mktemp(template);

  if(fname == NULL) {
/*
mktemp failed. Therefore I create a strange temporary name.
*/
    fname = (char *)malloc(32);
    strcpy(fname, "-_-_-_-_-_-_-_-_-_-_-_.text");
  }
  
  for(i = 1; i < argc; i++) {
    if(isfile(argv[i]) == 0) {
      printf("%s does not exist or is a directory.\n", argv[i]);
      continue;
    }

    fi = fopen(argv[i], "rb");
    if(fi == NULL) {
      printf("I cannot open %s.\n", argv[i]);
      continue;
    }

    fo = fopen(fname, "wb");
    if(fo == NULL) {
      printf("I cannot open temp file %s to write.\n", fname);
      continue;
    }

#ifdef TXTDOS
    printf("Converting %s to DOS text file...\n", argv[i]);
#endif
#ifdef TXTMAC
    printf("Converting %s to Mac text file...\n", argv[i]);
#endif
#ifdef TXTUNIX
    printf("Converting %s to Unix text file...\n", argv[i]);
#endif

    while(1) {
      j = ffgets(buff, RSIZ, fi);
      len = strlen(buff);
      for(k=0; k < len; k++)
	putc(buff[k], fo);
      if(j == FILE_END) {
	break;
      }
      else if(j == BUFF_FUL) {
	;
      }
      else if(j == LINE_END) {
#ifdef TXTDOS
	putc('\r', fo);
	putc('\n', fo);
#endif
#ifdef TXTMAC
	putc('\r', fo);
#endif
#ifdef TXTUNIX
	putc('\n', fo);
#endif
      }
    }
    fclose(fi);
    fclose(fo);
    remove(argv[i]);
    rename(fname, argv[i]);
  }
  return 0;
}
