/* repairt1 : repair type1 font produced by ttf2pfb (CJK)
 * --ak (2000/02/02)
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>

int main(int argc, char **argv)
{
  int   i, j, pnum;
  char  *cjk[256];
  char  buff[512];
  FILE  *in, *out;
  char  *p;
  char  v1[64], v2[64], v3[64], v4[64];

  if(argc != 3) {
    fprintf(stderr,"usage: repairt1 old new.\n");
    exit(100);
  }

  if(!(in = fopen(argv[1], "r"))) {
    fprintf(stderr,"cannot open %s\n", argv[1]);
    exit(100);
  }

  for(i = 0; i < 256; i++)
    cjk[i] = (char *)malloc(64);

  buff[0] = '\0';
  p = buff;
  while(strncmp(p, "dup 255", 7))
    p = fgets(buff, 512, in);

  i = 0;
  while(p = fgets(buff, 512, in)) {
    if(!strncmp(p, "/cjk", 4)) {
      sscanf(p, "%s {", cjk[i]);
      i++;
    }
  }

  pnum = i + 1;

  fclose(in);
  in = fopen(argv[1], "r");
  out = fopen(argv[2], "wb");
  if(!out) {
    fprintf(stderr, "cannot open %s.\n", argv[2]);
    exit (100);
  }

  while(p = fgets(buff, 512, in)) {
    v1[0] = v2[0] = v3[0] = v4[0] = '\0';
    i = sscanf(p, "%s %s %s %s", v1, v2, v3, v4);
    if((i == 4) && !strcmp(v1, "/FamilyName") &&
       !strcmp(v2, "()") && !strcmp(v3, "readonly") &&
       !strcmp(v4, "def"))
      fputs("/FamilyName (MicrosoftJPFNT) readonly def\n", out);
    else if((i == 4) && !strcmp(v1, "dup") &&
	    !strncmp(v3, "/cjk", 4) && !strcmp(v4, "put")
	    && strcmp(v2, "255"))
      continue;
    else if((i == 4) && !strcmp(v1, "dup") &&
	    !strncmp(v3, "/cjk", 4) && !strcmp(v4, "put")
	    && !strcmp(v2, "255")) {
      for(i = 0; i < pnum-1; i++) {
	sscanf(cjk[i]+6, "%02X", &j);
	fprintf(out, "dup %d %s put\n", j, cjk[i]);
      }
    }
    else if(!strcmp(v1, "2") && !strcmp(v2, "index") &&
	    !strcmp(v3, "/CharStrings"))
      fprintf(out, "2 index /CharStrings %d dict dup begin\n", pnum);
    else
      fputs(p, out);
  }

  fclose(in);
  fclose(out);

  for(i = 0; i < 256; i++)
    free(cjk[i]);

  return 0;
}
