/*
 * Copyright (C) 1991,1992 NEC Corporation.
 * $Id: kanji.h,v 2.10 1994/04/19 10:16:45 uchida Exp $ (NEC)
 */
#ifdef	KANJI
/* Internal Kanji Code
 *	R[hD\[XvOgCŒ`ꂽR[hłȂ
 *	ȂȂD
 */
#if	INTERNAL_CODE == CODE_EUC
/*
 * R[hEUCp
 */
/* Spł		*/
#define	isZenkaku(str)		((*(str) & 0x80) == 0x80)

/* SpXy[Xł		*/
#define	isZenkakuSpc(str)	(*(str) == (char)0xa1 && *((str)+1) == (char)0xa1)

/* Sp炵(oCĝ݂Ŕ)	*/
#define	maybeZenkakuNum(str) 	(*(str) == (char)0xa3)

/* Sp̒l(OPcX) ߂	*/
#define	ZenkakuNumVal(str) 	(*((str)+1) & 0x0f)

/* ׂrfЂ̑oCgɈv	*/
#define	maybeThinKeisen(str) 	(*(str) == (char)0xa8)

#else
#if	INTERNAL_CODE == CODE_SJIS
/*
 *	R[hshift JISp
 */
typedef unsigned char	UCHAR;

/* Spł		*/
#define	isZenkaku(str) (((UCHAR)0x80 <= (UCHAR)(*(str))&&(UCHAR)(*(str)) <= (UCHAR)0x9f)|| \
			((UCHAR)0xe0 <= (UCHAR)(*(str))&&(UCHAR)(*(str)) <= (UCHAR)0xff))

/* SpXy[Xł		*/
#define	isZenkakuSpc(str) ((UCHAR)*(str) == (UCHAR)0x81 && (UCHAR)*((str)+1) == (UCHAR)0x40)

/* Sp */
#define	maybeZenkakuNum(str) (((UCHAR)*(str) == (UCHAR)0x82) && \
		   ((UCHAR)0x4f <= (UCHAR)(*(str)+1)||(UCHAR)(*(str)+1) <= (UCHAR)0x58) )

/* Sp̒l(OPcX) ߂	*/
#define	ZenkakuNumVal(str) 	((UCHAR)*((str)+1) - (UCHAR)0x4f)

/* ׂrfЂ̑oCgɈv	*/
#define	maybeThinKeisen(str) 	( ((UCHAR)*(str) == (UCHAR)0x84) && \
                 ((UCHAR)0x9f <= (UCHAR)(*(str)+1) || (UCHAR)(*(str)+1) <= (UCHAR)0xa9))

#else
unknown code;
#endif
#endif
#endif
