/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config.classpath;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.tree.DefaultTreeModel;
import org.gjt.jclasslib.browser.config.classpath.ClassTreeNode;
import org.gjt.jclasslib.browser.config.classpath.ClasspathEntry;
import org.gjt.jclasslib.browser.config.classpath.FindResult;

public class ClasspathArchiveEntry
extends ClasspathEntry {
    public FindResult findClass(String string) {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        string = string.replace('.', '/') + ".class";
        try {
            JarFile jarFile = new JarFile(file);
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry != null) {
                FindResult findResult = new FindResult(this, file.getPath() + "!" + string);
                return findResult;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void mergeClassesIntoTree(DefaultTreeModel defaultTreeModel, boolean bl) {
        File file = this.getFile();
        if (file == null) {
            return;
        }
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().toLowerCase().endsWith(".class")) continue;
                this.addEntry(this.stripClassSuffix(jarEntry.getName()), defaultTreeModel, bl);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addEntry(String string, DefaultTreeModel defaultTreeModel, boolean bl) {
        String[] stringArray = string.replace('\\', '/').split("/");
        ClassTreeNode classTreeNode = (ClassTreeNode)defaultTreeModel.getRoot();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            classTreeNode = this.addOrFindNode(string2, classTreeNode, i < stringArray.length - 1, defaultTreeModel, bl);
        }
    }
}

