//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TCapture
//	Include File:	tcapture.h
//	Purpose:	Captures c streams stdout and sterr to a window.
//	Remarks/Portability/Dependencies/Restrictions:
//		Works in conjuction with the c source file capstdio.c and
//		two global variables capstdout and capstderr in globals.c
//	Revision History:
//		01-08-94	created
//		02-09-94	Split all members into seperate files.
#include"tcapture.h"

extern "C" void cap_stderr(const char *cp)	{
//	Purpose:	Write a string into our terminal.
//	Arguments:	cp	The string to write into our terminal.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		If the window is hidden, this function will cause it to show.
//		Depends upon the global variable TC.
//	Revision History:
//		01-08-94	created

	::TC->show();
	::TC->makeFirst();
	::TC->DumbStream << cp;
}