/*
 * Copyright 1993,1994 Globetrotter Software, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Globetrotter Software not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Globetrotter Software makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * GLOBETROTTER SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO
 * EVENT SHALL GLOBETROTTER SOFTWARE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Jim McBeath, Globetrotter Software, jimmc@globes.com
 */
/* gconf.c - global configuration file processing
 *
 * Jim McBeath, November 19, 1993
 */

#include "htimp.h"

char *ImpRoot;
char *ImpScriptFullName;
char *ImpConfFileName;

extern void ImpSetPort();
extern void ImpSetCheckInterval();
extern void ImpSetKillTimeout();
extern void ImpSetCleanupTimeout();
extern void ImpSetMaxJobs();
extern void ImpSetAppConfDir();
extern void ImpSetAppBinDir();

extern char *ImpGetServerRoot();
extern char *ImpGetScriptName();

void
ImpSetImpRoot(s)
char *s;
{
	int l;
	char *sr;

	if (ImpRoot)
		ImpFree(ImpRoot);
	if (s[0]=='/') {
		ImpRoot = ImpStrSave(s);
		return;
	}
	sr = ImpGetServerRoot();
	l = strlen(sr)+strlen(s)+2;
	ImpRoot = ImpMalloc(l);
	strcpy(ImpRoot,sr);
	strcat(ImpRoot,"/");
	strcat(ImpRoot,s);
}

void
ImpSetScriptFullName(s)
char *s;
{
	ImpScriptFullName = ImpStrSave(s);
}

OpInfo optab[] = {
	{ "port", CALL_N, ImpSetPort },
	{ "appconfdir", CALL_S, ImpSetAppConfDir },
	{ "appbindir", CALL_S, ImpSetAppBinDir },
	{ "checkinterval", CALL_N, ImpSetCheckInterval },
	{ "killtimeout", CALL_N, ImpSetKillTimeout },
	{ "cleanuptimeout", CALL_N, ImpSetCleanupTimeout },
	{ "maxjobs", CALL_N, ImpSetMaxJobs },
	{ "htimproot", CALL_S, ImpSetImpRoot },
	{ "scriptfullname", CALL_S, ImpSetScriptFullName },
	{ 0 }
};

char *
ImpGetImpRoot()
{
	char *sr;
	char *dr;
	char *t;

	if (ImpRoot)
		return ImpRoot;
	dr = DEFAULT_IMP_ROOT;
	if (dr[0]=='/')
		return dr;
	sr = ImpGetServerRoot();
	t = ImpMalloc(strlen(sr)+strlen(dr)+2);
	sprintf(t,"%s/%s",sr,dr);
	ImpRoot = t;
	return t;
}

char *
ImpGetScriptFullName()
{
	char *s;

	if (ImpScriptFullName)
		return ImpScriptFullName;
	return ImpGetScriptName();
}

void
ImpSetConfFileName(s)
char *s;
{
	ImpConfFileName = s;
}

char *
ImpGetConfFileName()
{
	char *sr, *t;
	char *ImpGetImpRoot();
	char *getenv();

	if (ImpConfFileName)
		return ImpConfFileName;
	t =  getenv("HTIMP_CF");
	if (t)
		return t;
	sr = ImpGetImpRoot();
	t = ImpMalloc(strlen(sr)+strlen(CONF_FILE_NAME)+2);
	sprintf(t,"%s/%s",sr,CONF_FILE_NAME);
	ImpConfFileName = t;
	return t;
}

void
ImpReadConfFile()
{
	char *fn;

	fn = ImpGetConfFileName();
	ImpConfFile(fn,optab,(void *)0);
}

/* end */
