.\" Copyright 1991 by James J. Dempsey <jjd@bbn.com>
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, James J. Dempsey makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as is"
.\" without express or implied warranty.
.TH XRSH 1 "Release 5" "X Version 11"
.SH NAME
xrsh \- start an X program on a remote machine
.SH SYNOPSIS
.B xrsh
[
.B \-l
.I username
] [
.B \-auth
.I authtype
] [
.B \-screen
.I screen-#
] [
.B \-pass
.I envlist
] [
.B \-debug
] [
.B \-debug2
]
.I remote-host
[
.I X-command
[
.I arguments ... ] ]
.SH DESCRIPTION
.I Xrsh
runs the given X command on a remote host.  It sets up the environment for 
that command such that it will display its windows on the current
server's screen by propagating the $DISPLAY environment variable. 
If not specified, the default client is \fIxterm\fP.  Xrsh automatically
selects \fIrsh\fP(1), \fIremsh\fP(1) or \fIrcmd\fP(1) to execute remote commands, depending 
on what is available the O/S environment. 
.PP
Xrsh automatically handles authentication so that the remote client
will be allowed to open windows on the server.  It does this in
several different ways depending on the value of the $XRSH_AUTH_TYPE
environment variable or the \-auth argument.
.PP
By default, xrsh will use xhost to enable the remote client to open a
server connection.  It can also be told to use xauth to merge local
keys into a remote authorization file.   Or it can pass the $XAUTHORITY
environment variable to the remote host in order to share a common NFS
mounted authority file.  It can also be directed to do nothing in the
case where no explicit authorization is necessary.
.PP
Users who just want a remote terminal window might look at xrsh's
sister command, xrlogin(1).  Xrlogin uses a locally running xterm to
open an rlogin connection to a remote host.  The decision on whether
to use "xrsh host xterm" or "xrlogin host" should be based on several
factors.  If X is unavailable on the remote host or the local terminal 
emulator has better features, use xrlogin.  In general, the author 
recommends using xrsh over xrlogin in most situations.
.PP
If the command to execute on the remote host is an xterm, xrsh
automatically passes the -name argument to xterm with a value of
"xterm-hostname" where hostname is the name of the remote host.  This
allows the user to specify resources in their server's resource
manager which are specific to xterms from a given host.  For example,
this feature can be used to make all xterm windows from a given remote
host be the same color or use a specific font or start up in a
specific place on the screen.  Xrlogin passes the same string so they
are compatible in this regard.  This feature can be overridden by
specifying your own -name argument on the xterm command line.
.PP
If the command to execute on the remote host is an xterm, xrsh specifies 
that the default title for the new xterm will be "xterm@hostname"
where hostname is the name of the remote host.  This can also be
overridden by specifying your own -title argument on the xterm command
line.
.PP
Xrsh is very careful not to leave any extra processes 
on either the local or remote machine waiting around for the client to
exit.  In some remote environments (particularly some Sys V
implementations of csh and rsh), this is impossible and xrsh should be
run as a background command.
.SH OPTIONS
Note that xrsh options precede the given X command and its arguments.
.sp
.IP "\fB\-auth authtype\fP"
Choose what type of X authorization (or access control) is going to be
used.  Authtype can be one of "xhost", "xauth", "xhost-xterminal", "environment", or
"none".  The default is xhost, but the default can be set by setting
the value of the environment variable $XRSH_AUTH_TYPE.
.IP
If xhost is specified and the X server is running on the local
machine, xhost will be run locally to enable the remote host to open an X
connection.  If the server is on a third host (not the one where xrsh
is running and not the one where you wish to run the command), rsh will
be used to run xhost on the server host to authorize the host where
the command will be run.
.IP
If xauth is specified, then xrsh will merge the entries for the server from 
the local $XAUTHORITY file into that of the remote host using rsh.
.IP
The authtype xhost-xterminal is intended for use by people using X terminals.
If xhost-xterminal is used, then the first time xrsh is run, it runs xhost locally to 
enable the remote host for access.  This should work since (theoretically)
the first time it is run is on the XDMCP host for the X terminal.  From then
on it propagates the name of that host to all remote hosts via the environment
variable $XHOST.  In subsequent invocations from remote hosts, xrsh uses rsh
to connect to the host $XHOST and run xhost to enable new remote hosts.
.IP 
Authtype "none" does no explicit work for access control.  Use this if you 
don't enable access control or if you use another mechanism for access
control.
.IP
Finally, authtype "environment" automatically propagates the environment
variable $XAUTHORITY to remote hosts, assuming that it is an NFS 
mounted location that can be accessed from all hosts.
.IP "\fB-debug\fP"
Normally xrsh redirects standard input and standard output to
/dev/null in an effort to cause unneeded rshd and shell processes to
exit.  As a result, the user can't usually see any errors that might
occur (like a "Permission denied." from rsh).  If you are having
trouble getting xrsh to work with a remote host, try giving the -debug
switch to see if any errors are being generated.
.IP "\fB-debug2\fP"
This switch causes xrsh to turn on the -x option in the shell so that
the user can see every shell command executed by xrsh.  Only use this
script if you are debugging the xrsh code itself.
.IP "\fB-help\fP"
Print out the argument list to standard output.
.IP "\fB-l username\fP"
Use the -l switch to specify a different user name to use for logging
in via rsh on the remote host.
.IP "\fB-pass envlist\fP"
Envlist is a quote delimited string naming an arbitrary set of
environment variables to pass on to the shell environment on the
remote host.  If one wanted to set $XRSH_AUTH_TYPE and $XAUTHORITY to
the remote host, one could use: -pass "XRSH_AUTH_TYPE XAUTHORITY".  
A default set of environment variables to pass may be set using the
environment variable $XRSH_ENVS_TO_PASS.
.IP "\fB-screen screen-#\fP"
Specify a different screen on the server on which to display the
remote client.
.SH ENVIRONMENT
The environment variables XRSH_AUTH_TYPE and XRSH_ENVS_TO_PASS which
can be used to set switch defaults are overridden if the equivalent
switch is specified as well.
.IP "\fBXAUTHORITY\fP"
The $XAUTHORITY environment variable is passed to the remote host if
the authtype specified by -auth or $XRSH_AUTH_TYPE is "environment".
.IP "\fBXRSH_AUTH_TYPE\fP"
This environment variable can be used to specify the default type of
authorization or access control.  The values it can be set to are the
same as the values for the argument -auth.
.IP "\fBXRSH_RSH_ERRORS\fP"
If the environment variable XRSH_RSH_ERRORS is set to the name of a file, 
any rsh errors will appear in that file on the remote host.
If that variable is unset, error messages will be thrown away unless
the -debug switch is given. (Note: don't use ~ in the filename
because it will expand to ~ on the local host, but try to put the
errors in that file on the remote host.)    
.IP "\fBXRSH_ENVS_TO_PASS\fP"
.SH COMMON PROBLEMS
Make sure your PATH environment variable on the remote host is
set in your .cshrc or .bashrc so that rsh programs have
access to it.  (/bin/sh and /bin/ksh users have a hard time
time here since their shells don't execute any init files
under rsh.  You will have to type a full path to xrsh in that case.
(E.g.  xrsh remote-host /usr/bin/X11/xterm)  Ksh users may be
able to get their PATH set by having xrsh pass the ENV environment
variable to the remote shell.)
.PP
Make sure your PATH environment variable on the remote host
includes the directory containing the X programs.  This is 
often /usr/bin/X11 or /usr/local/bin/X11.
.PP
Make sure you have rsh configured to work on the remote host.
You can test this by typing:  rsh remote-host echo '$PATH'
This will prove that rsh works and show you the PATH that
will be used on the remote host.  If you get "Permission 
denied." you probably need to update your ~/.rhosts file
on the remote host.  See rlogin(1).
.SH EXAMPLES
.IP "xrsh yoda"
Start an xterm on the host yoda which displays on the current X
server.  Use xhost for access control.
.IP "xrsh -auth xauth underdog emacs"
Start an emacs on the host underdog.  Merge xauth authorization
entries for this server into the authority file on the remote host.
.IP "xrsh -l mjd -auth none -pass "XRSH_AUTH_TYPE" -debug tigger xterm -fn 5x7"
Start an xterm on the host tigger in a very small font, propagate the
environment variable $XRSH_AUTH_TYPE to the remote host, login to the
remote host using the id "mjd", don't do any specific authorization
and don't redirect standard/error output to /dev/null so I can see any errors.
.SH BUGS
.PP
If the values of the environment variables specified in -pass or
$XRSH_ENVS_TO_PASS contain quote characters, xrsh will have difficulty.
.PP
If the remote host can't resolve the hostname of the server host
(through /etc/hosts, DNS or NIS), the remote client will not be able
to open a connection to the server.
.PP
System V users should make sure the first line of the script begins
with colon (:).  As of Ultrix 4.2, Ultrix /bin/sh can't handle "set
--".  Ultrix users should make the first line of the script be
"#!/bin/sh5".
.SH SEE ALSO
.PP
xrlogin(1), rsh(1), xhost(1), xauth(1)
.SH AUTHOR
James J. Dempsey <jjd@bbn.com> with help and suggestions from many
people including gildea@expo.lcs.mit.edu, dm@think.com,
dgreen@cs.ucla.edu and rosen@cns.bu.edu,  <eero@whitechapel.media.mit.edu>, 
and  <martin@whitechapel.media.mit.edu>.
