dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ(2.13)

AC_DEFUN([CL_CLOSEDIR],
[AC_REQUIRE([CL_DIR_HEADER])dnl
AC_BEFORE([$0], [CL_FILECHARSET])dnl
CL_PROTO([closedir], [
CL_PROTO_RET([
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#include <$ac_header_dirent>
], [int closedir (DIR* dir);], [int closedir();],
cl_cv_proto_closedir_ret, int, void)],
[extern $cl_cv_proto_closedir_ret closedir (DIR*);])
AC_DEFINE_UNQUOTED(RETCLOSEDIRTYPE,$cl_cv_proto_closedir_ret,[closedir() return type])
if test $cl_cv_proto_closedir_ret = void; then
  AC_DEFINE(VOID_CLOSEDIR,,[closedir() return value is void or unusable])
else
  # The following test is necessary, because Cygwin32 declares closedir()
  # as returning int but the return value is unusable.
  AC_CACHE_CHECK(for usable closedir return value, cl_cv_func_closedir_retval,[
AC_TRY_RUN([
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
/* Declare opendir(), closedir(). */
#include <$ac_header_dirent>
]AC_LANG_EXTERN[
#if defined(__STDC__) || defined(__cplusplus)
DIR* opendir (OPENDIR_CONST char* dirname);
#else
DIR* opendir();
#endif
]AC_LANG_EXTERN[
#if defined(__STDC__) || defined(__cplusplus)
RETCLOSEDIRTYPE closedir (DIR* dirp);
#else
RETCLOSEDIRTYPE closedir();
#endif
int main() { exit(closedir(opendir(".")) != 0); }],
cl_cv_func_closedir_retval=yes, cl_cv_func_closedir_retval=no,
# When cross-compiling, don't assume a return value.
cl_cv_func_closedir_retval="guessing no")])
case "$cl_cv_func_closedir_retval" in
  *no) AC_DEFINE(VOID_CLOSEDIR,,[closedir() return value is void or unusable]) ;;
esac
fi
])
