/*	NAM - Name Block Definitions	*/
#ifndef _NAM_H
#define _NAM_H 1

struct	NAM	{
       unsigned char	nam$b_bid;		/* block identification */
#define			NAM$C_BID	2	/* block identification code */

       unsigned char	nam$b_bln;		/* block length */
#define			NAM$C_BLN	0x060	/* block length constant - V3 */
#define			NAM$K_BLN	0x060
#define			NAM$C_BLN_DIRWC 0x060
#define			NAM$K_BLN_DIRWC 0x060
#define			NAM$C_BLN_V2	0x038	/* block length constant - V2 */
#define			NAM$K_BLN_V2	0x038

       unsigned char	nam$b_rss;		/* resultant string area size */
#define			NAM$C_MAXRSS	255	/* maximum resultant name string size (network) */
#define			NAM$C_MAXRSSLCL 255	/* maximum resultant name string size (local) */

       unsigned char	nam$b_rsl;		/* resultant string length */
		char	*nam$l_rsa;		/* resultant string area address */

       unsigned char	nam$b_nop;			/* name options (currently undocumented) */
#define			NAM$V_PWD	0		/* return password if present in nodespec string */
#define			NAM$M_PWD	(1 << NAM$V_PWD)
#define			NAM$V_FILL_1	1
#define			NAM$M_FILL_1	(1 << NAM$V_FILL_1)
#define			NAM$V_FILL_2	2
#define			NAM$M_FILL_2	(1 << NAM$V_FILL_2)
#define			NAM$V_SYNCHK	3		/* Only do syntax check on $PARSE operation */
#define			NAM$M_SYNCHK	(1 << NAM$V_SYNCHK)
#define			NAM$V_NOCONCEAL 4		/* do not conceal device/root directory */
#define			NAM$M_NOCONCEAL (1 << NAM$V_NOCONCEAL)
#define			NAM$V_SLPARSE	5		/* parse search list */
#define			NAM$M_SLPARSE	(1 << NAM$V_SLPARSE)
#define			NAM$V_SRCHXABS	6		/* fill in attached XABS on $SEARCH ops over the network */
#define			NAM$M_SRCHXABS	(1 << NAM$V_SRCHXABS)

       unsigned char	nam$b_rfs;		/* remote file system type (currently undocumented) */
#define			NAM$C_UFS	0	/* unknown file system for remote file access, or
						   not applicable for local file access, or
						   not applicable for task to task operation */
#define			NAM$C_RMS11	1	/* RMS-11 */
#define			NAM$C_RMS20	2	/* RMS-20 */
#define			NAM$C_RMS32	3	/* RMS-32 */
#define			NAM$C_FCS11	4	/* FCS-11 */
#define			NAM$C_RT11FS	5	/* RT-11 file system */
#define			NAM$C_TOPS20FS	7	/* TOPS-20 file system */
#define			NAM$C_TOPS10FS	8	/* TOPS-10 file system */
#define			NAM$C_RMS32S	10	/* RMS-32 Subset (VAXElan) */

       unsigned char	nam$b_ess;		/* expanded string area size */
       unsigned char	nam$b_esl;		/* expanded string length */
		char	*nam$l_esa;		/* expanded string area address */

	 struct NAM	*nam$l_rlf;		/* related file NAM block address */
#define			NAM$C_DVI	16	/* length of dvi field */

		char	nam$t_dvi[NAM$C_DVI];	/* device id */
       unsigned short	nam$w_fid[3];		/* file id */
       unsigned short	nam$w_did[3];		/* directory id */

       unsigned int	nam$l_wcc;		/* wild card context */
#define			NAM$V_IFI	16		/* Internal file identifier */
#define			NAM$M_IFI	(1 << NAM$V_IFI)
#define			NAM$V_SRCHNMF	30		/* no-more-files has been encountered on $SEARCH */
#define			NAM$M_SRCHNMF	(1 << NAM$V_SRCHNMF)
#define			NAM$V_SVCTX	31		/* save context across search calls */
#define			NAM$M_SVCTX	(1 << NAM$V_SVCTX)

       unsigned int	nam$l_fnb;				/* file name status bits */
#define			NAM$V_EXP_VER	0			/* version number is explicit */
#define			NAM$M_EXP_VER	(1 << NAM$V_EXP_VER)
#define			NAM$V_EXP_TYPE	1			/* file type is explicit */
#define			NAM$M_EXP_TYPE	(1 << NAM$V_EXP_TYPE)
#define			NAM$V_EXP_NAME	2			/* file name is explicit */
#define			NAM$M_EXP_NAME	(1 << NAM$V_EXP_NAME)
#define			NAM$V_WILD_VER	3			/* version number containes a wild card */
#define			NAM$M_WILD_VER	(1 << NAM$V_WILD_VER)
#define			NAM$V_WILD_TYPE 4			/* file type containes a wild card */
#define			NAM$M_WILD_TYPE (1 << NAM$V_WILD_TYPE)
#define			NAM$V_WILD_NAME 5			/* file name containes a wild card */
#define			NAM$M_WILD_NAME (1 << NAM$V_WILD_NAME)
#define			NAM$V_EXP_DIR	6			/* directory spec is explicit */
#define			NAM$M_EXP_DIR	(1 << NAM$V_EXP_DIR)
#define			NAM$V_EXP_DEV	7			/* device name is explicit */
#define			NAM$M_EXP_DEV	(1 << NAM$V_EXP_DEV)
#define			NAM$V_WILDCARD	8			/* file name string includes a wild card (inclusive
								   or of other wild card bits) */
#define			NAM$M_WILDCARD	(1 << NAM$V_WILDCARD)
#define			NAM$V_SEARCH_LIST 11			/* search list present */
#define			NAM$M_SEARCH_LIST (1 << NAM$V_SEARCH_LIST)
#define			NAM$V_CNCL_DEV	12			/* device name is a concealed device */
#define			NAM$M_CNCL_DEV	(1 << NAM$V_CNCL_DEV)
#define			NAM$V_ROOT_DIR	13			/* device name incorporates a root directory */
#define			NAM$M_ROOT_DIR	(1 << NAM$V_ROOT_DIR)
#define			NAM$V_LOWVER	14			/* lower numbered version(s) of the file exist(s) */
#define			NAM$M_LOWVER	(1 << NAM$V_LOWVER)
#define			NAM$V_HIGHVER	15			/* higher numbered version(s) of the file exist(s) */
#define			NAM$M_HIGHVER	(1 << NAM$V_HIGHVER)
#define			NAM$V_PPF	16			/* indirectly accessed process permanent file */
#define			NAM$M_PPF	(1 << NAM$V_PPF)
#define			NAM$V_NODE	17			/* file specification includes a node name */
#define			NAM$M_NODE	(1 << NAM$V_NODE)
#define			NAM$V_QUOTED	18			/* file spec includes a quoted string */
#define			NAM$M_QUOTED	(1 << NAM$V_QUOTED)
#define			NAM$V_GRP_MBR	19			/* directory spec is of group-member number format */
#define			NAM$M_GRP_MBR	(1 << NAM$V_GRP_MBR)
#define			NAM$V_WILD_DIR	20			/* directory spec includes a wild card */
#define			NAM$M_WILD_DIR	(1 << NAM$V_WILD_DIR)
#define			NAM$V_DIR_LVLS	21			/* number of subdirectory levels (0 = ufd only) */
#define			NAM$S_DIR_LVLS	3
#define			NAM$M_DIR_LVLS	(7 << NAM$V_DIR_LVLS)

/* separate byte for wild card directory flags */
#define			NAM$V_WILD_UFD	24			/* user file directory spec includes a wild card */
#define			NAM$M_WILD_UFD	(1 << NAM$V_WILD_UFD)
#define			NAM$V_WILD_SFD1 25			/* subfile directory 1 spec includes a wild card */
#define			NAM$M_WILD_SFD1 (1 << NAM$V_WILD_SFD1)
#define			NAM$V_WILD_SFD2 26			/* sfd2 includes a wild card */
#define			NAM$M_WILD_SFD2 (1 << NAM$V_WILD_SFD2)
#define			NAM$V_WILD_SFD3 27			/* sfd3 includes a wild card */
#define			NAM$M_WILD_SFD3 (1 << NAM$V_WILD_SFD3)
#define			NAM$V_WILD_SFD4 28			/* sfd4 includes a wild card */
#define			NAM$M_WILD_SFD4 (1 << NAM$V_WILD_SFD4)
#define			NAM$V_WILD_SFD5 29			/* sfd5 includes a wild card */
#define			NAM$M_WILD_SFD5 (1 << NAM$V_WILD_SFD5)
#define			NAM$V_WILD_SFD6 30			/* sfd6 includes a wild card */
#define			NAM$M_WILD_SFD6 (1 << NAM$V_WILD_SFD6)
#define			NAM$V_WILD_SFD7 31			/* sfd7 includes a wild card */
#define			NAM$M_WILD_SFD7 (1 << NAM$V_WILD_SFD7)

/* alternate definitions for wild_ufd and wild_sfd1 */
#define			NAM$V_WILD_GRP	24			/* group containes a wild card */
#define			NAM$M_WILD_GRP	(1 << NAM$V_WILD_GRP)
#define			NAM$V_WILD_MBR	25			/* member containes a wild card */
#define			NAM$M_WILD_MBR	(1 << NAM$V_WILD_MBR)

/*  Extend the NAM Block by 40 bytes */

       unsigned char	nam$b_node;		/* node name string length */
       unsigned char	nam$b_dev;		/* device string length */
       unsigned char	nam$b_dir;		/* directory string length */
       unsigned char	nam$b_name;		/* file name string length */
       unsigned char	nam$b_type;		/* file type string length */
       unsigned char	nam$b_ver;		/* file version string length */

		unsigned	: 16;		/* currently unused */

		char	*nam$l_node;		/* node name string address */
		char	*nam$l_dev;		/* device string address */
		char	*nam$l_dir;		/* directory string address */
		char	*nam$l_name;		/* file name string address */
		char	*nam$l_type;		/* file type string address */
		char	*nam$l_ver;		/* file version string address */

		unsigned	: 32;		/* currently unused */
		unsigned	: 32;		/* currently unused */
		};

extern int cc$rms_nam();
#define cc$rms_nam (*(struct NAM *) cc$rms_nam)
/* globalref struct NAM cc$rms_nam;	   /* Declare initialized prototype data structure */


#endif
