#define EOF      -1
#define MAXLINE 133
#define TEN         100
#define MAXTEN    13300
#define SPACE     3
#define CP_ int

#include <stdio.h>

main(argc, argv)
int argc;
CP_ argv;
/*-
   Routine to take stdin and create a document on stdout.  A "document"
   is all comments lines starting with /*- and ending with
*/
/*-
   In addition, this program will also output up to 10 lines before the
   /*- comment until a blank line is found (going in reverse up the document).
*/
{
/* Variables
   comment- Value 0 means no comment seen yet, value 1 comment, value 2 end.
*/
   int i, comment, top, end_of_file, empty, blanks, save, nlines;
   char buffer[MAXTEN];

#ifdef VMS
   redirect(&argc,argv,0); /*  - redirect standard I/O (from chj) */
#endif

   if (argc != 1) useage();

   comment = 0;
   empty   = 0;
   save    = 0;
   top     = TEN;


   do {
      end_of_file = fillup (buffer, MAXLINE, TEN, save, &nlines);
   /* Cycle through the current buffer, locate top. */

      for (top = top + save - TEN, i = save; i < nlines; i++) {
         test (buffer+MAXLINE*i, MAXLINE, &empty, &comment);
         if (comment > 0) {
            for (; top < i; top++)
               putout (buffer+MAXLINE*top, MAXLINE);
            top = TEN;
            putout (buffer+MAXLINE*i, MAXLINE);
            save = 0;
         }
         if (comment == 2) {
              putspace (SPACE);
              top = i+1;
         }
         if (comment == 0) save++;
         if (empty && comment == 0) top = i + 1;

      /* Save the least number of lines necessary. */
         save = TEN - top > save ? save : TEN - top;

      /* Be sure that at least one new line is read in. */
         save = save >= TEN ? TEN - 1 : save;
      }
   } while (end_of_file != EOF);

   exit(0);
}


docopy (src, dst, max)
char *src, *dst;
int max;
/*-
   Routine to copy src to dst up to and including the '\n' character,
   not more than max characters will be copied, however.
-*/
{
   while (*src != '\n' && max--)
      *dst++ = *src++;
   *dst = '\n';
}


error (string)
char *string;
/*-
   Routine to print a string and then die.
-*/
{
   while (*string) putchar(*string++);
   putchar('\n');
}


fillup (buffer, maxline, size, save, nlines)
char *buffer;
int maxline, size, save, *nlines;
/*-
   Routine to fill a buffer at offsets maxline for size lines from stdin.
   The buffer will "slide" up by size-save number of lines (eg save = 4 means
   that the last 4 lines will become the top 4 lines).

   Parameters:

       buffer: maxline*size character array.

      maxline: length of longest line (until a '\n' is seen).

         size: number of lines the buffer can hold.

         save: number of lines from previous buffer to save as top lines
               of this new buffer.

       nlines: number of active lines in this buffer (returned).
-*/
{
   int line, count;
   char *ptr;

   line  = 0;
   count = 0;

/* Save the bottom lines by rearranging them as the top lines. */
   for (line = 0; line < save; line++)
      docopy (buffer+maxline*(size-save+line), buffer+maxline*line, maxline);

/* Read in some more lines.  fgets fills in up to maxline characters. */
   while (line < size && 
         (ptr = fgets(&buffer[maxline*line++], maxline, stdin)) != NULL);

/* Return the number of active lines in the buffer. */
   *nlines = line;
   return (ptr == NULL ? EOF : 1);   /* eof tested in calling routine */
}


putout (buffer, maxline)
char *buffer;
int maxline;
/*-
   Routine to put the buffer out to stdout until either maxline is
   reached or a newline is reached.
-*/
{
   do {
      putchar (*buffer);
      if (*buffer++ == '\n')
         return;
   } while (maxline--);
}


putspace (space)
int space;
/*-
   Routine to put space around each seperate comment block.
-*/
{
   putchar ('\n');
   while (space--)
      putchar('-');
   putchar ('\n');
}


test (buffer, maxline, empty, comment)
char *buffer;
int maxline, *empty, *comment;
/*-
   Routine to test buffer and determine if it is empty (all white space)
   or if comment should toggle.  Comment is set to 1 when it is 0 and then
   a run of /*- is seen.  Comment is set to 0 when it is 1 and a closing
   'C' comment is seen, like this:
*/
{
   if (*comment == 2)
      *comment = 0;     /* Turn off comment indicator */

   *empty = 1;
   while (*buffer == ' ' || *buffer == '\t' || *buffer == '\n') {
      maxline--;
      if (*buffer == '\n' || maxline == 0)
         return;
      buffer++;
   }
   
/* buffer now points at a non-blank character. */
   *empty = 0;

/* Check to see if start of comment is anywhere on this line. */
   while (*(buffer+1) != '\n' && maxline > 0) {
      if (*buffer == '/' && *(buffer+1) == '*' && *(buffer+2) == '-')
         *comment = 1;
      if (*comment == 1 && *buffer == '*' && *(buffer+1) == '/')
         *comment = 2;
      buffer++;
      maxline--;
   }
}


useage()
/*-
   Explain the useage of docu:

   docu <stdin >stdout

   (strips document comments out of 'C' code)
*/
{
   static char *mess1 = "docu <stdin >stdout",
               *mess2 = "(strips document comments out of 'C' code)";

   while (*mess1) putchar (*mess1++);
   putchar('\n');
   while (*mess2) putchar (*mess2++);
   putchar ('\n');
   exit(1);
}
