
#ifndef lint
static char    *copyright = "Copyright (C) 1994, Steve Cumming";
#endif

/*
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#include <stdio.h>
#include <math.h>
#include "gp.h"
#include "lib.h"
/*
#include "limits.h"
#include "values.h"
*/


/*
  do bounds checking later

  in conversion to integer use rint, 
  which used the current IEEE rounding direction.

  in place conversion

*/

int gp_result_undef;

struct value * new_value(enum DATA_TYPES type){
    struct value * v = (struct value *)xalloc(sizeof(struct value),"new_value");
    v->type = type;
    return v;
}

struct value * 
    coerce_value(struct value * v, enum DATA_TYPES type){
	int i;
	float f;
	double d;
	struct cmplx c;
	
	if (v->type == type)
	    return v;

	switch (v->type) {
	case INT:
	    i = v->v.int_val;
	    switch (type) {
	    case INT:
		break;
	    case FLOAT:
		v->v.f_val = i;
		v->type = FLOAT;
		break;
	    case DOUBLE:
		v->v.d_val = i;
		v->type = DOUBLE;
		break;
	    case CMPLX:
		c.real = i;
		c.imag = 0.0;
		v->v.cmplx_val = c;
		v->type = CMPLX;
		break;
	    default:
		fatal("coerce_value: illegal source type");
		break;
	    }
	    break;
	case FLOAT:
	    f = v->v.f_val;
	    switch (type) {
	    case INT:
		v->v.int_val = rint((double)f);
		v->type = INT;
		break;
	    case FLOAT:
		break;
	    case DOUBLE:
		v->v.d_val = f;
		v->type = DOUBLE;
		break;
	    case CMPLX:
		c.real = f;
		c.imag = 0.0;
		v->v.cmplx_val = c;
		v->type = CMPLX;
		break;
	    default:
		fatal("coerce_value: illegal source type");
		break;
	    }
	    break;
	case DOUBLE:
	    d = v->v.d_val;
	    switch (type) {
	    case INT:
		v->v.int_val = rint(d);
		v->type = INT;
		break;
	    case FLOAT:
		v->v.f_val = (float) d;
		v->type = FLOAT;
		break;
	    case DOUBLE:
		break;
	    case CMPLX:
		c.real = d;
		c.imag = 0.0;
		v->v.cmplx_val = c;
		v->type = CMPLX;
		break;
	    default:
		fatal("coerce_value: illegal source type");
		break;
	    }
	    break;
	case CMPLX:
	    switch (type){
	    case CMPLX:
		break;
	    default:
		fatal("coerce_value: illegal source type");
		break;
	    }
	    break;
	case GP_UNDEF:
	    v->type = type;
	    switch (type){
	    case INT:
		v->v.int_val = 0;
		break;
	    case FLOAT:
		v->v.f_val = 0.;
		break;
	    case DOUBLE:
		v->v.d_val = 0.;
		break;
	    case CMPLX:
		v->v.cmplx_val.real = v->v.cmplx_val.imag = 0.;
		break;
	    case STR:
		v->v.str_val = "";
		break;
	    default:
		fatal("coerce_value: bad type");
		break;
	    }
	    break;
	default:
	    fatal("coerce_value: illegal object type");
	    break;
	}
	return v;
    }


static char gp_tmp[128];
static char t_tmp[128];
char * type_to_string(enum DATA_TYPES type){
    switch(type){
    case INT:
	strcpy(t_tmp,"int");
	break;
    case FLOAT:
	strcpy(t_tmp,"float");
	break;
    case DOUBLE:
	strcpy(t_tmp,"double");
	break;
    case CMPLX:
	strcpy(t_tmp,"cmplx");
	break;
    case STR:
	strcpy(t_tmp,"string");
	break;
    default:
	error("type_to_string: invalid type");
	break;
    }
    return t_tmp;
}

enum DATA_TYPES type_from_string(char * str){
    if (!strcmp(str,"int"))
	return INT;
    if (!strcmp(str,"float"))
	return FLOAT;
    if (!strcmp(str,"double"))
	return DOUBLE;
    if (!strcmp(str,"cmplx"))
	return CMPLX;	
    if (!strcmp(str,"string"))
	return STR;	
    
    error("type_from_string: invalid type");
    return GP_ILLEGAL;
}

char * value_to_string(struct value * v) {

    switch (v->type) {
    case INT:
	sprintf(gp_tmp,"%d",v->v.int_val);
	break;
    case FLOAT:
	sprintf(gp_tmp,"%f",(double)v->v.f_val);
	break;
    case DOUBLE:
	sprintf(gp_tmp,"%f",v->v.d_val);
	break;
    case CMPLX:
	sprintf(gp_tmp,"{%f,%f}",v->v.cmplx_val.real,v->v.cmplx_val.imag);
	break;
    case STR:
	strcpy(gp_tmp,v->v.str_val);
	break;
    default:
	error("value_to_string: illegal type");
	break;
    }
    return gp_tmp;
}


void	string_to_value(char * str, enum DATA_TYPES type, struct value * val){
    int n;
    int oops= 0;
    switch (type) {
    case INT:
	n = sscanf(str,"%d",&(val->v.int_val));
	if (n != 1)
	    oops = 1;
	break;
    case FLOAT:
	n = sscanf(str,"%f",&(val->v.f_val));
	if (n != 1)
	    oops = 1;
	break;
    case DOUBLE:
	n = sscanf(str,"%lf",&(val->v.d_val));
	if (n != 1)
	    oops = 1;
	break;
    case CMPLX:
	n = sscanf(str,"{%lf,%lf}",&(val->v.cmplx_val.real),&(val->v.cmplx_val.imag));
	if (n != 2)
	    oops = 1;
	break;
    case STR:
	val->v.str_val = xstrdup(str,"read_map()");
	break;
    default:
	error("string_to_value: illegal type");
	break;
    }
    if (oops)
	error("string_to_value: bad string!");
    val->type = type;
    return;
}


struct value *
Complex(struct value *a, double realpart, double imagpart)
{
	a->type = CMPLX;
	a->v.cmplx_val.real = realpart;
	a->v.cmplx_val.imag = imagpart;
	return(a);
}


struct value *
Integer(struct value *a,int i)
{
	a->type = INT;
	a->v.int_val = i;
	return(a);
}

struct value *
Float(struct value * a, float f)
{
	a->type = FLOAT;
	a->v.f_val = f;
	return(a);
}

struct value *
Double(struct value * a, double d)
{
	a->type = DOUBLE;
	a->v.d_val = d;
	return(a);
}

struct value * 
String(struct value * a, char * str){
    a->type = STR;
    a->v.str_val = str;
    return(a);
}

struct value * 
Pointer(struct value * a, void * p){
    a->type = POINTER;
    a->v.str_val = p;
    return(a);
}

/*
  This is <NOT> complete across all types
*/


int eq(struct value * a, struct value * b){
    register int result;
    switch(a->type) {
    case INT:
	switch (b->type) {
	case INT:
	    result = (a->v.int_val ==
		      b->v.int_val);
	    break;
	case FLOAT:
	    result = (float)a->v.int_val ==  b->v.f_val;
	    break;
	case DOUBLE:
	    result = (double)a->v.int_val ==  b->v.d_val;
	    break;
	default:
	    fatal("eq: bad types");
	    break;
	}
	break;

    case FLOAT:
	switch (b->type){
	case INT:
	    result = a->v.f_val == (float) b->v.int_val;
	    break;
	case FLOAT:
	    result = a->v.f_val == b->v.f_val;
	    break;
	case DOUBLE:
	    result = (double)a->v.f_val == b->v.d_val;
	    break;
	default:
	    fatal("eq: bad types");
	    break;
	}
	break;
    case DOUBLE:
	switch (b->type){
	case INT:
	    result = a->v.d_val == (double) b->v.int_val;
	    break;
	case FLOAT:
	    result = a->v.d_val == (double)b->v.f_val;
	    break;
	case DOUBLE:
	    result = a->v.d_val == b->v.d_val;
	    break;
	default:
	    fatal("eq: bad types");
	    break;
	}
	break;
	
    case CMPLX:
	switch (b->type) {
	case INT:
	    result = (b->v.int_val == a->v.cmplx_val.real &&
		      a->v.cmplx_val.imag == 0.0);
	    break;
	case CMPLX:
	    result = (a->v.cmplx_val.real==
		      b->v.cmplx_val.real &&
		      a->v.cmplx_val.imag==
		      b->v.cmplx_val.imag);
	    break;
	}
	break;
    case STR:
	switch (b->type){
	case STR:
	    result = !strcmp(b->v.str_val, a->v.str_val);
	    break;
	default:
	    fatal("eq: bad compare");
	    break;
	}
	break;
    case POINTER:
	switch (b->type){
	case POINTER:
	    result = (b->v.ptr_val == a->v.ptr_val);
	    break;
	default:
	    fatal("eq: bad compare: pointer.");
	    break;
	}
	break;
    default:	
	fatal("eq illegal type");
	break;
    }
    return result;
}


int is_zero(struct value *v){
    int r;
    switch (v->type){
    case INT:
	r = !v->v.int_val;
	break;
    case FLOAT:
	r = (v->v.f_val == 0.0);
	break;
    case DOUBLE:
	r = (v->v.d_val == 0.0);
	break;
    default:
	r = 0;
	break;
    }
    return r;
}



/*
  this works only because we recognise only two types at present 
  by a fluke, the pointer type does not break it;
*/

enum DATA_TYPES 
    highest_type(enum DATA_TYPES a, enum DATA_TYPES b){
	if (a==b)
	    return a;
	if (a == INT)
	    return b;
	return a;
    }


/*
  This returns the result of 
  a op b, with type according to KR

  result is volatile
*/

struct value * gp_binary(struct value * a, struct value * b, enum GP_OPS op)
{
    struct value r;    
    enum DATA_TYPES t = highest_type(a->type, b->type);
    struct value ta, tb;

    ta = * a;
    tb = * b;

    gp_result_undef = 0;

    (void) coerce_value(&ta,t);
    (void) coerce_value(&tb,t);

    r.type = t;
    switch (op) {
    case GP_DIVIDE:
	switch (t){
	case INT:
	    r.v.int_val = ta.v.int_val / tb.v.int_val;
	    break;
	case FLOAT:
	    r.v.f_val = ta.v.f_val / tb.v.f_val;
	    break;
	case DOUBLE:
	    r.v.d_val = ta.v.d_val / tb.v.d_val;
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	gp_result_undef = is_zero(&tb);
	break;
    case GP_MULTIPLY:
	switch (t){
	case INT:
	    r.v.int_val = ta.v.int_val * tb.v.int_val;
	    break;
	case FLOAT:
	    r.v.f_val = ta.v.f_val * tb.v.f_val;
	    break;
	case DOUBLE:
	    r.v.d_val = ta.v.d_val * tb.v.d_val;
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	break;
    case GP_ADD:
	switch (t){
	case INT:
	    r.v.int_val = ta.v.int_val + tb.v.int_val;
	    break;
	case FLOAT:
	    r.v.f_val = ta.v.f_val + tb.v.f_val;
	    break;
	case DOUBLE:
	    r.v.d_val = ta.v.d_val + tb.v.d_val;
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	break;
    case GP_SUBTRACT:
	switch (t){
	case INT:
	    r.v.int_val = ta.v.int_val - tb.v.int_val;
	    break;
	case FLOAT:
	    r.v.f_val = ta.v.f_val - tb.v.f_val;
	    break;
	case DOUBLE:
	    r.v.d_val = ta.v.d_val - tb.v.d_val;
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	break;
    default:
	fatal("gp_binary(): illegal operator\n");
    }
    return &r;
}




/*
  This returns the result of 
  a op b, with type according to KR

  result is volatile
*/

int  gp_relation(struct value * a, struct value * b, enum GP_RELS op)
{
    int r;
    enum DATA_TYPES t = highest_type(a->type, b->type);
    struct value ta, tb;

    ta = * a;
    tb = * b;

    gp_result_undef = 0;

    (void) coerce_value(&ta,t);
    (void) coerce_value(&tb,t);

    r = -1;
    switch (op) {
    case GP_EQ:
	switch (t){
	case INT:
	    r = (ta.v.int_val == tb.v.int_val);
	    break;
	case FLOAT:
	    r = (ta.v.f_val ==  tb.v.f_val);
	    break;
	case DOUBLE:
	    r = (ta.v.d_val == tb.v.d_val);
	    break;
	case STR:
	    r = !strcmp(ta.v.str_val, tb.v.str_val);
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	gp_result_undef = (r < 0);
	break;

    case  GP_NE:
	switch (t){
	case INT:
	    r = (ta.v.int_val != tb.v.int_val);
	    break;
	case FLOAT:
	    r = (ta.v.f_val !=  tb.v.f_val);
	    break;
	case DOUBLE:
	    r = (ta.v.d_val != tb.v.d_val);
	    break;
	case STR:
	    r = strcmp(ta.v.str_val, tb.v.str_val);
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	gp_result_undef = (r < 0);
	break;

    case GP_LT:
	switch (t){
	case INT:
	    r = (ta.v.int_val < tb.v.int_val);
	    break;
	case FLOAT:
	    r = (ta.v.f_val <  tb.v.f_val);
	    break;
	case DOUBLE:
	    r = (ta.v.d_val < tb.v.d_val);
	    break;
	case STR:
	    r = (strcmp(ta.v.str_val, tb.v.str_val) == -1);
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	gp_result_undef = (r < 0);
	break;

    case GP_LE:
	switch (t){
	case INT:
	    r = (ta.v.int_val <= tb.v.int_val);
	    break;
	case FLOAT:
	    r = (ta.v.f_val <=  tb.v.f_val);
	    break;
	case DOUBLE:
	    r = (ta.v.d_val <= tb.v.d_val);
	    break;
	case STR:
	    r = (strcmp(ta.v.str_val, tb.v.str_val) != 1);
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	gp_result_undef = (r < 0);
	break;

    case GP_GT:
	switch (t){
	case INT:
	    r = (ta.v.int_val > tb.v.int_val);
	    break;
	case FLOAT:
	    r = (ta.v.f_val >  tb.v.f_val);
	    break;
	case DOUBLE:
	    r = (ta.v.d_val > tb.v.d_val);
	    break;
	case STR:
	    r = (strcmp(ta.v.str_val, tb.v.str_val) == 1);
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	gp_result_undef = (r < 0);
	break;

    case GP_GE:
	switch (t){
	case INT:
	    r = (ta.v.int_val >= tb.v.int_val);
	    break;
	case FLOAT:
	    r = (ta.v.f_val >=  tb.v.f_val);
	    break;
	case DOUBLE:
	    r = (ta.v.d_val >= tb.v.d_val);
	    break;
	case STR:
	    r = (strcmp(ta.v.str_val, tb.v.str_val) != -1);
	    break;
	default:
	    fatal("gp_binary(): illegal type\n");
	    break;
	}
	gp_result_undef = (r < 0);
	break;
    default:
	fatal("gp_relation(): illegal operator\n");
    }
    return r;
}




struct value * gp_unary(struct value * a, enum GP_OPS op)
{
    enum DATA_TYPES t = a->type;
    struct value r;
    r = *a;

    switch (op) {
    case GP_INCREMENT:
	switch (t){
	case INT:
	    r.v.int_val++;
	    break;
	case FLOAT:
	    r.v.f_val++;
	    break;
	case DOUBLE:
	    r.v.d_val++;
	    break;
	default:
	    fatal("unary_op(): illegal type\n");
	    break;
	}
	break;
    default:
	fatal("unary_op(): illegal operator\n");
    }
    return &r;
}


char * gp_op_to_string(enum GP_OPS op){
    char * r;
    switch (op){
    case GP_ADD:
	r = " + ";
	break;
    case GP_MULTIPLY:
	r = " * ";
	break;
    case GP_SUBTRACT:
	r = " - ";
	break;
    case GP_DIVIDE:
	r = " / ";
	break;
    case GP_INCREMENT:
	r = " ++ ";
	break;
    default:
	r = "NOP";
	break;
    }
    return r;
}
