/*
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */


#ifndef HISTGENH
#define HISTGENH
#ifdef MAPS
#include "mapgen.h"
#endif

#define HIST_NULL -1
#define HIST_OK   0

#define LOG_BIN -1

struct array * binify(struct array *, int, double, double);
struct array * binify_sum(struct array *, struct array *, int, double, double);
struct array * log_binify(struct array *, double, double);
struct array * log_binify_sum(struct array *, struct array *,  double, double);
struct array * csum_array_in_place(struct array *);
struct array * cdf_array_in_place(struct array *, int);
struct array * pdf_array_in_place(struct array *, int);

#ifdef MAPS

struct bin2d {
    struct array * xtics;
    struct array * xtics1;
    struct array * ytics;
    struct array * ytics1;
    char ** s;
    char * title;
    int n;
    struct map ** m;
};
    
extern struct array * get_dist(FILE * , struct value * (*)(char *, int *));
extern struct map   * dist_map(struct map *, struct value * (*)(char *, int *),char * );
void dist_map2(struct map *, struct map **, struct map **, 
	       int (*)(struct stand *),
	       struct value * (*)(struct stand *),
       	       struct value * (*)(struct stand *), 
	       double p, char *);

void get_dist2(FILE *, int (*)(struct stand *),
	       struct value * (*)(struct stand *),
       	       struct value * (*)(struct stand *), 
	       struct array **, struct array **,
	       double p);

void make_arrays(struct map *, int (*)(struct stand *),
	       struct value * (*)(struct stand *),
       	       struct value * (*)(struct stand *), 
	       struct array **, struct array **,
	       double ,
	       char *);

void make_array(struct map *, int (*)(struct stand *),
	       struct value * (*)(struct stand *),
	       struct array **,
	       char *);

void dist_map1(struct map *, struct map **,
	       int (*)(struct stand *),
	       struct value * (*)(struct stand *),
	       char *);

void get_dist1(FILE *, int (*)(struct stand *),
	       struct value * (*)(struct stand *),
	       struct array **);

struct bin2d * newbin2d(int, int, int);
void free_bin2d(struct bin2d * );
struct bin2d * make_bin2d(void * , void * , char *, int , int, int);
void write_bin2d(struct bin2d * , FILE * );
#endif /* MAPS */

#endif /* HISTGEN */
