/*
  This module contains source for a variety of my
  private library rouines, not all of which are used
  in any particular application.

  Copyright Steve Cumming, 1991, except where noted below.
  
*/

#include <string.h>
#include <sys/param.h>
#include <malloc.h>
#include "lib.h"

#ifdef GARBAGE
extern void Garbage_Collect(void);
#else
void
Garbage_Collect(void){

	return;
}
#endif 

int MallocDebug = 0;

void
heapcheck(void){
    if (MallocDebug)
#ifdef MallocD
	if (!malloc_verify())
	    fatal("Heap mungled!\n");
#endif
    return;
}


void
fatal(char * msg){
	fputs(msg,stderr);
	fprintf(stderr,"\nexiting...\n");
	if (Debug)
	    abort();
	else
	    exit(1);
}

void 
error(char *msg){
	fputs(msg,stderr);
	return;
}

void
bchar(char *s, int n, char c)
{
	while (n-- > 0)
		*s++ = c;
	return;
}


#ifdef NOCOPY
/*
 * cheap and slow version of memcpy() in case you don't have one
 */
void
memcpy(dest,src,len)
char *dest,*src;
unsigned int len;
{
	while (len--)
		*dest++ = *src++;
}
#endif /* NOCOPY */


/*
	string pool 
*/

struct spool *spool;

/*
 * save_str() saves the string str into the string pool,
 * appending  a null.  No more than POOLSZ chars are copied.
 */

char *
save_str(s)
char s[];
{
register int i = 0;
register int count;
char * str;
count = strlen(s);
if ((count +1 ) > POOLSZ){
    count = POOLSZ - 1;
    fatal("Name too long");
}

if (spool == NULL){
    spool = (struct spool*)xalloc(sizeof(struct spool),"save_str");
    spool->offset = 0;
}
    
if ((count + 1) > (POOLSZ - spool->offset)) {
    struct spool * foo = (struct spool * ) xalloc(sizeof(struct spool),"save_str");
    spool->nxt = foo;
    foo->offset  = 0;
    foo->nxt = (struct spool *)NULL;
    foo->prev = spool;
    spool = foo;
}

str = &spool->pool[spool->offset];
do {
	str[i] = s[i];
	i++;
	} while (i < count);
str[i] = '\0';
spool->offset += count + 1;
return(str);
}

/*
  This routine frees all the string pools, in case we ever need to do this
*/

void 
f_spool(){
    struct spool * s = spool;
    while (s != NULL){
	s = s->nxt;
	free(s);
    }
   return;
}


char * nxt_token(FILE * f) {
    static char buf[128];	
    int n;
    int c;
 nxt_token_again:
    while ((c = fgetc(f)) != EOF)
	if (!isspace(c))
	    break;
    if (c == EOF)
	return 0x0;
    n = 0;
    if (c == '"'){
	while((c = fgetc(f)) != '"')
	    buf[n++] = (char)c;
    }
    else 
	do {
	    buf[n++] = (char)c;
	    c = fgetc(f);
	} while ( !isspace(c) && c != EOF);

    buf[n] = 0x0;

    if (buf[0] == '#'){
	while (c != '\n')
	    c = fgetc(f);
	goto nxt_token_again;
    }
    return buf;
}



char * nth_token(FILE * f,int tok) {
    static char buf[128];	
    int n;
    int c;
    int nr = 1;
 nxt_token_again:
    while ((c = fgetc(f)) != EOF)
	if (!isspace(c))
	    break;
    if (c == EOF)
	return 0x0;
    n = 0;
    if (c == '"'){
	while((c = fgetc(f)) != '"')
	    buf[n++] = (char)c;
    }
    else 
	do {
	    buf[n++] = (char)c;
	    c = fgetc(f);
	} while ( !isspace(c) && c != EOF);

    buf[n] = 0x0;

    if (buf[0] == '#'){
	while (c != '\n' && c != EOF)
	    c = fgetc(f);
	nr = 1;
	goto nxt_token_again;
    }

    if (tok == 0)
	return buf;

    if (nr++ != tok)
	goto nxt_token_again;
    while (c != '\n' && c != EOF)
	c = fgetc(f);
		
    return buf;
}

    
/* 
	returns next non-comment line from file f into buf 
*/

int 
get_nxt_line(FILE * f, char * buf)
{
    char * err;
    do{
	err = fgets(buf,256,f);
    } while (buf[0] == '#' && err);
    if (err != buf){
	return 1;
    }
    return 0;
}



void
xstrcat(char ** head, char  * tail){
    int n,m;
    char * tmp;
    if (*head == NULL){
	*head = strdup(tail);
    }
    else {
	n = strlen(*head);
	m = strlen(tail);
	tmp = xalloc(n + m + 1, "xtrcat");
	strcpy(tmp,*head);
	free(*head);
	strcat(tmp,tail);
	*head = tmp;
    }	
    return;
}    		


void
xstrncat(char ** head, char  * tail,int m){
    int n;
    char * tmp;
    if (*head == NULL){
	*head = xalloc(m + 1,"xstrncat");
	strncpy(*head,tail,m);
	(*head)[m] = '\0';
    }
    else {
	n = strlen(*head);
	tmp = xalloc(n + m + 1, "xstrncat");
	strcpy(tmp,*head);
	free(*head);
	strncat(tmp,tail,m);
        tmp[n + m] = '\0';
	*head = tmp;
    }	
    return;
}    		

char *
xstrdup(char * str, char * msg) {
	char * new;
	int n;
	if (str == NULL)
	    return str;
	n  = strlen(str) + 1;
	new = (char *)xalloc(n ,msg);
	return strcpy(new,str);
}

	    
/* alloc:
 * allocate memory 
 * This is a protected version of malloc. It causes an int_error 
 * if there is not enough memory, but first it tries free_stuff();
 * to make some room, and tries again. If message is NULL, we 
 * allow NULL return. Otherwise, we handle the error, using the
 * message to create the int_error string.
 */

void *
xalloc(size_t size, char * message)
{
    char *p;				/* the new allocation */
    char errbuf[100];		/* error message string */
    p = malloc(size);
    if (p == (char *)NULL) {
	   Garbage_Collect();			/* out of memory, try to make some room */
	   p = malloc(size);			/* try again */
	   if (p == (char *)NULL) {
		  /* really out of memory */
		  if (message != NULL) {
			 (void) sprintf(errbuf, "can't malloc (%u) : %s",size, message);
			 fatal(errbuf);
			 /* NOTREACHED */
		  }
		  /* else we return NULL */
	   }
    }
    return(p);
}


void *
xrealloc(void * ptr, size_t size, char * message)
{
    char *p;				/* the new allocation */
    char errbuf[100];		/* error message string */
    p = realloc(ptr, size);
    if (p == (char *)NULL) {
	   Garbage_Collect();			/* out of memory, try to make some room */
	   p = realloc(ptr, size);		/* try again */
	   if (p == (char *)NULL) {
		  /* really out of memory */
		  if (message != NULL) {
			 (void) sprintf(errbuf, "can't realloc (%u) : %s.",size, message);
			 fatal(errbuf);
			 /* NOTREACHED */
		  }
		  /* else we return NULL */
	   }
    }
    return(p);
}


	

/*
 * Copyright (c) 1990 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)bsearch.c	5.3 (Berkeley) 5/17/90";
#endif /* LIBC_SCCS and not lint */

/* 
   Steve Cumming	September 23 1991

   this code is a modified version of BSD bsearch,
   which returns the first matching entry
*/

/*
 * Perform a binary search.
 *
 * The code below is a bit sneaky.  After a comparison fails, we
 * divide the work in half by moving either left or right. If lim
 * is odd, moving left simply involves halving lim: e.g., when lim
 * is 5 we look at item 2, so we change lim to 2 so that we will
 * look at items 0 & 1.  If lim is even, the same applies.  If lim
 * is odd, moving right again involes halving lim, this time moving
 * the base up one item past p: e.g., when lim is 5 we change base
 * to item 3 and make lim 2 so that we will look at items 3 and 4.
 * If lim is even, however, we have to shrink it by one before
 * halving: e.g., when lim is 4, we still looked at item 2, so we
 * have to make lim 3, then halve, obtaining 1, so that we will only
 * look at item 3.
 */
void *
bfirst(key, base0, nmemb, size, compar)
register void *key;
void *base0;
size_t nmemb;
size_t size;
register int (*compar)(const void *, const void *);
{
  register char *base = base0;
  register size_t lim;
  int cmp;
  register void *p;
  
  for (lim = nmemb; lim != 0; lim >>= 1) {
    p = base + (lim >> 1) * size;
    cmp = (*compar)(key, p);
    if (cmp == 0) {
      register char *prv = (char *)p - size;
      while (p > base0 && !(*compar)(key,(void *)prv)){
	p = (void *)prv;
	prv -= size;
      }
      return (p);
    }
    if (cmp > 0) {	/* key > p: move right */
      base = (char *)p + size;
      lim--;
    } /* else move left */
  }
  return (NULL);
}

extern char * getwd(char *);	       

char * pushdir(char * dir){

    char * pathname;

    if (dir == NULL)
	return NULL;
    pathname = xalloc(MAXPATHLEN,"pushdir()");
    if (getwd(pathname) == (char *)0)
	fatal(pathname);

    if (chdir(dir))
	fatal("could not chdir\n");
    return pathname;
}


void  popdir(char * p){
    
    if (p){
	if (chdir(p))
	    fatal("could not restore directory!\n");
	free(p);
    }    
    return;
}
	    
FILE * get_file(char * fname, char * mode){
    FILE * f;
    if (f = fopen(fname,mode))
	return f;
    else {
	error("writing to dev/null");
	return fopen("/dev/null",mode);
    }
}
