#ifndef lint
static char     rcsid[] =
"$Id: mvalloc.c,v 1.2 1992/02/16 19:23:04 thewalt Exp thewalt $";
static char    *copyright = "Copyright (C) 1991, 1992, Chris Thewalt";
#endif

/*
 * Copyright (C) 1991, 1992 by Chris Thewalt (thewalt@ce.berkeley.edu)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#include <stdio.h>
#ifdef __STDC__ || __EXTENSIONS__
#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#else  /* not __STDC__ */
#include <varargs.h>
extern void *malloc();
extern void  free();
extern void  exit();
#endif /* not __STDC__ */
#include "mvalloc.h"
#include "lib.h"

extern void heapcheck(void);

typedef double  Align;
typedef void   *VoidPtr;

typedef struct {
    int             magic;
    int             eltype;
    int             dimension;
    long int	    * size;
    Align           start;
} MVobj;

#define  MV_MAGIC 2099

static MVobj      offset_var;
#define MV_OFFSET ((char*)&offset_var.start-(char*)&offset_var)

static void *
MallocOrDie(long int size)

{
    void           *p;
    extern void    *malloc();

    if ((p = malloc((size_t)size)) == NULL) {
	fprintf(stderr, "MallocOrDie: insufficient memory\n");
	exit(1);
    }
    return p;
}

#ifdef __STDC__ || __EXTENSIONS__
void *
MValloc(int eltype, int dimension, ...)
#else  /* not __STDC__ */
void *
MValloc(va_alist)
va_dcl
#endif /* not __STDC__ */
{
    long int * size;
    int i;
    va_list         ap;
#ifndef __STDC__
    int             eltype, dimension;
#endif
#ifdef __STDC__ || __EXTENSIONS__
    va_start(ap, dimension);
#else  /* not __STDC__ */
    va_start(ap);
    eltype = va_arg(ap, int);
    dimension = va_arg(ap, int);
#endif /* not __STDC__ */
    if (dimension > 0) {
        size = MallocOrDie((long int) dimension * sizeof(long int));
	for (i=0; i < dimension; i++) {
	    size[i] = va_arg(ap, long int);
	    if (size[i] < 0) {
	        fprintf(stderr, "MValloc: negative size request\n");
		return (void *)0;
	    }
	}
    } else {
	fprintf(stderr, "MValloc: non-positive dimension argument\n");
	return (void *)0;
    }
    va_end(ap);
    return (MVmake(eltype, dimension, size));
}

void *  MVmake(int eltype, int dimension, long int * size){
    MVobj          *mvp;
    char	 ***c3, **c2;
    short        ***s3, **s2;
    int          ***i3, **i2;
    long int         ***l3, **l2;
    float        ***f3, **f2;
    double       ***d3, **d2;
    VoidPtr      ***v3, **v2;
    void           *retval = (void * )0;
    long int           i, j;
    long int           pp_count, p_count, el_count;
    long int           base, count;

    el_count = 1;
    for (i = 0; i < dimension; i++)
	el_count *= size[i];
	
    if (dimension == 1) {
	p_count = pp_count = 0;
    } else if (dimension == 2) {
	p_count = el_count / size[dimension-1];
	pp_count = 0;
    } else {
	pp_count = 0;
	p_count = 1;
	for (i = 0; i < dimension - 2; i++) {
	    p_count *= size[i];
	    pp_count += p_count;
	}
	p_count = el_count / size[dimension-1];
    }
    base = 0;
    count = 1;
    switch (eltype) {
      case MV_CHAR:
	if (dimension > 2 ) {
	    mvp = MallocOrDie((long int) MV_OFFSET + pp_count * sizeof(char **));
	    retval = c3 = (char ***)((char *)mvp + MV_OFFSET);
	    for (i = 0; i < dimension - 3; i++) {
	        count *= size[i];
	        for (j = 0; j < count; j++) {
		    c3[base+j] = (char **)(c3 + base + count + j * size[i+1]);
	        }
                base += count;
	    }
	    c3[base] = MallocOrDie((long int) p_count * sizeof(char *));
	    count *= size[dimension-3];
	    for (i = 1; i < count; i++) 
		c3[base+i] = c3[base+i-1] + size[dimension-2];
	    c3[base][0] = MallocOrDie((long int) el_count * sizeof(char));
	    for (i = 1; i < p_count; i++)
	        c3[base][i] = c3[base][i-1] + size[dimension-1];
	} else if (dimension == 2) {
	    mvp = MallocOrDie((long int) MV_OFFSET + p_count * sizeof(char *));
	    retval = c2 = (char **)((char *)mvp + MV_OFFSET);
	    c2[0] = MallocOrDie((long int) el_count * sizeof(char));
	    for (i = 1; i < p_count; i++)
	        c2[i] = c2[i-1] + size[1];
	} else {
	    mvp = MallocOrDie((long int) MV_OFFSET + el_count * sizeof(char));
	    retval = (char *)((char *)mvp + MV_OFFSET);
	}
	break;
      case MV_SHORT:
	if (dimension > 2 ) {
	    mvp = MallocOrDie((long int) MV_OFFSET + pp_count * sizeof(short **));
	    retval = s3 = (short ***)((char *)mvp + MV_OFFSET);
	    for (i = 0; i < dimension - 3; i++) {
	        count *= size[i];
	        for (j = 0; j < count; j++) {
		    s3[base+j] = (short **)(s3 + base + count + j * size[i+1]);
	        }
                base += count;
	    }
	    s3[base] = MallocOrDie((long int) p_count * sizeof(short *));
	    count *= size[dimension-3];
	    for (i = 1; i < count; i++) 
		s3[base+i] = s3[base+i-1] + size[dimension-2];
	    s3[base][0] = MallocOrDie((long int) el_count * sizeof(short));
	    for (i = 1; i < p_count; i++)
	        s3[base][i] = s3[base][i-1] + size[dimension-1];
	} else if (dimension == 2) {
	    mvp = MallocOrDie((long int) MV_OFFSET + p_count * sizeof(short *));
	    retval = s2 = (short **)((char *)mvp + MV_OFFSET);
	    s2[0] = MallocOrDie((long int) el_count * sizeof(short));
	    for (i = 1; i < p_count; i++)
	        s2[i] = s2[i-1] + size[1];
	} else {
	    mvp = MallocOrDie((long int) MV_OFFSET + el_count * sizeof(short));
	    retval = (short *)((char *)mvp + MV_OFFSET);
	}
	break;
      case MV_INT:
	if (dimension > 2 ) {
	    mvp = MallocOrDie((long int) MV_OFFSET + pp_count * sizeof(int **));
	    retval = i3 = (int ***)((char *)mvp + MV_OFFSET);
	    for (i = 0; i < dimension - 3; i++) {
	        count *= size[i];
	        for (j = 0; j < count; j++) {
		    i3[base+j] = (int **)(i3 + base + count + j * size[i+1]);
	        }
                base += count;
	    }
	    i3[base] = MallocOrDie((long int) p_count * sizeof(int *));
	    count *= size[dimension-3];
	    for (i = 1; i < count; i++) 
		i3[base+i] = i3[base+i-1] + size[dimension-2];
	    i3[base][0] = MallocOrDie((long int) el_count * sizeof(int));
	    for (i = 1; i < p_count; i++)
	        i3[base][i] = i3[base][i-1] + size[dimension-1];
	} else if (dimension == 2) {
	    mvp = MallocOrDie((long int) MV_OFFSET + p_count * sizeof(int *));
	    retval = i2 = (int **)((char *)mvp + MV_OFFSET);
	    i2[0] = MallocOrDie((long int) el_count * sizeof(int));
	    for (i = 1; i < p_count; i++)
	        i2[i] = i2[i-1] + size[1];
	} else {
	    mvp = MallocOrDie((long int) MV_OFFSET + el_count * sizeof(int));
	    retval = (int *)((char *)mvp + MV_OFFSET);
	}
	break;
      case MV_LONG:
	if (dimension > 2 ) {
	    mvp = MallocOrDie((long int) MV_OFFSET + pp_count * sizeof(long int **));
	    retval = l3 = (long int ***)((char *)mvp + MV_OFFSET);
	    for (i = 0; i < dimension - 3; i++) {
	        count *= size[i];
	        for (j = 0; j < count; j++) {
		    l3[base+j] = (long int **)(l3 + base + count + j * size[i+1]);
	        }
                base += count;
	    }
	    l3[base] = MallocOrDie((long) p_count * sizeof(long int *));
	    count *= size[dimension-3];
	    for (i = 1; i < count; i++) 
		l3[base+i] = l3[base+i-1] + size[dimension-2];
	    l3[base][0] = MallocOrDie((long int) el_count * sizeof(long int));
	    for (i = 1; i < p_count; i++)
	        l3[base][i] = l3[base][i-1] + size[dimension-1];
	} else if (dimension == 2) {
	    mvp = MallocOrDie((long int) MV_OFFSET + p_count * sizeof(long int *));
	    retval = l2 = (long int **)((char *)mvp + MV_OFFSET);
	    l2[0] = MallocOrDie((long  int) el_count * sizeof(long int));
	    for (i = 1; i < p_count; i++)
	        l2[i] = l2[i-1] + size[1];
	} else {
	    mvp = MallocOrDie((long int) MV_OFFSET + el_count * sizeof(long int));
	    retval = (long int *)((char *)mvp + MV_OFFSET);
	}
	break;
      case MV_FLOAT:
	if (dimension > 2 ) {
	    mvp = MallocOrDie((long int) MV_OFFSET + pp_count * sizeof(float **));
	    retval = f3 = (float ***)((char *)mvp + MV_OFFSET);
	    for (i = 0; i < dimension - 3; i++) {
	        count *= size[i];
	        for (j = 0; j < count; j++) {
		    f3[base+j] = (float **)(f3 + base + count + j * size[i+1]);
	        }
                base += count;
	    }
	    f3[base] = MallocOrDie((long int) p_count * sizeof(float *));
	    count *= size[dimension-3];
	    for (i = 1; i < count; i++) 
		f3[base+i] = f3[base+i-1] + size[dimension-2];
	    f3[base][0] = MallocOrDie((long int) el_count * sizeof(float));
	    for (i = 1; i < p_count; i++)
	        f3[base][i] = f3[base][i-1] + size[dimension-1];
	} else if (dimension == 2) {
	    mvp = MallocOrDie((long int) MV_OFFSET + p_count * sizeof(float *));
	    retval = f2 = (float **)((char *)mvp + MV_OFFSET);
	    f2[0] = MallocOrDie((long int) el_count * sizeof(float));
	    for (i = 1; i < p_count; i++)
	        f2[i] = f2[i-1] + size[1];
	} else {
	    mvp = MallocOrDie((long int) MV_OFFSET + el_count * sizeof(float));
	    retval = (float *)((char *)mvp + MV_OFFSET);
	}
	break;
      case MV_DOUBLE:
	if (dimension > 2 ) {
	    mvp = MallocOrDie((long int) MV_OFFSET + pp_count * sizeof(double **));
	    retval = d3 = (double ***)((char *)mvp + MV_OFFSET);
	    for (i = 0; i < dimension - 3; i++) {
	        count *= size[i];
	        for (j = 0; j < count; j++) {
		    d3[base+j] = (double **)(d3 + base + count + j * size[i+1]);
	        }
                base += count;
	    }
	    d3[base] = MallocOrDie((long int) p_count * sizeof(double *));
	    count *= size[dimension-3];
	    for (i = 1; i < count; i++) 
		d3[base+i] = d3[base+i-1] + size[dimension-2];
	    d3[base][0] = MallocOrDie((long int) el_count * sizeof(double));
	    for (i = 1; i < p_count; i++)
	        d3[base][i] = d3[base][i-1] + size[dimension-1];
	} else if (dimension == 2) {
	    mvp = MallocOrDie((long int) MV_OFFSET + p_count * sizeof(double *));
	    retval = d2 = (double **)((char *)mvp + MV_OFFSET);
	    d2[0] = MallocOrDie((long int) el_count * sizeof(double));
	    for (i = 1; i < p_count; i++)
	        d2[i] = d2[i-1] + size[1];
	} else {
	    mvp = MallocOrDie((long int) MV_OFFSET + el_count * sizeof(double));
	    retval = (double *)((char *)mvp + MV_OFFSET);
	}
	break;
      case MV_VOIDP:
	if (dimension > 2 ) {
	    mvp = MallocOrDie((long int)MV_OFFSET + pp_count * sizeof(VoidPtr **));
	    retval = v3 = (VoidPtr ***)((char *)mvp + MV_OFFSET);
	    for (i = 0; i < dimension - 3; i++) {
	        count *= size[i];
	        for (j = 0; j < count; j++) {
		    v3[base+j] = (VoidPtr **)(v3 + base + count + j*size[i+1]);
	        }
                base += count;
	    }
	    v3[base] = MallocOrDie((long int) p_count * sizeof(VoidPtr *));
	    count *= size[dimension-3];
	    for (i = 1; i < count; i++) 
		v3[base+i] = v3[base+i-1] + size[dimension-2];
	    v3[base][0] = MallocOrDie((long int) el_count * sizeof(VoidPtr));
	    for (i = 1; i < p_count; i++)
	        v3[base][i] = v3[base][i-1] + size[dimension-1];
	} else if (dimension == 2) {
	    mvp = MallocOrDie((long int) MV_OFFSET + p_count * sizeof(VoidPtr *));
	    retval = v2 = (VoidPtr **)((char *)mvp + MV_OFFSET);
	    v2[0] = MallocOrDie((long int) el_count * sizeof(VoidPtr));
	    for (i = 1; i < p_count; i++)
	        v2[i] = v2[i-1] + size[1];
	} else {
	    mvp = MallocOrDie((long int) MV_OFFSET + el_count * sizeof(VoidPtr));
	    retval = (VoidPtr *)((char *)mvp + MV_OFFSET);
	}
	break;
      default:
	fprintf(stderr, "MValloc: illegal element type\n");
	free((void *) size);
	return 0;
    }
    if (retval) {
	mvp->magic = MV_MAGIC;
	mvp->eltype = eltype;
	mvp->dimension = dimension;
	mvp->size = size;
    }
    return retval;
}

void
MVfree(mvobj)
void *mvobj;
{
    MVobj          *mvp = 0;
    char	 ***c3, **c2;
    short        ***s3, **s2;
    int          ***i3, **i2;
    long int         ***l3, **l2;
    float        ***f3, **f2;
    double       ***d3, **d2;
    VoidPtr      ***v3, **v2;
    long int            count, base;
    int             i;

    if (mvobj) {
	mvp = (MVobj *) ((char *)mvobj - MV_OFFSET);
	if (mvp->magic != MV_MAGIC) {
            fprintf(stderr, "MVfree: argument isn't an MVobject\n");
	    return;
	}
	mvp->magic = 0;  /* in case we see this object again */
    } else  {
        fprintf(stderr, "MVfree: NULL argument\n");
	return;
    }
    base = 0;
    count = 1;
    switch (mvp->eltype) {
      case MV_CHAR:
	if (mvp->dimension > 2 ) {
	    c3 = (char ***) mvobj;
	    for (i = 0; i < mvp->dimension - 3; i++) {
	        count *= mvp->size[i];
                base += count;
	    }
	    free((void *) c3[base][0]);
	    free((void *) c3[base]);
	} else if (mvp->dimension == 2) {
	    c2 = (char **) mvobj;
	    free((void *) c2[0]);
	}
	break;
      case MV_SHORT:
	if (mvp->dimension > 2 ) {
	    s3 = (short ***) mvobj;
	    for (i = 0; i < mvp->dimension - 3; i++) {
	        count *= mvp->size[i];
                base += count;
	    }
	    free((void *) s3[base][0]);
	    free((void *) s3[base]);
	} else if (mvp->dimension == 2) {
	    s2 = (short **) mvobj;
	    free((void *) s2[0]);
	}
	break;
      case MV_INT:
	if (mvp->dimension > 2 ) {
	    i3 = (int ***) mvobj;
	    for (i = 0; i < mvp->dimension - 3; i++) {
	        count *= mvp->size[i];
                base += count;
	    }
	    free((void *) i3[base][0]);
	    free((void *) i3[base]);
	} else if (mvp->dimension == 2) {
	    i2 = (int **) mvobj;
	    free((void *) i2[0]);
	}
	break;
      case MV_LONG:
	if (mvp->dimension > 2 ) {
	    l3 = (long int ***) mvobj;
	    for (i = 0; i < mvp->dimension - 3; i++) {
	        count *= mvp->size[i];
                base += count;
	    }
	    free((void *) l3[base][0]);
	    free((void *) l3[base]);
	} else if (mvp->dimension == 2) {
	    l2 = (long int **) mvobj;
	    free((void *) l2[0]);
	}
	break;
      case MV_FLOAT:
	if (mvp->dimension > 2 ) {
	    f3 = (float ***) mvobj;
	    for (i = 0; i < mvp->dimension - 3; i++) {
	        count *= mvp->size[i];
                base += count;
	    }
	    free((void *) f3[base][0]);
	    free((void *) f3[base]);
	} else if (mvp->dimension == 2) {
	    f2 = (float **) mvobj;
	    free((void *) f2[0]);
	}
	break;
      case MV_DOUBLE:
	if (mvp->dimension > 2 ) {
	    d3 = (double ***) mvobj;
	    for (i = 0; i < mvp->dimension - 3; i++) {
	        count *= mvp->size[i];
                base += count;
	    }
	    free((void *) d3[base][0]);
	    free((void *) d3[base]);
	} else if (mvp->dimension == 2) {
	    d2 = (double **) mvobj;
	    free((void *) d2[0]);
	}
	break;
      case MV_VOIDP:
	if (mvp->dimension > 2 ) {
	    v3 = (VoidPtr ***) mvobj;
	    for (i = 0; i < mvp->dimension - 3; i++) {
	        count *= mvp->size[i];
                base += count;
	    }
	    free((void *) v3[base][0]);
	    free((void *) v3[base]);
	} else if (mvp->dimension == 2) {
	    v2 = (VoidPtr **) mvobj;
	    free((void *) v2[0]);
	}
	break;
      default:
	fprintf(stderr, "MVfree: illegal element type\n");
	break;
    }
    free((void *) mvp->size);
    free((void *) mvp);
}

int
MVdimension(mvobj)
void *mvobj;
{
    MVobj         *mvp;
    int           dimension = -1;

    if (mvobj) {
	mvp = (MVobj *) ((char *)mvobj - MV_OFFSET);
	if (mvp->magic == MV_MAGIC)
	    dimension = mvp->dimension;
	else 
            fprintf(stderr, "MVdimension: argument isn't an MVobject\n");
    } else
        fprintf(stderr, "MVdimension: NULL argument\n");
    return dimension;
}

long int
MVsize(mvobj, dimension)
void *mvobj;
int   dimension;
{
    MVobj         *mvp;
    long int           size = -1;

    if (mvobj) {
	mvp = (MVobj *) ((char *)mvobj - MV_OFFSET);
	if (mvp->magic == MV_MAGIC) {
	    if (mvp->dimension >= dimension)
	        size = mvp->size[dimension];
	    else
                fprintf(stderr,"MVsize: bad dimension for specified object\n");
	} else
            fprintf(stderr, "MVsize: first argument isn't an MVobject\n");
    } else
        fprintf(stderr, "MVsize: first argument is NULL\n");
    return size;
}


long int *
MVsizes(void * mvobj)
{
    MVobj         *mvp;
    long int           *size = 0x0;

    if (mvobj) {
	mvp = (MVobj *) ((char *)mvobj - MV_OFFSET);
	if (mvp->magic == MV_MAGIC) {
	        size = mvp->size;
	} else
            fprintf(stderr, "MVsize: not an MVobject\n");
    } else
        fprintf(stderr, "MVsizes:  argument is NULL\n");
    return size;
}

int
MVtype(mvobj)
void *mvobj;
{
    MVobj         *mvp;
    int           type = -1;

    if (mvobj) {
	mvp = (MVobj *) ((char *)mvobj - MV_OFFSET);
	if (mvp->magic == MV_MAGIC)
	    type = mvp->eltype;
	else 
            fprintf(stderr, "MVtype: argument isn't an MVobject\n");
    } else
        fprintf(stderr, "MVtype: NULL argument\n");
    return type;
}



/* The follwoing additions to Mr. Thewalts work are:
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */


int MVconform(void * m1, void * m2){

    int i, dim;

    if (MVdimension(m1) != (dim = MVdimension(m2))){
	fprintf(stderr,"MVconform: They don't\n");
	return 1;
    }
    if (dim <= 0){
	fprintf(stderr,"MVconform: bad arguments\n");
	return 1;
    }
 
    for (i = 0; i < dim ; i++)
	if (MVsize(m1,i) != MVsize(m2,i))
	    return 1;
    return 0;
}



/*
  Make a new object of the same size and type as the argument
*/

void * MVlike(void * mvobj){
    void * new;
    int i,d;
    long int * s;
    long int * ns = (long int *)xalloc(MVdimension(mvobj) * sizeof(long int),"MVlike()");

    d = MVdimension(mvobj);
    s = MVsizes(mvobj);
    
    for (i =  0; i < d; i++)
	ns[i] = s[i];

    new = MVmake(MVtype(mvobj), MVdimension(mvobj), ns);
#ifdef DEBUG
    if (MVconform(mvobj,new)
	fatal("MVlike() dies\n");
#endif DEBUG
    return new;
}



/*
  a[i][j] {*|/|+|-}= b[i][j]
*/

void *
MV2dopeq(void * a,  void * b, enum GP_OPS op){
    
    int i, j;
    float ** af;
    float ** bf;
    double ** ad;
    double ** bd;
    int type;

    int d1,d2;
    
    if (MVconform(a,b))
	fatal("MV2dopeq(): non conformism!\n");
    if ((type = MVtype(a)) != MVtype(b))
	fatal("MV2dopeq(): type mismatch!");
    if (MVdimension(a) != 2)
	fatal("MV2dopeq(): not 2d!");

    d1 = MVsize(a,0);
    d2 = MVsize(a,1);
    
    switch (op){
    case GP_ADD:
	switch (type) {
	case MV_FLOAT:
	    
	    af = (float **)a;
	    bf = (float **)b;
	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    af[i][j] += bf[i][j];
	    break;
	case MV_DOUBLE:
	    
	    ad = (double **)a;
	    bd = (double **)b;
	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    ad[i][j] += bd[i][j];
	    break;
	default:
	    fatal("MV2dopeq():  operation or data type not supported!");
	    break;
	}
	break;
    case GP_MULTIPLY:
	switch (type) {
	case MV_FLOAT:
	    
	    af = (float **)a;
	    bf = (float **)b;
	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    af[i][j] *= bf[i][j];
	    break;
	case MV_DOUBLE:
	    
	    ad = (double **)a;
	    bd = (double **)b;
	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    ad[i][j] *= bd[i][j];
	    break;
	default:
	    fatal("MV2dopeq():  operation or data type not supported!");
	    break;
	}
	break;
    case GP_SUBTRACT:
	switch (type) {
	case MV_FLOAT:
	    
	    af = (float **)a;
	    bf = (float **)b;
	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    af[i][j] -= bf[i][j];
	    break;
	case MV_DOUBLE:
	    
	    ad = (double **)a;
	    bd = (double **)b;
	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    ad[i][j] -= bd[i][j];
	    break;
	default:
	    fatal("MV2dopeq():  operation or data type not supported!");
	    break;
	}
	break;
    case GP_DIVIDE:
	switch (type) {
	case MV_FLOAT:
	    
	    af = (float **)a;
	    bf = (float **)b;
	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    af[i][j] /= bf[i][j];
	    break;
	case MV_DOUBLE:
	    
	    ad = (double **)a;
	    bd = (double **)b;
	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    ad[i][j] /= bd[i][j];
	    break;
	default:
	    fatal("MV2dopeq():  operation or data type not supported!");
	    break;
	}
	break;
    default:
	fatal("MV2dopeq():  operation or data type not supported!");
	break;
    }
    return a;

}




/*
  c[i][j] = a[i][j] {*|/|+|-} b[i][j]
*/

void *
MV2dop(void * a,  void * b, enum GP_OPS op){
    
    int i, j;
    float ** af;
    float ** bf;
    float ** cf;
    double ** ad;
    double ** bd;
    double ** cd;

    void * c;
    int type;

    int d1,d2;
    
    if (MVconform(a,b))
	fatal("MV2dop(): non conformism!\n");
    if ((type = MVtype(a)) != MVtype(b))
	fatal("MV2dop(): type mismatch!");
    if (MVdimension(a) != 2)
	fatal("MV2dop(): not 2d!");

    heapcheck();

    c = MVlike(a);

    heapcheck();

    d1 = MVsize(a,0);
    d2 = MVsize(a,1);
    
    switch (op){
    case GP_ADD:
	switch (type) {
	case MV_FLOAT:
	    
	    af = (float **)a;
	    bf = (float **)b;
	    cf = (float **)c;

	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    cf[i][j] = af[i][j] + bf[i][j];
	    break;
	case MV_DOUBLE:
	    
	    ad = (double **)a;
	    bd = (double **)b;
	    cd = (double **)c;

	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		    cd[i][j] = ad[i][j] + bd[i][j];
	    break;
	default:
	    fatal("MV2dop():  operation or data type not supported!");
	    break;
	}
	break;
    case GP_MULTIPLY:
	switch (type) {
	case MV_FLOAT:
	    
	    af = (float **)a;
	    bf = (float **)b;
	    cf = (float **)c;

	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		     cf[i][j] = af[i][j] * bf[i][j];
	    break;
	case MV_DOUBLE:
	    
	    ad = (double **)a;
	    bd = (double **)b;
	    cd = (double **)c;

	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		     cd[i][j] = ad[i][j] * bd[i][j];
	    break;
	default:
	    fatal("MV2dop():  operation or data type not supported!");
	    break;
	}
	break;
    case GP_SUBTRACT:
	switch (type) {
	case MV_FLOAT:
	    
	    af = (float **)a;
	    bf = (float **)b;
	    cf = (float **)c;

	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		     cf[i][j] = af[i][j] - bf[i][j];
	    break;
	case MV_DOUBLE:
	    
	    ad = (double **)a;
	    bd = (double **)b;
	    cd = (double **)c;

	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		     cd[i][j] = ad[i][j] - bd[i][j];
	    break;
	default:
	    fatal("MV2dop():  operation or data type not supported!");
	    break;
	}
	break;
    case GP_DIVIDE:
	switch (type) {
	case MV_FLOAT:
	    
	    af = (float **)a;
	    bf = (float **)b;
	    cf = (float **)c;

	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		     cf[i][j] = af[i][j] / bf[i][j];
	    break;
	case MV_DOUBLE:
	    
	    ad = (double **)a;
	    bd = (double **)b;
	    cd = (double **)c;

	    for (i = 0; i < d1; i++)
		for (j = 0; j < d2; j++)
		     cd[i][j] = ad[i][j] / bd[i][j];
	    break;
	default:
	    fatal("MV2dop():  operation or data type not supported!");
	    break;
	}
	break;
    default:
	fatal("MV2dop():  operation or data type not supported!");
	break;
    }

    heapcheck();

    return c;

}

void *
MVnormalise(void * a){

    
    float ** f, fx;
    double ** d, dx;
    
    int type, d1,d2,i,j;
    /* just assume that this is two dimensional for now */

    type = MVtype(a);

    if (MVdimension(a) != 2)
	fatal("MVnormalise(): not 2d!");
    d1 = MVsize(a,0);
    d2 = MVsize(a,1);
    

    switch (type){
    case MV_FLOAT:
	f = (float **)a;
	fx = 0;
	for (i = 0; i < d1; i++)
	    for (j = 0; j < d2; j++)
		fx += f[i][j];
	for (i = 0; i < d1; i++)
	    for (j = 0; j < d2; j++)
		f[i][j] /= fx;
	break;
    case MV_DOUBLE:
	d = (double **)a;
	dx = 0;
	for (i = 0; i < d1; i++)
	    for (j = 0; j < d2; j++)
		dx += d[i][j];
	for (i = 0; i < d1; i++)
	    for (j = 0; j < d2; j++)
		d[i][j] /= dx;
	break;
   default:
	fatal("MVnormalise(): unsupported type\n");
	break;
    }
    return a;
}


void 
MVinit(void * a, double x){
    

    double ** d;
    int d1,d2;

    int i,j;
    if (MVtype(a) != MV_DOUBLE)
	fatal("MVinit(): bad type");

    if (MVdimension(a) != 2)
	fatal("MVinit(): bad dimensionality");
    d = (double **)a;
    d1 = MVsize(a,0);
    d2 = MVsize(a,1);
    for (i = 0; i < d1; i++)
	for (j = 0; j < d2; j++)
	    d[i][j] = x;

    return;
}


/*
  shift along int dim axis, accumulating at one end,
  zeroing at the other
*/

void MVshift(void * m, int dim){

    long int  * sizes;
    long int  d0,d1,i,j;

    if (MVdimension(m) != 2 || (dim != 0 && dim != 1))
	fatal("MVshift(): dimension SOL!");

    sizes = MVsizes(m);
    d0 = sizes[0];
    d1 = sizes[1];
    
    switch (MVtype(m)){
	
    case MV_DOUBLE: {
	double ** x = (double **)m;
	if (dim == 0)
	    for (i = 0; i < d1; i++){
		x[d0-1][i] += x[d0-2][i];
		for (j = d0-2; j > 0; j--)
		    x[j][i] = x[j-1][i];
		x[0][i] = 0.0;
	    }
	else 
	    for (i = 0; i < d0; i++){
		x[i][d1-1] += x[i][d1-2];
		for (j = d1-2; j > 0; j--)
		    x[i][j] = x[i][j-1];
		x[i][0] = 0.0;
	    }
    } break;
    case MV_FLOAT: {
	float ** x = (float **)m;
	if (dim == 0)
	    for (i = 0; i < d1; i++){
		x[d0-1][i] += x[d0-2][i];
		for (j = d0-2; j > 0; j--)
		    x[j][i] = x[j-1][i];
		x[0][i] = 0.0;
	    }
	else 
	    for (i = 0; i < d0; i++){
		x[i][d1-1] += x[i][d1-2];
		for (j = d1-2; j > 0; j--)
		    x[i][j] = x[i][j-1];
		x[i][0] = 0.0;
	    }
    } break;
    default:
	fatal("MVshift(): type SOL!");
    }
    return;
}


/* 
  sum a subarray
*/

double 
MVsumpart(void * mvobj, int x1, int x2, int y1, int y2){

    float ** mf;
    double ** md;
    int ** mi;

    int i,j;
    double x;
    if (MVdimension(mvobj) != 2 ||
	MVsize(mvobj,0) < x2 || 
	MVsize(mvobj,1) < y2 ||
	x1 < 0 || y1 < 0)
	fatal("MVsumpart()\n");

    switch (MVtype(mvobj)){

    case MV_FLOAT:

	mf = (float **)mvobj;
	x = 0.0;
	for (i = x1; i < x2; i++)
	    for (j = y1; j < y2; j++)
		x += mf[i][j];
	break;

    case MV_DOUBLE:
    
	md = (double **)mvobj;
	x = 0.0;
	for (i = x1; i < x2; i++)
	    for (j = y1; j < y2; j++)
		x += md[i][j];
	break;

    case MV_INT:

	mi = (int **)mvobj;
	x = 0.0;
	for (i = x1; i < x2; i++)
	    for (j = y1; j < y2; j++)
		x += mi[i][j];
	break;
    default:
	fatal("MVsumpart(): bad type\n");
	break;
    }
    return x;
}
/*
  project on ith dimension 
*/

/*

void * MVproject(void * m, int dim){

    int i.j;
    long int * dim1;
    long int * dim2;

    int d;
    void * new;
    
    d = MVsize(m) - 1;
    dim1 = MVsizes(m);
    dim2 = (long int *)xalloc(d * sizeof(long int),"MVproject()");
    count = (long int *)xalloc(d * sizeof(long int),"MVproject()");
    
    j = 0;
    for (i = 0; i < dim; i++)
	dim2[j++] = dim1[i];
    for (i = dim, i < MVsize(m), i++)
	dim2[j++] = dim1[i];

    new = MVmake(MVtype(m), MVsize(m), dim2);

  



    return new;
}


*/
/*
   ASCII mv_array format

   type
   dimension
   size
   
   [...][0]....[...][size[dimension-1]-1]


*/





    void rec_read(void * a, int type, int dim, long int * size, FILE * f){
    
	int i,n;
	char * str;
	n = size[0];    
	if (dim > 1){
	    for (i = 0; i < n; i++)
		rec_read(((void **)a)[i],type, dim-1, size+1,f);
	}
	else for (i = 0; i < n; i++){
	    str = nxt_token(f);
	    if (type == MV_DOUBLE)
		sscanf(str,"%lf",&((double *)a)[i]);
	    else if (type == MV_FLOAT)
		sscanf(str,"%f",&((float *)a)[i]);
	    else if (type == MV_LONG)
		sscanf(str,"%ld",&((long int *)a)[i]);
	    else if (type == MV_INT)
		sscanf(str,"%d",&((int *)a)[i]);
	    else if (type == MV_SHORT)
		sscanf(str,"%hd",&((short *)a)[i]);
	    else if (type == MV_CHAR)
		sscanf(str,"%c",&((char *)a)[i]);
	    else
		fatal("rec_read()");
	}

	return;
    }

void  * read_mvarray(FILE * f){

    void * a;
    int dimension;
    long int * size;
    char * str;
    int eltype;
    int i;

    if (!(str = nxt_token(f)))
	error("bad mvarray file\n");
    sscanf(str,"%d",&eltype);

    if (!(str = nxt_token(f)))
	error("bad mvarray file\n");
    sscanf(str,"%d",&dimension);

    size = (long int *)xalloc(dimension * sizeof(long int),"read_mvarray()");

    for (i = 0; i < dimension; i++){
	if (!(str = nxt_token(f)))
	    error("bad mvarray file\n");
	sscanf(str,"%ld",&size[i]);
    }

    a = MVmake(eltype,dimension,size);

    rec_read(a,eltype,dimension,size,f);
    
    return a;
}


    void rec_write(void * a, int type, int dim, long int * size, FILE * f){
	
	int i,n;
	n = size[0];    
	if (dim > 1){
	    for (i = 0; i < n; i++)
		rec_write(((void **)a)[i],type, dim-1, size+1,f);
	}
	
	else for (i = 0; i < n; i++){
	    if (type == MV_DOUBLE)
		fprintf(f,"%f ",((double *)a)[i]);
	    else if (type == MV_FLOAT)
		fprintf(f,"%f ",(double)((float *)a)[i]);
	    else if (type == MV_LONG)
		fprintf(f,"%ld ",((long int *)a)[i]);
	    else if (type == MV_INT)
		fprintf(f,"%d ",((int *)a)[i]);
	    else if (type == MV_SHORT)
		fprintf(f,"%hd ",(int)((short *)a)[i]);
	    else if (type == MV_CHAR)
		fprintf(f,"%c ",((char *)a)[i]);
	    else
		fatal("rec_write()");
	}
	fprintf(f,"\n");
	return;
    }

    void write_mvarray(void * a, FILE * f){

	MVobj     *mvp;
	int eltype;
	int dimension;
	long int * size;
	int i;

	if (a) {
	    mvp = (MVobj *) ((char *)a - MV_OFFSET);
	    if (mvp->magic == MV_MAGIC){
		dimension = mvp->dimension;
		eltype = mvp->eltype;
		size = mvp->size;
	    }
	    else 
		error("write_mvarraye: argument isn't an MVobject\n");
	} else
	    error("write_mvarray: NULL argument\n");
	
	fprintf(f,"%d\n",eltype);
	fprintf(f,"%d\n",dimension);
	for (i = 0; i < dimension; i++){
	    fprintf(f,"%ld ",size[i]);
	}
	fprintf(f,"\n# end MV header\n#\n");
	rec_write(a,eltype,dimension,size,f);
	return;
    }


