
#ifndef lint
static char    *copyright = "Copyright (C) 1994, Steve Cumming";
#endif

/*
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca),
 * except as noted below.
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */


#include <math.h>
#include "lib.h"
#include "array.h"
#include "nr.h"


static double maxarg1,maxarg2;

#define MAX(a,b) (maxarg1 = (a), maxarg2 = (b), (maxarg1 > maxarg2 ? \
				                 maxarg1 : maxarg2))

double log_b(double x, double b){

     return log(x) / log(b);

}


void kstwo(struct array * d1, struct array * d2, double * D, double * P, int sort)
{
    float * data1;
    float * data2;
    struct array * a1, * a2;
    int n1,n2;
    float d,p;
    float x1,x2,dt,en1,en2,fn1,fn2,en;

    int fa1 = 0, fa2 = 0;
    int kj1 = 0, kj2 = 0;

    d = 0.0;

    if (d1->type != FLOAT){	
	a1 = copy_coerce_array(d1,FLOAT);
	fa1 = 1;
    }
    else
	a1 = d1;
    if (d2->type != FLOAT){
	a2 = copy_coerce_array(d2,FLOAT);
	fa2 = 1;
    }
    else
	a2 = d2;

    if (sort) {
	sort_array_in_place(a1);
	sort_array_in_place(a2);
    }

    data1 = (float *)(a1->a);
    data2 = (float *)(a2->a);

    n1 = a1->n;
    n2 = a2->n;
    en1 = n1;
    en2 = n2;
    fn1 = fn2 = 0;
    while (kj1 < n1 && kj2 < n2){
	if ( (x1 = data1[kj1]) <= (x2 = data2[kj2])){
	    while (data1[++kj1] == x1);
	    fn1 = (kj1)/en1;
	}
	if ( x2 <= x1 ){
	    while(data2[++kj2] == x2);
	    fn2 = (kj2)/en2;
	}
	if ((dt = fabs(fn2-fn1)) > d) 
	    d = dt;
    }
    
/*
  This is the formula from the 1st Edition.
    p = probks(sqrt(en1 * en2 / (en1 + en2)) * d);
*/

/*
  This is formula 14.3.9, 2nd Edition.
*/
    en = (float) sqrt((double)(en1 * en2 / (en1 + en2)));
    p = probks((en + 0.12 + 0.11/en) * d);
	      
    if (fa1)
	free_array(a1);
    if (fa2)
	free_array(a2);
    *D = (double)d;
    *P = (double)p;
    return;
}


void ks2d2s_fe(struct array * ax1, struct array * ax2, struct array * ay1, struct array * ay2, double * D, double *P){
    
    struct array * X1, *X2, *Y1, *Y2;
    unsigned long n1,n2;

    float d,p;

    int fx1, fx2, fy1, fy2;

    n1 = ax1->n;
    n2 = ax2->n;
    fx1 = fx2 = fy1 = fy2 = 0;

    if (ax1->type != FLOAT){
	X1 = copy_coerce_array(ax1,FLOAT);
	fx1 = 1;
    } else
	X1 = ax1;

    if (ax2->type != FLOAT){
	X2 = copy_coerce_array(ax2,FLOAT);
	fx2 = 1;
    } else
	X2 = ax2;

    if (ay1->type != FLOAT){
	Y1 = copy_coerce_array(ay1,FLOAT);
	fy1 = 1;
    } else
	Y1 = ay1;

    if (ay2->type != FLOAT){
	Y1 = copy_coerce_array(ay2,FLOAT);
	fy2 = 1;
    } else
	Y2 = ay2;

    ks2d2s((float *)X1->a, (float *)Y1->a, n1, (float *)X2->a, (float *)Y2->a, n2, &d,&p);
    if (fx1)
	free_array(X1);
    if (fx2)
	free_array(X2);
    if (fy1)
	free_array(Y1);
    if (fy2)
	free_array(Y2);
    
    *D = (double)d;
    *P = (double)p;
    return;
}
	
	

void chstwo(struct array * d1, struct array * d2, int knstrn, double * Chsq, double * Prob)
{
    extern float gammq(float,float);
    float * bins1;
    float * bins2;
    float tmp;

    struct array * a1, * a2;
    int nbins, j;
    double df;
    int fa1 = 0, fa2 = 0;
    if (d1->n != d2->n)
	fatal("chstwo");
    nbins = d1->n;


    df = nbins - 1 - knstrn;

    if (d1->type != FLOAT){	
	a1 = copy_coerce_array(d1,FLOAT);
	fa1 = 1;
    }
    else
	a1 = d1;
    if (d2->type != FLOAT){
	a2 = copy_coerce_array(d2,FLOAT);
	fa2 = 1;
    }
    else
	a2 = d2;

    bins1 = (float *)(a1->a);
    bins2 = (float *)(a2->a);

    for (j = 0 ; j < nbins; j++){

	if (bins1[j] == 0.0 && bins2[j] == 0.0)
	    df -= 1.0;
	else{
	    tmp = bins1[j] - bins2[j];
	    *Chsq += (tmp * tmp) / (bins1[j]  + bins2[j]);
	}
    }
    *Prob = (double) gammq(0.5 * df, (float)(*Chsq * 0.5));
    if (fa1)
	free_array(a1);
    if (fa2)
	free_array(a2);
    return;
    }

    
/*
  Ugly, unreconstructed, random number generators
*/



/*     RANDOM NUMBER GENERATORS: */

/*     RAN2(IDUM) RETURNS A UNIFORM RANDOM NUMBER ON (0,1). */
/*     THE ROUTINE IS FROM:  PRESS, W.H., B.P. FLANNERY, S.A. */
/*     TEUKOLSKY, AND W.T. VETTERLING.  1987.  NUMERICAL RECIPES. */
/*     CAMBRIDGE UNIVERSITY PRESS, CAMBRIDGE. */

double ran2(int * idum)
{
    /* Initialized data */

    static int m = 714025;
    static int ia = 1366;
    static int ic = 150889;
    static int iff = 0;

    /* System generated locals */
    double ret_val;

    /* Builtin functions */
    /* Subroutine */ int s_paus();

    /* Local variables */
    static int j, ir[97];
    static double rm;
    static int iy;

    rm = (double)1. / (double) m;
    if (*idum < 0 || iff == 0) {
	iff = 1;
	*idum = (ic - *idum) % m;
	for (j = 1; j <= 97; ++j) {
	    *idum = (ia * *idum + ic) % m;
	    ir[j - 1] = *idum;
/* L11: */
	}
	*idum = (ia * *idum + ic) % m;
	iy = *idum;
    }
    j = iy * 37 / m + 1;
    if (j > 97 || j < 1) {
/*	s_paus("", 0L); */
	exit(3);
    }
    iy = ir[j - 1];
    ret_val = iy * rm;
    *idum = (ia * *idum + ic) % m;
    ir[j - 1] = *idum;
    return ret_val;
} /* ran2_ */


/*     GAUSS(IDUM) RETURNS A NORMAL RANDOM NUMBER, X,S=(0,1). */
/*     THIS IS ROUTINE GASDEV(IDUM) FROM PRESS ET AL., ABOVE. */

double gauss(int * idum)
{
    /* Initialized data */

    static int iset = 0;

    /* System generated locals */
    double ret_val, r__1, r__2;

    /* Builtin functions */
    /* Local variables */
    static double gset, v1, v2, fac;
    static double sqpar, r;

    /* hack for resetting */
    if (*idum < 0)
	iset = 0;

    if (iset == 0) {
L21:
	v1 = ran2(idum) * 2.0 - 1.0;
	v2 = ran2(idum) * 2.0 - 1.0;
/* Computing 2nd power */
	r__1 = v1;
/* Computing 2nd power */
	r__2 = v2;
	r = (double) (r__1 * r__1 + r__2 * r__2);
	if (r >= 1.) {
	    goto L21;
	}
	sqpar = log(r) * -2.0 / r;
	fac = (float) sqrt(sqpar);
/*
	fac = sqrt(log(r) * (float)-2. / r);
*/
	gset = v1 * fac;
	ret_val = v2 * fac;
	iset = 1;
    } else {
	ret_val = gset;
	iset = 0;
    }
    return ret_val;
} /* gauss_ */


