/*
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#ifndef NRH
#define NRH

/* numerical recipes code */


extern float ran1(int *);
extern float expdev(int *);

extern float probks(float);
extern float gammq(float, float);
extern void ks2d2s(float *, float *, int, float *, float *, int, float *, float *);

/*  and my own math functions*/

extern double log_b(double, double);
extern double ran2(int *);
extern double gauss(int *);

extern void kswto (struct array *, struct array *, double *, double *, int);
extern void ks2d2s_fe(struct array *, struct array *, struct array *, struct array *, double *, double *);
extern void chstwo(struct array *, struct array * , int, double *, double *);
#endif NRH







