#ifndef _GNULIB_X11_H
#define _GNULIB_X11_H

/*-----------------------------------------------------------------------------
 * gnulib_x11 - Functions to read 'xlib' format gnuplot files into drawables.
 *
 * by gregg hanna (gregor@kafka.saic.com)
 * based on gnuplot_x11 by Ed Kubaitis (University of Illinois)
 *---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <stdio.h>

/*-----------------------------------------------------------------------------
 *  PLOT FUNCTIONS - read data from a file/stream and draw into a drawable
 *---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 *   GP_PlotFromStream - reads a gnuplot (xlib) from an open stream
 *     fp:  a stream to read from, may be a pipe (as returned by popen(3))
 *     colortable:  returned from GP_AllocColor or GP_ColorArray
 *                  if NULL previous setting is used
 *     ufont:  font used for text in this plot; if NULL, a default font is used
 *---------------------------------------------------------------------------*/

#ifndef _NO_PROTO
int GP_PlotFromStream(FILE *fp,Display *dpy,Drawable pixmap,Pixel *colortable,XFontStruct *ufont);
#else
int GP_PlotFromStream();
#endif

/*-----------------------------------------------------------------------------
 *   GP_PlotFromFile - reads a gnuplot from a file, drawing it in a pixmap
 *     colortable:  returned from GP_AllocColor or GP_ColorArray
 *                  if NULL previous setting is used
 *     ufont:  font used for text in this plot; if NULL, a default font is used
 *---------------------------------------------------------------------------*/

#ifndef _NO_PROTO
int GP_PlotFromFile(char *fn,Display *dpy,Drawable pixmap,Pixel *colortable,XFontStruct *ufont);
#else
int GP_PlotFromFile();
#endif

/*-----------------------------------------------------------------------------
 *  COLOR FUNCTIONS - create color array and set default color
 *---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 *   GP_ColorArray - build a color array with specified colors
 *---------------------------------------------------------------------------*/
#ifndef _NO_PROTO
Pixel *GP_ColorArray( Pixel bg, Pixel fg,
		      Pixel c0, Pixel c1, Pixel c2, Pixel c3, Pixel c4,
		      Pixel c5, Pixel c6, Pixel c7, Pixel c8);

#else

Pixel *GP_ColorArray();

#endif

/*-----------------------------------------------------------------------------
 *   GP_AllocColor - allocate colors and build color array
 *     mode: color mode to allocate colors for, modes are:
 *          GP_COLOR - allocate colors (uses default gnuplot_x11 colors)
 *          GP_GRAY - allocate grayscale
 *          GP_MONO - allocate monocolor
 *          GP_REVERSE - allocate reversed monocolor
 *          GP_DEFAULT - the software will select one of the above based on
 *              the default visual (probably the best choice for general use)
 *---------------------------------------------------------------------------*/

#define GP_COLOR   1
#define GP_GRAY    2
#define GP_MONO    3
#define GP_REVERSE 4
#define GP_DEFAULT 0

#ifndef _NO_PROTO
Pixel *GP_AllocColor(Display *dpy, int mode);
#else
Pixel *GP_AllocColor();
#endif


#endif
