/************************************************************/
/*                                                          */
/*  xlibtest - a demonstration of the xlib terminal mode    */
/*                                                          */
/*  by gregg hanna (gregor@kafka.saic.com)                  */
/*                                                          */
/************************************************************/
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>

#include "gnulib_x11.h"

Pixel *colors;

main(argc, argv)
     int	argc;
     char	*argv[];
{
	
  Widget toplevel, da, bu, bu2;
  Arg    args[12];
  int    m;
  Display *d;
  Pixel  black, white;
  void ReadIt();
  void QuitIt();
  void Resize();

  toplevel = XtInitialize(argv[0], "testlib", NULL, 0, &argc, argv);

  d = XtDisplay(toplevel);

  black = BlackPixel(d,DefaultScreen(d));
  white = WhitePixel(d,DefaultScreen(d));

  m = 0;
  XtSetArg(args[m],XmNwidth,600); m++;
  XtSetArg(args[m],XmNheight,400); m++;
  XtSetArg(args[m],XmNresizePolicy,XmRESIZE_NONE); m++;
  XtSetArg(args[m],XmNforeground,black); m++;
  XtSetArg(args[m],XmNbackground,white); m++;
  da = XmCreateDrawingArea(toplevel,"Drawing Area",args,m);
  XtAddCallback(da,XmNresizeCallback,Resize,NULL);
  XtManageChild(da);

  m = 0;
  XtSetArg(args[m],XmNx,5); m++;
  XtSetArg(args[m],XmNy,5); m++;
  bu = XmCreatePushButton(da,"Quit",args,m);
  XtManageChild(bu);
  XtAddCallback(bu,XmNactivateCallback,QuitIt,NULL);

  m = 0;
  XtSetArg(args[m],XmNx,50); m++;
  XtSetArg(args[m],XmNy,5); m++;
  bu2 = XmCreatePushButton(da,"Plot/Read",args,m);
  XtManageChild(bu2);
  XtAddCallback(bu2,XmNactivateCallback,ReadIt,da);

  XtRealizeWidget(toplevel);

  colors = GP_AllocColor(d,GP_DEFAULT);

  XtMainLoop();
}

void ReadIt(w,da,junk)
	Widget w;
	Widget da;
	caddr_t junk;
{
  system("gnuplot xlibtest.demo 2>&1 1>/dev/null");
  GP_PlotFromFile("xlibtest.out",XtDisplay(da),XtWindow(da),colors,NULL);
}

void Resize(da,hmm1,hmm2)
	Widget da;
	caddr_t hmm1, hmm2;
{
  XClearWindow(XtDisplay(da),XtWindow(da));
  GP_PlotFromFile("xlibtest.out",XtDisplay(da),XtWindow(da),colors,NULL);
}

void QuitIt() { exit(0); }

