/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrAudioSource.h>
#include <GrAudioSink.h>
#include <GrSimpleScopeSink.h>
#include <GrFFTSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include <VrGUI.h> 

#define SAMPLING_FREQUENCY      16000

const char audiodev[] = "/dev/dsp";

int main(int argc, char **argv) {
  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();

  VrSource<VrComplex> *audio_source = new GrAudioSource<VrComplex>(SAMPLING_FREQUENCY,
							     1, /* num_streams */
							     1, /* output range */
							     audiodev);

  VrSink<VrComplex> *fft_sink = new GrFFTSink<VrComplex>(vert, -50, 50, 512);

  VrSink<VrComplex> *audio_sink = new GrAudioSink<VrComplex>(1, /* input range */
						       audiodev);

  // Note -- range is of the same type as the input type, so you can use
  // VrComplex(0,1) for the range.  This will do phase rotation for you!

  NWO_CONNECT (audio_source, fft_sink);
  NWO_CONNECT (audio_source,audio_sink);

  VrMultiTask *m = new VrMultiTask ();

  m->add (fft_sink);
  m->add (audio_sink);

  m->start();

  guimain->start();

  while (1) {
    guimain->processEvents(10 /*ms*/);
    m->process();
  }
}
