/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRMIXER_H_
#define _GRMIXER_H_

#include <VrSigProc.h>
#include <gr_nco.h>

template<class iType,class oType> 
class GrMixer : public VrSigProc {

public: 
  GrMixer(double carrier_freq, double gain)
    : VrSigProc(1,sizeof(iType), sizeof(oType)),
      carrier_freq (carrier_freq), gain (gain) {}
    
  const char *name() { return "GrMixer"; }

  int work (VrSampleRange output, void *ao[],
	    VrSampleRange inputs[], void *ai[]);


protected:

  void initialize ();

  double 		carrier_freq;
  double		gain;
  gr_nco<float,float>	nco;
};

template<class iType,class oType> void
GrMixer<iType,oType>::initialize ()
{
  double Fs = getSamplingFrequency ();
  nco.set_freq (carrier_freq / Fs * 2 * M_PI);
  nco.set_phase (0);
}

template<class iType,class oType>
int
GrMixer<iType,oType>::work (VrSampleRange output, void *ao[],
			    VrSampleRange inputs[], void *ai[])
{
  iType *in =  ((iType**) ai)[0];
  oType *out = ((iType**) ao)[0];

  sync (output.index);	// we've got state, must compute in order
  
  for (unsigned oo = 0; oo < output.size; oo++){
    out[oo] = (oType) (gain * in[oo] * nco.sin ());
    nco.step ();
  }

  return output.size;
}


#endif /* _GRMIXER_H_ */
