/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import java.util.HashMap;
import java.util.List;
import jde.debugger.JDEException;
import jde.debugger.command.AttachShmem;
import jde.debugger.command.AttachSocket;
import jde.debugger.command.Break;
import jde.debugger.command.CancelTraceClasses;
import jde.debugger.command.CancelTraceMethods;
import jde.debugger.command.CancelTraceThreads;
import jde.debugger.command.Clear;
import jde.debugger.command.DebugCommand;
import jde.debugger.command.DebugThread;
import jde.debugger.command.EvaluateExpression;
import jde.debugger.command.Finish;
import jde.debugger.command.GetArray;
import jde.debugger.command.GetLoadedClasses;
import jde.debugger.command.GetLocals;
import jde.debugger.command.GetObject;
import jde.debugger.command.GetObjectMonitors;
import jde.debugger.command.GetPathInfo;
import jde.debugger.command.GetString;
import jde.debugger.command.GetThis;
import jde.debugger.command.GetThread;
import jde.debugger.command.GetThreads;
import jde.debugger.command.Interrupt;
import jde.debugger.command.KillThread;
import jde.debugger.command.LaunchApplication;
import jde.debugger.command.ListenShmem;
import jde.debugger.command.ListenSocket;
import jde.debugger.command.Quit;
import jde.debugger.command.Resume;
import jde.debugger.command.Run;
import jde.debugger.command.Step;
import jde.debugger.command.Suspend;
import jde.debugger.command.TraceClasses;
import jde.debugger.command.TraceExceptions;
import jde.debugger.command.TraceMethods;
import jde.debugger.command.TraceThreads;
import jde.debugger.command.Watch;

public class DebugCommandFactory {
    private HashMap prototypes = new HashMap();
    public static DebugCommandFactory theFactory = new DebugCommandFactory();

    protected DebugCommandFactory() {
        this.prototypes.put("launch", new LaunchApplication());
        this.prototypes.put("attach_shmem", new AttachShmem());
        this.prototypes.put("attach_socket", new AttachSocket());
        this.prototypes.put("listen_shmem", new ListenShmem());
        this.prototypes.put("listen_socket", new ListenSocket());
        this.prototypes.put("quit", new Quit());
        this.prototypes.put("run", new Run());
        this.prototypes.put("finish", new Finish());
        this.prototypes.put("get_string", new GetString());
        this.prototypes.put("get_array", new GetArray());
        this.prototypes.put("get_locals", new GetLocals());
        this.prototypes.put("get_this", new GetThis());
        this.prototypes.put("get_object", new GetObject());
        this.prototypes.put("get_loaded_classes", new GetLoadedClasses());
        this.prototypes.put("get_path_information", new GetPathInfo());
        this.prototypes.put("trace_classes", new TraceClasses());
        this.prototypes.put("cancel_trace_classes", new CancelTraceClasses());
        this.prototypes.put("trace_exceptions", new TraceExceptions());
        this.prototypes.put("trace_methods", new TraceMethods());
        this.prototypes.put("cancel_trace_methods", new CancelTraceMethods());
        this.prototypes.put("evaluate", new EvaluateExpression());
        this.prototypes.put("watch", new Watch());
        this.prototypes.put("break", new Break());
        this.prototypes.put("clear", new Clear());
        this.prototypes.put("step", new Step());
        this.prototypes.put("suspend", new Suspend());
        this.prototypes.put("resume", new Resume());
        this.prototypes.put("interrupt", new Interrupt());
        this.prototypes.put("kill_thread", new KillThread());
        this.prototypes.put("get_threads", new GetThreads());
        this.prototypes.put("get_thread", new GetThread());
        this.prototypes.put("get_object_monitors", new GetObjectMonitors());
        this.prototypes.put("trace_threads", new TraceThreads());
        this.prototypes.put("cancel_trace_threads", new CancelTraceThreads());
        this.prototypes.put("debug_thread", new DebugThread());
    }

    public final DebugCommand createCommand(Integer procID, Integer cmdID, String cmdName, List args) throws JDEException {
        DebugCommand prototype = (DebugCommand)this.prototypes.get(cmdName);
        if (prototype == null) {
            return null;
        }
        DebugCommand cmd = (DebugCommand)prototype.clone();
        cmd.init(procID, cmdID, cmdName, args);
        return cmd;
    }
}

