;;; ucs-ipa.el --- UCS table of Miscellaneous Technical

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Miscellaneous Technical

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

(set-char-ucs ?-0 (char-int ?i)) ; MULE-IPA-20-A
(set-char-ucs ?-0 (char-int ?e)) ; MULE-IPA-22-A
(set-char-ucs ?-0 (char-int ?-A)) ; MULE-IPA-24
(set-char-ucs ?-0 (char-int ?a)) ; MULE-IPA-25-A
(set-char-ucs ?-0 (char-int ?y)) ; MULE-IPA-2D-A
(set-char-ucs ?-0 #x0153)        ; MULE-IPA-30-A
(set-char-ucs ?-0 (char-int ?-A)) ; MULE-IPA-2F
(set-char-ucs ?-0 (char-int ?u)) ; MULE-IPA-34-A
(set-char-ucs ?-0 (char-int ?o)) ; MULE-IPA-36-A
(set-char-ucs ?-0 (char-int ?p)) ; MULE-IPA-40-A
(set-char-ucs ?-0 (char-int ?b)) ; MULE-IPA-41-A
(set-char-ucs ?-0 (char-int ?t)) ; MULE-IPA-42-A
(set-char-ucs ?-0 (char-int ?d)) ; MULE-IPA-43-A
(set-char-ucs ?-0 (char-int ?k)) ; MULE-IPA-44-A
(set-char-ucs ?-0 (char-int ?g)) ; MULE-IPA-45-A
(set-char-ucs ?-0 (char-int ?f)) ; MULE-IPA-46-A
(set-char-ucs ?-0 (char-int ?v)) ; MULE-IPA-46-A
(set-char-ucs ?-0 (char-int ?s)) ; MULE-IPA-4A-A
(set-char-ucs ?-0 (char-int ?z)) ; MULE-IPA-4B-A
(set-char-ucs ?-0 (char-int ?-A)) ; MULE-IPA-4E
(set-char-ucs ?-0 (char-int ?x)) ; MULE-IPA-4F-A
(set-char-ucs ?-0 (char-int ?h)) ; MULE-IPA-51-A
(set-char-ucs ?-0 (char-int ?m)) ; MULE-IPA-52-A
(set-char-ucs ?-0 (char-int ?n)) ; MULE-IPA-53-A
(set-char-ucs ?-0 (char-int ?r)) ; MULE-IPA-56-A
(set-char-ucs ?-0 (char-int ?j)) ; MULE-IPA-59-A
(set-char-ucs ?-0 (char-int ?l)) ; MULE-IPA-59-A

;; LATIN SMALL LETTER TURNED A
(ucs-set-char #x0250 ?-0) ; MULE-IPA-28-A

;; LATIN SMALL LETTER ALPHA
(ucs-set-char #x0251 ?-0) ; MULE-IPA-2C-A

;; LATIN SMALL LETTER TURNED ALPHA
(ucs-set-char #x0252 ?-0) ; MULE-IPA-38-A

;; LATIN SMALL LETTER OPEN O
(ucs-set-char #x0254 ?-0) ; MULE-IPA-37-A

;; LATIN SMALL LETTER SCHWA
(ucs-set-char #x0259 ?-0) ; MULE-IPA-27-A

;; LATIN SMALL LETTER SCHWA WITH HOOK
(ucs-set-char #x025A ?-0) ; MULE-IPA-3A-A

;; LATIN SMALL LETTER OPEN E
(ucs-set-char #x025B ?-0) ; MULE-IPA-23-A

;; LATIN SMALL LETTER RAMS HORN
(ucs-set-char #x0264 ?-0) ; MULE-IPA-2A-A

;; LATIN SMALL LETTER TURNED H
(ucs-set-char #x0265 ?-0) ; MULE-IPA-5D-A

;; LATIN SMALL LETTER I WITH STROKE
(ucs-set-char #x0268 ?-0) ; MULE-IPA-26-A

;; LATIN LETTER SMALL CAPITAL I
(ucs-set-char #x026A ?-0) ; MULE-IPA-21-A

;; LATIN SMALL LETTER TURNED M
(ucs-set-char #x026F ?-0) ; MULE-IPA-29-A

;; LATIN SMALL LETTER TURNED M WITH LONG LEG
(ucs-set-char #x0270 ?-0) ; MULE-IPA-5E-A

;; LATIN SMALL LETTER M WITH HOOK
(ucs-set-char #x0271 ?-0) ; MULE-IPA-5F-A

;; LATIN SMALL LETTER N WITH LEFT HOOK
(ucs-set-char #x0272 ?-0) ; MULE-IPA-54-A

;; LATIN SMALL LETTER BARRED O
(ucs-set-char #x0275 ?-0) ; MULE-IPA-48-A

;; LATIN LETTER SMALL CAPITAL OE
(ucs-set-char #x0276 ?-0) ; MULE-IPA-31-A

;; LATIN SMALL LETTER TURNED R
(ucs-set-char #x0279 ?-0) ; MULE-IPA-58-A

;; LATIN LETTER SMALL CAPITAL R
(ucs-set-char #x0280 ?-0) ; MULE-IPA-57-A

;; LATIN LETTER SMALL CAPITAL INVERTED R
(ucs-set-char #x0281 ?-0) ; MULE-IPA-50-A

;; LATIN SMALL LETTER ESH
(ucs-set-char #x0283 ?-0) ; MULE-IPA-4C-A

;; LATIN SMALL LETTER U BAR
(ucs-set-char #x0289 ?-0) ; MULE-IPA-32-A

;; LATIN SMALL LETTER UPSILON
(ucs-set-char #x028A ?-0) ; MULE-IPA-35-A

;; LATIN SMALL LETTER TURNED Y
(ucs-set-char #x028E ?-0) ; MULE-IPA-5B-A

;; LATIN LETTER SMALL CAPITAL Y
(ucs-set-char #x028F ?-0) ; MULE-IPA-2E-A

;; LATIN SMALL LETTER EZH
(ucs-set-char #x0292 ?-0) ; MULE-IPA-4D-A

;; LATIN LETTER SMALL CAPITAL L
(ucs-set-char #x029F ?-0) ; MULE-IPA-5C-A

;;; ucs-ipa.el ends here
