static char help_text[] ="\n"
"Introduction\n"
"\n"
"		The OO-Browser Graphical Interface\n"
"\n"
"	This program demonstrates a dynamic tree-drawing \n"
"	algorithm developed by Sven Moen.  The algorithm is \n"
"	published in \"IEEE Software\", July 1990, pp. 21-28.\n"
"	If you desire more information than the description\n"
"	given below, see the above-referenced article. \n"
"\n"
"	A number of the features mentioned herein are not\n"
"	included in this version of the program.\n"
"\n"
"Algorithm\n"
"\n"
"	Unlike other algorithms, Moen's algorithm uses an \n"
"	explicit representation of node and subtree contours\n"
"	and it stores each contour as a polygon. \n"
"\n"
"	Trees with nodes of any polygonal shape can be drawn\n"
"	compactly, and the data structure supports insert and\n"
"	delete operations on subtrees.  The results are tidy\n"
"	trees and efficient relayouts when the tree changes.\n"
"\n"
"	In the Layout step, the tree is traversed in depth-first\n"
"	fashion until the leaf nodes are reached.  The contour\n"
"	of each leaf node is formed by creating a linked list of\n"
"	lines that wrap around the node's shape.  This is the \n"
"	LayoutLeaf step.  As the return trip is made back to the\n"
"	root, the contour of each interior node is formed by\n"
"	joining the individual contours of each child. This Join\n"
"	step involves a Merge step where the offset between\n"
"	two neighboring contours is computed to avoid overlap. \n"
"	Since the width of each subtree contour is known at\n"
"	each step, each interior node is centered over its\n"
"	children, and the subtree contour is extended to include\n"
"	the interior node.  This is the AttachParent step.\n"
"\n"
"	In a dynamic update operation (insert or delete), the\n"
"	algorithm reuses the contours not influenced by the\n"
"	change and updates them efficiently. When a given \n"
"	node changes, subtree contours at higher levels must\n"
"	be disassembled before the change. This is called\n"
"	the Unzip step, which call RuboutLeaf, Split, and\n"
"	DetachParent, all inverses of LayoutLeaf, Join, and\n"
"	AttachParent, respectively.  After the change is made,\n"
"	the Zip step reassembles the contours by again calling\n"
"	Layout, Join, and AttachParent.\n"
"\n"
"User Interface\n"
"	\n"
"	This program offers an interactive environment for \n"
"	creating and updating trees of arbitrary size. Trees\n"
"	can be loaded from a file or created on-the-fly.  You\n"
"	can also save trees, and specify various layout and\n"
"	animation options.  Each feature is associated with \n"
"	a menu item which is explained in the next section.\n"
"\n"
"	When invoking the program, you may specify a single\n"
"	argument indicating the name of a tree file. This file\n"
"	will be loaded upon startup. If you start the program\n"
"	without arguments, the canvas will be blank.\n"
"\n"
"Tree Menu\n"
"\n"
"	New Tree...	Create a new tree. You specify \n"
"			a new root, and the existing tree, \n"
"			if any, is deleted.\n"
"\n"
"	Load Tree...	Load a tree specification file.\n"
"			(see the File Format section)\n"
"\n"
"	Save Tree...	Save a tree specification file.\n"
"			(see the File Format section)\n"
"\n"
"	Quit		Exits the program.\n"
"\n"
"Layout Menu\n"
"\n"
"	Layout Spacing...\n"
"			Displays a dialog that allows you\n"
"			to change the spacing between nodes\n"
"			on the same level and the spacing\n"
"			between levels. \n"
"\n"
"	Align Nodes on Level\n"
"			Adds a constraint to the layout\n"
"			algorithm that forces all nodes\n"
"			on the same level to have the same\n"
"			x-position. This leads to truncation\n"
"			of nodes if necessary. The maximum\n"
"			node width is controlled by the\n"
"			Level Spacing. By default, this is\n"
"			disabled.\n"
"\n"
"Node Menu\n"
"\n"
"	This popup menu is invoked by pressing and holding\n"
"	the left mouse button on a node. This menu offers\n"
"	several actions that can be performed on nodes.\n"
"\n"
"	Add Child	Add a child to the node. The new child\n"
"			is added after the bottommost child.\n"
"\n"
"	Add Sibling Before\n"
"			Add a sibling before this node.\n"
"\n"
"	Add Sibling After\n"
"			Add a sibling after this node.\n"
"\n"
"	Collapse Node	Collapses or expands the subtree\n"
"	Expand Node	beginning at the specified node.\n"
"			This operation is similiar to a\n"
"			Delete operation, except that the\n"
"			subtree is preserved so that you\n"
"			can display it again. Collapsed\n"
"			nodes are marked with a gray box.\n"
"\n"
"	Delete Node	Delete the subtree beginning at the\n"
"			specified node.\n"
"\n"
"Tree File Format\n"
"\n"
"	If you wish to load a file, you can load a file created\n"
"	by the OO-Browser with the {C-c d}, (br-xbr) command.\n"
"\n"
"	Node labels are sequences of characters delimited by\n"
"	newlines or end-of-file. \n"
"\n"
"	Files must begin with an OO-Browser Environment path\n"
"	name.  The next line must be a label, which indicates the\n"
"	root node.  Optionally, lists containing labels may\n"
"	follow. Each child label is indented two spaces more \n"
"	its parent. Lists of labels are nested to produce trees. \n"
"\n"
"	For example, a three-level binary tree is as follows:\n"
"\n"
"		^^c++-^^~/OOBR\n"
"		root node level1\n"
"		  level2-1\n"
"		    level3-1\n"
"		    level3-2\n"
"		  level2-2\n"
"		    level3-3\n"
"		    level3-4\n"
"\n"
"X11 Resources\n"
"\n"
"	Various settings in the program can be manipulated by \n"
"	using X11 resources, specified either on the command\n"
"	line or in a resource setting file. The supported \n"
"	resources are:\n"
"\n"
"	tree.font:	Sets the font of the label nodes.\n"
"			Default is \"fixed\".\n"
"\n"
"	tree.backgroundColor:\n"
"			Sets the background color of the \n"
"			canvas.  Default is \"white\".\n"
"\n"
"	tree.treeColor:	Sets the color of the displayed tree.\n"
"			Default is \"black\".\n"
"\n"
"	tree.splitColor:\n"
"			Sets the color of split contours which\n"
"			appear during a dynamic update.\n"
"			Default is \"goldenrod\".\n"
"	\n"
"	tree.highlightColor:\n"
"			Sets the color of highlighted nodes.\n"
"			Default is \"OrangeRed\".\n"
"\n"
"Help\n"
"\n"
"	If you are reading this, chances are that you found the\n"
"	Help button on the menubar. \n"
"\n"
"Author\n"
"	\n"
"	This program was written by Mark L. Stern during\n"
"	the summer of 1990.  It was redone by Bob Weiner for\n"
"	use with the OO-Browser.\n"
"\n"
"	Stephan Zachwieja contributed the double-buffering\n"
"	code used for smooth animations in this program.\n"
"\n"
"	The other authors have permitted Bob Weiner to distribute\n"
"	the code freely as part of the OO-Browser.\n";
