// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        language.h
//
// Purpose:     class HgLanguage for language specification
//
// Created:     12 Jan 94    Michael Pichler
//
// Modified:    15 Mar 94    Michael Pichler
//
//
//
// Description:
//
// Language can be specified either with strings or enum HgLanguage::Language;
// class HgLanguage cares for conversion
//
//
//</file>


#ifndef hg_hyperg_language_h
#define hg_hyperg_language_h



class HgLanguage
{
  public:
    enum Language {
      English, German, Styrian, French, Italian, Spanish,
      NumLanguages,  // no. of languages
      Default = English  // default language
    };

    static Language getLanguage(                   // convert language string to enum
      const char* str,                             //   language string of form "xx" or "xx:"
      Language def = Default                       //   default return value (if no such string)
    );                                             // e.g.: getLanguage("st")=Styrian

    static Language nameToEnum(                    // convert language name to enum
      const char* str,                             //   language name (english, case-insensitive)
      Language def = Default                       //   default return value (if no such string)
    );                                             // e.g.: nameToEnum("Styrian")=Styrian

    static int isValid(                            // check validity
      const char* str                              //   of a language string ("xx" or "xx:")
    );                                             // e.g.: isValid("st")=true

    static const char* getLanguageString(          // translate enum to language string ("xx")
      Language lang = Default                      //   language enum
    );                                             //   without arg: default language string ("en")
                                                   // e.g.: getLanguageString(Styrian)="st"

    static const char* translateLanguage(          // get a language name in any language
      Language langname,                           //   language name to be translated
      Language langdest                            //   destination language
    );                                             // e.g.: translateL.(Styrian,German)="Steirisch"

  private:
    static const char* langstr_ [NumLanguages];
};



inline int HgLanguage::isValid(const char* str)
{
  return (getLanguage (str, NumLanguages) != NumLanguages);
}


inline const char* HgLanguage::getLanguageString(Language lang)
{
  return ((unsigned) lang < NumLanguages) ? langstr_ [lang] : 0;
}



#endif
