// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1993,94
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        cursors.h
//
// Purpose:     Interface to class HgCursors
//
// Created:     20 Jul 93   Gaisbauer Mansuet Juergen
//
// Changed:     19 Jul 94   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_cursors_h
#define harmony_widgets_cursors_h


#include <InterViews/cursor.h>
class Bitmap;
class Color;


//<class>
//
// Name: HgCursors
//
// Purpose: provide shared Cursor-objects
//
// Public Interface:
//
// - HgCursors()
//   Constructor. Need not be called - use instance().
//
// - ~HgCursors()
//   Destructor.
//
// - static HgCursors* instance()
//   returns a pointer to the HgCursors-object. If no object was created
//   before the call, this function creats one.
//
// - Cursor* hourglass()
//           crosshair()
//           aeroplane()
//   returns a pointer to a cursor, shaped as
//     hourglass/crosshair/aeroplane
//
// - Cursor* animatedBusy()
//   on each call the next cursor of a series is returned
//   repeated calls thus provide an animated busy cursor;
//   foreground and background are similar to Harmony logo;
//   attribute size does not apply (always 16x16)
//
// Description:
//
// Only ONE object of class HgCursors is created in a program, it is
// accessed via HgCursors::instance ()
//
//
// X-attributes:
//
// Cursor.size (integer)
//   desired cursor size. Available: 32 or 16 (default)
// Cursor.fillBusy (boolean)
//   flag whether animated busy cursor should have a filled background.
//
//</class>



class HgCursors
{
  private:
    HgCursors();
#ifdef __GNUC__
  public:
#endif
    ~HgCursors();  // deletes cursors

  public:
    static HgCursors* instance();

    Cursor* hourglass();
    Cursor* crosshair();
    Cursor* aeroplane();

    Cursor* animatedBusy();

  private:
    static HgCursors* instance_;

    int size_;
    int fillbusy_;
    Cursor* hourglass_,
          * crosshair_,
          * aeroplane_;

    enum { NumBusy = 4 };
    Cursor* busy_ [NumBusy];
    Color* busyforeground_;
    Color* busybackground_;
    int curbusy_;
};



#endif
