/*
 *  nwsfind.c
 *
 *  Find a NetWare server and open a route to it.
 *  This tool can safely be setuid root, if normal users should be able to
 *  access any NetWare server.
 *
 *  Copyright (C) 1996 by Volker Lendecke
 *
 */

#include "./include/ncplib.h"
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
#include <ctype.h>

int main()
{
	const char *server = NULL;
	struct sockaddr_ipx addr;
	long err;
	struct ncp_conn *conn;

	struct ncp_bindery_object obj;
	int found = 0;
	char default_pattern[] = "*";
	char *pattern = default_pattern;
	char *p;

/*** default connect **/

printf("server  : %s\n",server);
err = ncp_find_server(&server, NCP_BINDERY_FSERVER, (struct sockaddr*)&addr, sizeof(addr));

	if (err != 0)
	{
		com_err("", err, "when trying to find server");
		exit(1);
	}

	ipx_print_saddr(&addr);
	printf(" %s\n", server);


err = 0;
conn = ncp_open_addr((struct sockaddr*)&addr, &err);
printf("error = %d\n",err);


/** server list **/

	obj.object_id = 0xffffffff;
	for (p = pattern; *p != '\0'; p++)
	{
		*p = toupper(*p);
	}

	while (ncp_scan_bindery_object(conn, obj.object_id,
				       NCP_BINDERY_FSERVER, pattern,
				       &obj) == 0)
	{
		struct nw_property prop;
		struct prop_net_address *naddr
		= (struct prop_net_address *) &prop;

		found = 1;

		printf("%-52s", obj.object_name);

		if (ncp_read_property_value(conn, NCP_BINDERY_FSERVER,
					    obj.object_name, 1, "NET_ADDRESS",
					    &prop) == 0)
		{
			ipx_print_network(naddr->network);
			printf("  ");
			ipx_print_node(naddr->node);
		}
		printf("\n");
	}

/** done **/

	ncp_close(conn);
        return 0;
}
