/*
 * exfunc.c
 *
 * This file contains a function extracting compressed data from a ZIP-archive.
 * Gratefully received from a person who wishes to remain anonymous.
 * Slightly modified by Peter Conrad, Aug '96
 *
 * $Id: exfunc.c,v 1.3 1996/08/21 18:17:57 conrad Release1_2 $
 *
 * $Log: exfunc.c,v $
 * Revision 1.3  1996/08/21 18:17:57  conrad
 * Some cleanups to suppress some warnings...
 *
 * Revision 1.2  1996/08/21 17:33:00  conrad
 * some cleaning up with regard to variables
 * moved strupr() here (from extract.c)
 * changed parameters of read_{local,dir,end}()
 *
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include "headers.h"

static char RCSID[]="$Id: exfunc.c,v 1.3 1996/08/21 18:17:57 conrad Release1_2 $";

extern int      read_sig( FILE *fp );
extern int      read_local( FILE *fp, char *fname, int noskip );
extern int      read_dir( FILE *fp, int noskip );
extern int      read_end( FILE *fp, int noskip );

#define	TRUE	1
#define	FALSE	0

#ifdef	NO_STRUPR
char *strupr( char *aString )
{
int	i;
char	*newStr;

    if( !aString )
	return NULL;

    newStr = strdup( aString );
    for( i = strlen( newStr ) - 1; i >= 0; i-- )
	newStr[i] = toupper( newStr[i] );

    return newStr;
}
#endif	/* NO_STRUPR */

char *extract(char *zipname, char *decfile)
{
int end;
int error;
int found;
int ret;
int rc;
char	*data;
FILE	*fp;               /* ZIP file pointer */

  fp = fopen(zipname, "rb");
  if(fp==NULL)
  {
    perror("Error opening the ZIP file");
    return(0);
  }

  /****************************************************************************/
  /* Search the given file in the ZIP archive                                 */
  /****************************************************************************/
  found = FALSE;
  error = FALSE;
  end = FALSE;
  do
  {
    ret = read_sig(fp);
    switch(ret)
    {
      case(LOCAL):
        {
#ifdef DEBUG
	  printf("\nFile signature found\n");
#endif
	  rc = read_local(fp,decfile,0);
	  switch(rc)
	  {
	    case 1:
	      {
	        found = TRUE;
	        end = TRUE;
	      }
	      break;
	    case 0:
	      break;
	    case -1:
	      {
	        printf("Error reading ZIP file\n");
	        end = TRUE;
	        error = TRUE;
	      }
	      break;
	  }
	}
	break;

      case(DIR):
        {
	  read_dir(fp,0);
	}
	break;

      case(END):
        {
	  read_end(fp,0);
	  end = TRUE;
	}
	break;

      default:
        printf("Error: unknown signature (ZIP file may be corrupt)\n");
	end = TRUE;
	error = TRUE;
	break;
    }
  } while (end == FALSE);

  if(error == TRUE)
  {
    fclose( fp );
    return(0);
  }
  else;

  if(found == FALSE)
  {
    fclose( fp );
    printf("File %s not found in ZIP file\n", decfile);
    return(0);
  }
  else;

  data = malloc( lh.csize );

  if(!data)
  {
    fclose( fp );
    printf("Error allocating memory\n");
    return(0);
  }
  else;

  end = FALSE;
  error = FALSE;
  ret = fread(data, (size_t) lh.csize, 1, fp);
  if(ret != 1)
  {
    perror("Error reading ZIP file");
    end = TRUE;
    error = TRUE;
    free(data);
  }

  fclose(fp);

#ifdef DEBUG
  printf("File closed, read %ld bytes\n", count);
#endif

  if( !error )
    return(data);
  else
    return 0;
}
