Summary: Apache HTTP daemon with SSL
Name: apache-mod_ssl
%define apversion 1.3.6
%define modversion 2.2.8
Version: %{apversion}-%{modversion}
# Serial number taken from APACHE_RELEASE definition in src/include/httpd.h
# Update serial number when the Apache version is changed.
Serial: 10306100
Release: 2
Group: Networking/Daemons
Source0: ftp://ftp.apache.org/apache/dist/apache_%{apversion}.tar.gz
Source1: http://www.engelschall.com/sw/mod_ssl/mod_ssl-%{modversion}-%{apversion}.tar.gz
Source2: httpd.init
Source3: httpd.log
Source4: httpd.conf.patch
Source5: Makefile.tmpl.patch
Source6: README.suexec
Copyright: BSD-like
Obsoletes: apache-suexec apache-extra apache-doc
Provides: webserver apache apache-mod_ssl
BuildRoot: /var/tmp/apache-root
Requires: initscripts >= 3.25
Prereq: /sbin/chkconfig
URL: http://www.engelschall.com/sw/mod_ssl/
Packager: Magnus Stenman <stone@hkust.se>, Henri Gomez <gomez@slib.fr>


%description
apache-mod_ssl is Apache with SSL support
via mod_ssl and OpenSSL

This build is not for use in the U.S., you will have
to build your own apache-mod_ssl with RSAref for that
due to patent problems.

Built with loadable modules (all standard modules enabled).
The configuration files provided with apache
and apache-mod_ssl are unchanged.

Built for glibc6 on RedHat 5.2


%package devel
Group: Development/Libraries
Summary: Module development tools for apache-mod_ssl.
Obsoletes: secureweb-devel


%description devel
The apache-devel package contains header files and the
apxs script needed to build Dynamic Shared Objects (DSOs) for Apache.

If you are installing apache-mod_ssl, and want to be able
to compile or develop additional modules, you'll have to
install this package.


%prep 
rm -rf apache-ssl_%{version}
mkdir -p apache-ssl_%{version}
%setup -T -D -a 0 -n apache-ssl_%{version}
%setup -T -D -a 1 -n apache-ssl_%{version}

# bugfix for apache 1.3.6
patch -p0 apache_%{apversion}/Makefile.tmpl < $RPM_SOURCE_DIR/Makefile.tmpl.patch


%build
cd mod_ssl-%{modversion}-%{apversion}

OPTIM="$RPM_OPT_FLAGS" ./configure \
	--with-perl=/usr/bin/perl \
	--with-apache=../apache_%{apversion} \
	--with-ssl=SYSTEM \
	--enable-module=define \
	--prefix=/home/httpd \
	--sysconfdir=/etc/httpd/conf \
	--datadir=/home/httpd \
	--bindir=/usr/bin \
	--sbindir=/usr/sbin \
	--libexecdir=/usr/lib/apache \
	--includedir=/usr/include/apache \
	--logfiledir=/var/log/httpd \
	--localstatedir=/var \
	--runtimedir=/var/run \
	--proxycachedir=/var/cache/httpd \
	--mandir=/usr/man \
	--enable-module=all \
	--enable-shared=max \
	--enable-suexec --suexec-caller=nobody \
	--suexec-uidmin=500 --suexec-gidmin=500

cd ../apache_%{apversion}
make
make certificate TYPE=dummy


%install
rm -rf $RPM_BUILD_ROOT
cd apache_%{apversion}
make install-quiet root="$RPM_BUILD_ROOT" \
	conf_group="nobody" \
	conf_port="80" \
	conf_port_ssl="443" \
	conf_serveradmin="webmaster@localhost" \
	conf_servername="localhost"

strip $RPM_BUILD_ROOT/usr/sbin/httpd

# html files
mv $RPM_BUILD_ROOT/home/httpd/htdocs $RPM_BUILD_ROOT/home/httpd/html

# the search script is not used
rm -r $RPM_BUILD_ROOT/home/httpd/html/manual/search/

# patch httpd.conf to point to /home/httpd/html...
patch -p0 $RPM_BUILD_ROOT/etc/httpd/conf/httpd.conf < $RPM_SOURCE_DIR/httpd.conf.patch

# sysv init and logging
mkdir -p $RPM_BUILD_ROOT/etc/{logrotate.d,rc.d/init.d}
install $RPM_SOURCE_DIR/httpd.log $RPM_BUILD_ROOT/etc/logrotate.d/httpd
install $RPM_SOURCE_DIR/httpd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/httpd


%clean
rm -rf "$RPM_BUILD_ROOT"


%post
/sbin/chkconfig --add httpd
echo ""
echo ""
echo "As supplied httpd -DSSL will run with a dummy certificate!!"
echo ""
echo "You need a server.key file in /etc/httpd/conf/ssl.key/"
echo "and you need a server.crt file in /etc/httpd/conf/ssl.crt/"
echo "After that you have to run make in that directory."
echo ""
echo "You better edit (and understand) /etc/httpd/conf/*.conf"
echo "to suit your needs!!!"
echo ""


%preun
if [ $1 = 0 ]; then
	if [ -f /var/lock/subsys/httpd ]; then
		/etc/rc.d/init.d/httpd stop
	fi
	if [ -f /etc/rc.d/init.d/httpd ]; then
		/sbin/chkconfig --del httpd
	fi
fi


%files
%defattr(644 root root 755)
%attr(755,root,root)  %dir /etc/httpd
%attr(755,root,root)  %dir /etc/httpd/conf
%attr( - ,root,root)  %config /etc/httpd/conf/ssl.crt
%attr( - ,root,root)  %config /etc/httpd/conf/ssl.csr
%attr( - ,root,root)  %config /etc/httpd/conf/ssl.key
%attr(644,root,root)  %config /etc/httpd/conf/httpd.conf
%attr(644,root,root)  %config /etc/httpd/conf/magic
%attr(644,root,root)  %config /etc/httpd/conf/mime.types
%attr(644,root,root)  /etc/httpd/conf/httpd.conf.default
%attr(644,root,root)  %config /etc/logrotate.d/*
%attr(755,root,root)  %config /etc/rc.d/init.d/*

%attr( - ,root,root)  %doc apache_%{apversion}/{ABOUT_APACHE,KEYS}
%attr( - ,root,root)  %doc apache_%{apversion}/{LICENSE,LICENSE.SSL,README,README.SSL}
%attr( - ,root,root)  %doc apache_%{apversion}/src/{CHANGES,CHANGES.SSL}
%attr( - ,root,root)  %doc apache_%{apversion}/src/support/suexec.[ch]
%attr( - ,root,root)  %doc mod_ssl-%{modversion}-%{apversion}/README.*
%attr( - ,root,root)  %doc $RPM_SOURCE_DIR/README.suexec

%attr(755,root,root)  %dir /home/httpd
%attr(755,root,root)  %dir /home/httpd/html
%attr(755,root,root)  %dir /home/httpd/cgi-bin
%attr( - ,root,root)  /home/httpd/icons
%attr(644,root,root)  %config(noreplace) /home/httpd/html/index.html
%attr(644,root,root)  /home/httpd/html/apache_pb.gif
%attr( - ,root,root)  %docdir /home/httpd/html/manual
%attr( - ,root,root)  /home/httpd/html/manual

%attr( - ,root,root)  /usr/lib/apache
%attr( - ,root,root)  /usr/man/man1/*
%attr( - ,root,root)  /usr/man/man8/ab.8
%attr( - ,root,root)  /usr/man/man8/apachectl.8
%attr( - ,root,root)  /usr/man/man8/httpd.8
%attr( - ,root,root)  /usr/man/man8/logresolve.8
%attr( - ,root,root)  /usr/man/man8/rotatelogs.8
%attr( - ,root,root)  /usr/man/man8/suexec.8

%attr( - ,root,root)  /usr/sbin/ab
%attr( - ,root,root)  /usr/sbin/apachectl
%attr( - ,root,root)  /usr/sbin/httpd
%attr( - ,root,root)  /usr/sbin/logresolve
%attr( - ,root,root)  /usr/sbin/rotatelogs
%attr(711,root,root)  /usr/sbin/suexec
%attr( - ,root,root)  /usr/bin

%attr(-,nobody,nobody) %dir /var/cache/httpd
%attr( - ,root,root)  %dir /var/log/httpd


%files devel
%defattr(644 root root 755)
%attr( - ,root,root)  /usr/include/apache
%attr( - ,root,root)  /usr/sbin/apxs
%attr( - ,root,root)  /usr/man/man8/apxs.8


%changelog
* Wed Apr 21 1999 Magnus Stenman <stone@hkust.se>
- Moved header files and apxs to -devel package
  Stripped httpd binary
  Removed suid bit from suexec (see README.suexec)
  Thanks to Mike McHenry <mmchen@minn.net>
  and David Harris <dharris@drh.net>

* Mon Apr 12 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.2.8

* Mon Mar 29 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.2.7

* Wed Mar 24 1999 Magnus Stenman <stone@hkust.se>
- New versions of apache and mod_ssl
- Added the new --enable-module=define
- Included more mod_ssl READMEs

* Fri Mar 19 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl

* Sun Feb 21 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl
- Removed SSLeay explicit require,
  libssl.so.0 and libcrypto.so.0 can be provided by any package.
  Thanks to Niels Poppe <niels@netbox.org>

* Mon Feb  5 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl

* Mon Feb  4 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl

* Mon Feb  1 1999 Henri Gomez <gomez@slib.fr>
- ServerRoot is in /home/httpd/html instead of /home/httpd/htdocs
  to follow Redhat way.
- Added provide WebServer for mod_php3.

* Thu Jan 28 1999 Magnus Stenman <stone@hkust.se>
- Fixed include files needed for apxs compiles
  Thanks to Manuel J. Galan <manolow@step.es>

* Wed Jan 27 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl
  Changed directory layout to be more "RedHat style"

* Wed Jan 20 1999 Magnus Stenman <stone@hkust.se>
- Initial build by Magnus, tweaked so it fits me.
  Based on the SRPM by Manuel J. Galan <manolow@step.es>
