/* p12_init.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <err.h>
#include <rand.h>
#include "pkcs12.h"

/* Initialise a PKCS12 structure to take data */

PKCS12 *PKCS12_init (mode)
int mode;
{
	PKCS12 *pkcs12;
	if (!(pkcs12 = PKCS12_new())) {
		PKCS12err(PKCS12_F_PKCS12_INIT,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	if (!(pkcs12->version = ASN1_INTEGER_new ())) {
		PKCS12err(PKCS12_F_PKCS12_INIT,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	ASN1_INTEGER_set (pkcs12->version, 3);
	if (!(pkcs12->authsafes = PKCS7_new())) {
		PKCS12err(PKCS12_F_PKCS12_INIT,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	M_ASN1_OBJECT_set(pkcs12->authsafes->type, mode);
	switch (mode) {
		case NID_pkcs7_data:
			if (!(pkcs12->authsafes->d.data =
				 ASN1_OCTET_STRING_new())) {
			PKCS12err(PKCS12_F_PKCS12_INIT,ERR_R_MALLOC_FAILURE);
			return NULL;
		}
		break;
		default:
			PKCS12err(PKCS12_F_PKCS12_INIT,PKCS12_R_UNSUPPORTED_PKCS12_MODE);
			PKCS12_free(pkcs12);
			return NULL;
		break;
	}
		
	return pkcs12;
}

/* Return an algorithm identifier for a PBE algorithm */

X509_ALGOR *PKCS12_pbe_set(alg, iter, salt, saltlen)
int alg;
int iter;
unsigned char *salt;
int saltlen;
{
	unsigned char *pdata, *ptmp;
	int plen;
	PBEPARAM *pbe;
	ASN1_OBJECT *al;
	X509_ALGOR *algor;
	ASN1_TYPE *astype;

	if (!(pbe = PBEPARAM_new ())) {
		PKCS12err(PKCS12_F_PKCS12_PBE_SET,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	ASN1_INTEGER_set (pbe->iter, iter);
	if (!saltlen) saltlen = PKCS12_SALT_LEN;
	if (!(pbe->salt->data = Malloc (saltlen))) {
		PKCS12err(PKCS12_F_PKCS12_PBE_SET,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	pbe->salt->length = saltlen;
	if (salt) memcpy (pbe->salt->data, salt, saltlen);
	else RAND_bytes (pbe->salt->data, saltlen);
	if (!(plen = i2d_PBEPARAM (pbe, NULL))) {
		PKCS12err(PKCS12_F_PKCS12_PBE_SET,PKCS12_R_ENCODE_ERROR);
		return NULL;
	}
	if (!(pdata = Malloc (plen))) {
		PKCS12err(PKCS12_F_PKCS12_PBE_SET,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	ptmp = pdata;
	i2d_PBEPARAM (pbe, &ptmp);
	PBEPARAM_free (pbe);

	if (!(astype = ASN1_TYPE_new())) {
		PKCS12err(PKCS12_F_PKCS12_PBE_SET,ERR_R_MALLOC_FAILURE);
		return NULL;
	}

	astype->type = V_ASN1_SEQUENCE;
	if (!(astype->value.sequence=ASN1_STRING_new())) {
		PKCS12err(PKCS12_F_PKCS12_PBE_SET,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	ASN1_STRING_set (astype->value.sequence, pdata, plen);
	Free (pdata);
	
	al = OBJ_nid2obj(alg); /* never need to free al */
	if (!(algor = X509_ALGOR_new())) {
		PKCS12err(PKCS12_F_PKCS12_PBE_SET,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	ASN1_OBJECT_free(algor->algorithm);
	algor->algorithm = al;
	algor->parameter = astype;

	return (algor);
}

static int p12_nid = -1;

void PKCS12_lib_init()
{
	if (p12_nid != -1) return;
	PKCS12_add_obj();
	PKCS12_PBE_add();
	ERR_load_PKCS12_strings();
}

/* Object creation stuff */

#define _OBJ_pkcs12			"1.2.840.113549.1.12."
#define _OBJ_pkcs9			"1.2.840.113549.1.9."
#define _OBJ_pkcs12_pbeids		_OBJ_pkcs12 "1."
#define _OBJ_pkcs12_BagIds		_OBJ_pkcs12 "10.1."
#define _OBJ_certTypes			_OBJ_pkcs9 "22."
#define _OBJ_crlTypes			_OBJ_pkcs9 "23."


int PKCS12_obj_offset()
{
	return p12_nid;
}

void PKCS12_add_obj ()
{
if (p12_nid != -1) return;
p12_nid = OBJ_create (_OBJ_pkcs12_pbeids "1",
		 	"PBESHA1RC4", "pbeWithSHA1And128BitRC4");
OBJ_create (_OBJ_pkcs12_pbeids "2", 
			"PBESHA1RC4-40", "pbeWithSHA1And40BitRC4");
OBJ_create (_OBJ_pkcs12_pbeids "3", 
	"PBESHA1DES3", "pbeWithSHA1And3-KeyTripleDES-CBC");
OBJ_create (_OBJ_pkcs12_pbeids "4", 
	"PBESHA1DES2", "pbeWithSHA1And2-KeyTripleDES-CBC");
OBJ_create (_OBJ_pkcs12_pbeids "5", 
	"PBESHA1RC2", "pbeWithSHA1And128BitRC2-CBC");
OBJ_create (_OBJ_pkcs12_pbeids "6", 
	"PBESHA1RC2-40", "pbeWithSHA1And40BitRC2-CBC");

OBJ_create (_OBJ_pkcs12_BagIds "1", "keyBag", "keyBag");
OBJ_create (_OBJ_pkcs12_BagIds "2",
				 "pkcs8ShroudedKeyBag", "pkcs8ShroudedKeyBag");
OBJ_create (_OBJ_pkcs12_BagIds "3", "certBag", "certBag");
OBJ_create (_OBJ_pkcs12_BagIds "4", "crlBag", "crlBag");
OBJ_create (_OBJ_pkcs12_BagIds "5", "secretBag", "secretBag");
OBJ_create (_OBJ_pkcs12_BagIds "6", "safeContentsBag", "safeContentsBag");

OBJ_create (_OBJ_pkcs9 "20", "friendlyName", "friendlyName");
OBJ_create (_OBJ_pkcs9 "21", "localKeyID", "localKeyID");

OBJ_create (_OBJ_certTypes "1", "x509Certificate", "x509Certificate");
OBJ_create (_OBJ_certTypes "2", "sdsiCertificate", "sdsiCertificate");

OBJ_create (_OBJ_crlTypes "1", "x509Crl", "x509Crl");
#define OBJ_HACK
#ifdef OBJ_HACK
/* This is a workaround for an object creation bug in SSLeay 0.9.0:
 * dynamic objects get partially freed up by ASN1_OBJECT_free 
 * because they have the wrong flags: this took *ages* to find.
 */
{
	int i;
	ASN1_OBJECT *obj;
	for (i = p12_nid; i <= OBJ_sn2nid("x509Crl"); i++) {
		obj = OBJ_nid2obj(i);
		obj->flags &= ~ASN1_OBJECT_FLAG_DYNAMIC_DATA;
	}
}
#endif
}
