/* p12_mutl.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <err.h>
#include <hmac.h>
#include <rand.h>
#include "pkcs12.h"

/* Generate a MAC */
int PKCS12_gen_mac (p12, pass, passlen, mac, maclen)
PKCS12 *p12;
unsigned char *pass;
int passlen;
unsigned char *mac;
unsigned int *maclen;
{
	EVP_MD *md_type;
	HMAC_CTX hmac;
	unsigned char key[PKCS12_MAC_KEY_LENGTH], *salt;
	int saltlen, iter;
	salt = p12->mac->salt->data;
	saltlen = p12->mac->salt->length;
	if (!p12->mac->iter) iter = 1;
	else iter = ASN1_INTEGER_get (p12->mac->iter);
    	if(!(md_type =
		 EVP_get_digestbyobj (p12->mac->dinfo->algor->algorithm))) {
		PKCS12err(PKCS12_F_PKCS12_GEN_MAC,PKCS12_R_UNKNOWN_DIGEST_ALGORITHM);
		return 0;
	}
	if(!PKCS12_key_gen (pass, passlen, salt, saltlen, PKCS12_MAC_ID, iter,
				 PKCS12_MAC_KEY_LENGTH, key, md_type)) {
		PKCS12err(PKCS12_F_PKCS12_GEN_MAC,PKCS12_R_KEY_GEN_ERROR);
		return 0;
	}
	HMAC_Init (&hmac, key, PKCS12_MAC_KEY_LENGTH, md_type);
    	HMAC_Update (&hmac, p12->authsafes->d.data->data,
					 p12->authsafes->d.data->length);
    	HMAC_Final (&hmac, mac, maclen);
	return 1;
}

/* Verify the mac */
int PKCS12_verify_mac (p12, pass, passlen)
PKCS12 *p12;
unsigned char *pass;
int passlen;
{
	unsigned char mac[EVP_MAX_MD_SIZE];
	unsigned int maclen;
	if (!PKCS12_gen_mac (p12, pass, passlen, mac, &maclen)) {
		PKCS12err(PKCS12_F_VERIFY_MAC,PKCS12_R_MAC_GENERATION_ERROR);
		return 0;
	}
	if ((maclen != (unsigned int)p12->mac->dinfo->digest->length)
	|| memcmp (mac, p12->mac->dinfo->digest->data, maclen)) {
		PKCS12err(PKCS12_F_VERIFY_MAC,PKCS12_R_MAC_VERIFY_ERROR);
		return 0;
	}
	return 1;
}

/* Set a mac */

int PKCS12_set_mac (p12, pass, passlen, salt, saltlen, iter, md_type)
PKCS12 *p12;
unsigned char *pass;
int passlen;
unsigned char *salt;
int saltlen;
int iter;
EVP_MD *md_type;
{
	unsigned char mac[EVP_MAX_MD_SIZE];
	int maclen;
	if (!md_type) md_type = EVP_sha1();
	if (PKCS12_setup_mac (p12, iter, salt, saltlen, md_type) ==
				 	PKCS12_ERROR) {
		PKCS12err(PKCS12_F_PKCS12_SET_MAC, PKCS12_R_MAC_SETUP_ERROR);
		return 0;
	}
	if (!PKCS12_gen_mac (p12, pass, passlen, mac, &maclen)) {
		PKCS12err(PKCS12_F_PKCS12_SET_MAC, PKCS12_R_MAC_GENERATION_ERROR);
		return 0;
	}
	if (!(ASN1_OCTET_STRING_set (p12->mac->dinfo->digest, mac, maclen))) {
		PKCS12err(PKCS12_F_PKCS12_PKCS12_SET_MAC,PKCS12_R_MAC_STRING_SET_ERROR);
						return 0;
	}
	return 1;
}

/* Set up a mac structure */
int PKCS12_setup_mac (p12, iter, salt, saltlen, md_type)
PKCS12 *p12;
int iter;
unsigned char *salt;
int saltlen;
EVP_MD *md_type;
{
	if (!(p12->mac = PKCS12_MAC_DATA_new ())) return PKCS12_ERROR;
	if (iter > 1) {
		if(!(p12->mac->iter = ASN1_INTEGER_new())) {
			PKCS12err(PKCS12_F_PKCS12_SETUP_MAC, ERR_R_MALLOC_FAILURE);
			return 0;
		}
		ASN1_INTEGER_set (p12->mac->iter, iter);
	}
	if (!saltlen) saltlen = PKCS12_SALT_LEN;
	p12->mac->salt->length = saltlen;
	if (!(p12->mac->salt->data = Malloc (saltlen))) {
		PKCS12err(PKCS12_F_PKCS12_SETUP_MAC, ERR_R_MALLOC_FAILURE);
		return 0;
	}
	if (!salt) RAND_bytes (p12->mac->salt->data, saltlen);
	else memcpy (p12->mac->salt->data, salt, saltlen);
	M_ASN1_OBJECT_set(p12->mac->dinfo->algor->algorithm,
							 EVP_MD_type(md_type));
	if (!(p12->mac->dinfo->algor->parameter = ASN1_TYPE_new())) {
		PKCS12err(PKCS12_F_PKCS12_SETUP_MAC, ERR_R_MALLOC_FAILURE);
		return 0;
	}
	p12->mac->dinfo->algor->parameter->type = V_ASN1_NULL;
	
	return 1;
}
