/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


/********************************************************************
 *	EXPORT:							    *
 *								    *
 *		aux_alias()					    *
 *		aux_alias2Name()				    *
 *		aux_alias2DName()				    *
 *		aux_Name2alias()				    *
 *		aux_DName2alias()				    *
 *		aux_Name2aliasf()				    *
 *		aux_DName2aliasf()				    *
 *		aux_add_alias_name()				    *
 *		aux_add_alias()					    *
 *		aux_delete_alias()				    *
 *		aux_fprint_alias2dname()			    *
 *		aux_fprint_dname2alias()			    *
 *		aux_search_AliasList()				    *
 *		aux_next_AliasList()				    *
 *		aux_alias_nxtname()				    *
 *		aux_alias_chkfile()				    *
 *		aux_alias_getall()				    *
 *		aux_get_AliasList()				    *
 *		aux_put_AliasList()				    *
 *		aux_check_AliasList()				    *
 *				  				    *
 *	LOCAL:							    *
 *								    *
 *		get_AliasList()					    *
 *		free_AliasList()				    *
 *		strmtch()					    *
 *                                                                  *
 *		aliaslist					    *
 *		last_aliaslist					    *
 *                                                                  *
 ********************************************************************/


#include <stdio.h>
#include "af.h"
#ifdef MAC 
#include <stdlib.h>
#include <string.h>
#include "Mac.h"
#endif

static AliasList * aliaslist;
static AliasList * last_aliaslist;

static Boolean      useralias_from_PSE;

static AliasList * get_AliasList();
void free_AliasList();
static char *strmtch();
DName *aux_ORName2DName();


#define ALIASFILE ".af-alias"

/************* external functions: ***************************/

/************* char string subfunctions imported**************/
/************* from EAN Version 1 str.h/str.c   **************/

char*
str_up( /* char *str */ );


/****************************************************************/

/*
 *	search alias
 *	return TRUE if found, else FALSE
 *
 */

Boolean
aux_alias(alias)
	char			*alias;
{
	char			*proc = "aux_alias";
	register AliasList	*aa;
	register Aliases 	*aliasmember;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!alias) return(FALSE);

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(FALSE); 			 /* no alias names read */
		
	aa = aliaslist;
	while (aa)  {
		aliasmember = aa->a;
		while (aliasmember)  {
			if (!strcmp(aliasmember->aname, alias)) return(TRUE);
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}


	return(FALSE);

}




/*
 *	search alias
 *	return pointer to owner's DName, else NULL
 */

DName
*aux_alias2DName(alias)
	Name * alias;
{
	DName   * dname;
	Name    * name;
	char	* proc = "aux_alias2DName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	name = aux_alias2Name(alias);

	if(name) {
		dname = aux_Name2DName(name);
		free(name);
	}
	else dname = (DName *)0;

	return (dname);
}




/*
 *	search alias
 *	return pointer to owner's Name, else NULL
 */

Name
*aux_alias2Name(alias)
	char    *alias;
{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char    *target, *zwalias, *zwalias2, *dd;
	DName   *zwdname;
	Boolean alias_in_Name_form = FALSE, free_dd = FALSE;
	char	*proc = "aux_alias2Name";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(aux_cpy_String(alias));  /* no alias names read */

	zwalias = (char *)0;
	if(strchr(alias, '=')) {

		/* if alias names are in the Name form, compare on the basis of
                   normalized names. Ignore ORName attributes.  */
 
		alias_in_Name_form = TRUE;
		zwdname = aux_ORName2DName(alias);
		if(zwdname) {
			zwalias = aux_DName2CAPITALName(zwdname);
			aux_free_DName(&zwdname);
		}
	}
	if(!zwalias) zwalias = aux_cpy_String(alias);


	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
			dd = aliasmember->aname;
			free_dd = FALSE;
			if(alias_in_Name_form && strchr(aliasmember->aname, '=')) {
				zwdname = aux_ORName2DName(aliasmember->aname);
				if(zwdname) {
					dd = aux_DName2CAPITALName(zwdname);
					free_dd = TRUE;
					aux_free_DName(&zwdname);
				}
				else aux_free_error();
			}

			if (strcmp(dd, zwalias) == 0) {

				/* alias found, return target */
			
				free(zwalias);
				if(free_dd) free(dd);

				return(aux_cpy_String(aa->dname));
			}

			if(free_dd) free(dd);
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	/* alias not found */

	free(zwalias);
        return(aux_cpy_String(alias));
}




/*
 *	search alias for DName with given flag for alias type
 *	return pointer to alias on success, else NULL
 */

char
*aux_DName2alias(dname, type)
	DName 			*dname;
	AliasType 		type;
{
	char			*proc = "aux_DName2alias";
	Name 			*name;
	char 			*alias;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if(!dname) return (CNULL);

	name = aux_DName2Name(dname);
	if(!name) return (CNULL);

	alias = aux_Name2alias(name, type);

	if (name) free(name);
	if (!alias) return(CNULL);


	return(alias);

}




/*
 *	search alias for Name with given flag for alias type
 *	return pointer to alias on success, else NULL
 */

char
*aux_Name2alias(name, type)
	Name 			*name;
	AliasType 		type;
{
	char	*proc = "aux_Name2alias";
	register Aliases 	*aliasmember, *am;
	register AliasList 	*aa;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if(!name) return (CNULL);

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return (CNULL);  /* no alias names read */

	aa = aliaslist;
	while (aa) {
        	if (strcmp(aa->dname, name) == 0) {
	        	aliasmember = aa->a;
        		if(aliasmember) {
				if(type == ANYALIAS) {
					return(aux_cpy_String(aliasmember->aname)); /* return first alias entry */
				}
				while (aliasmember) {
					switch(type) {
						case RFCMAIL:
							if(strchr(aliasmember->aname, '@')) {
								return(aux_cpy_String(aliasmember->aname));
							}
							break; 
						case X400MAIL:
							if(strchr(aliasmember->aname, '=')) {
								return(aux_cpy_String(aliasmember->aname));
							}
							break; 
						case LOCALNAME:
							if(strchr(aliasmember->aname, '=')) break;
							if(strchr(aliasmember->aname, '@')) break;
							else {
								return(aux_cpy_String(aliasmember->aname));
							}
							break;
					}
					aliasmember = aliasmember->next;
				}
			}		
			else goto noalias;
		}
		aa = aa->next;
	}
noalias:
	return (CNULL);
}




/* 
 *	like aux_DName2alias(), but only for a given dname and alias file
 */

char
*aux_DName2aliasf(dname, type, afile)
	DName 			*dname;
	AliasType 		type;
	AliasFile		afile;
{
	char			*proc = "aux_DName2aliasf";
	Name 			*name;
	char 			*alias;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if(!dname) return (CNULL);

	name = aux_DName2Name(dname);
	if(!name) return (CNULL);

	alias = aux_Name2aliasf(name, type, afile);

	if (name) free(name);
	
	if (!alias) return(CNULL);


	return(alias);

}




/* 
 *	like aux_Name2alias(), but only for a given name and alias file
 */

char
*aux_Name2aliasf(name, type, afile)
	char			*name;
	AliasType 		type;
	AliasFile		afile;
{
	char			*proc = "aux_Name2aliasf";
	register Aliases 	*aliasmember;
	register AliasList 	*aa;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif
	if(!name) return (CNULL);

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return (CNULL);  /* no alias names read */


	aa = aliaslist;
	while (aa) {
        	if (strcmp(aa->dname, name) == 0) {

			aliasmember = aa->a;
			if(aliasmember) {
		
				while (aliasmember) {
					if (aliasmember->aliasfile == afile) switch(type) {
		
						case ANYALIAS:		 /* next best: return first alias entry from aliasfile*/
		
							return(aux_cpy_String(aliasmember->aname));
							break;
		
						case RFCMAIL:
		
							if(strchr(aliasmember->aname, '@')) return(aux_cpy_String(aliasmember->aname));
							break; 
		
						case X400MAIL:
		
							if(strchr(aliasmember->aname, '=')) return(aux_cpy_String(aliasmember->aname));
							break; 
		
						case LOCALNAME:
		
							if(strchr(aliasmember->aname, '=')) break;
							if(strchr(aliasmember->aname, '@')) break;
							else return(aux_cpy_String(aliasmember->aname));
							break;
		
					}
					aliasmember = aliasmember->next;
				}
			}		
			else goto noalias;
		}
		aa = aa->next;
	}

noalias:
	return (CNULL);

}




/*
 *	add reduced alias to Name's entry with given flags for USER/SYSTEM-file, chaining priority, and immediate file writing
 *	aliases must be unique for each USER-/SYSTEM-file combination
 *	if prior is TRUE, alias is chained in as first entry (hi priority), else as last entry
 *	new DNames are inserted in alphabetical order
 *	return 0 on success, else -1
 */

RC
aux_add_alias_name(alias, name, aliasf, prior, writef)
	char    *alias;
        Name    *name;
	AliasFile aliasf;
	Boolean prior;
	Boolean writef;
{
        DName   *dn;
	char	*proc = "aux_add_alias_name";
	int	ret;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	dn = aux_Name2DName(name);
	ret = aux_add_alias(alias, dn, aliasf, prior, writef);
	aux_free_DName(&dn);
	return(ret);
}


/*
 *	like aux_add_alias_name(), for DNames
 */

RC
aux_add_alias(alias, dn, aliasf, prior, writef)
	char    *alias;
	DName   *dn;
	AliasFile aliasf;
	Boolean prior;
	Boolean	writef;
{
	register Aliases *aliasmember, *new_am;
	register AliasList *new_aa, *aa, *bb;
	Name    *n;
	char	*ralias;
	char	*proc = "aux_add_alias";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif


	if (! (ralias = aux_cpy_ReducedString(alias)) ) return(0);


	if (!aliaslist) aliaslist = get_AliasList();

	/*
         *  Try to find alias in aliaslist->aname. If found, return -1, else insert alias and return 0
	 *	prior: if TRUE, alias will be chained as first entry
	 *	       if FALSE, alias will be chained as last entry
         */
	if(!dn) return(-1);
	n = aux_DName2Name(dn);

	aa = aliaslist;
	while (aa) {
		if(strcmp(aa->dname, n) == 0)  {		/* dname already exists with at least one alias */
			aliasmember = aa->a;
			while (aliasmember)  {
				if (aux_alias(ralias))  {		/* already there ? */
					if (ralias) free(ralias);
					return(0);
				}

				if(!aliasmember->next)  { 		/* chain in new member */

					new_am = (Aliases *)malloc(sizeof(Aliases));
					if(!new_am) goto malloc_err;
					new_am->aname = (char *)malloc(strlen(ralias) + 1); 
					if(!new_am->aname) goto malloc_err;

					if (prior)  {			/* chain in as first alias */
						new_am->next = aa->a;
						aa->a = new_am;
					} else  {			/* chain in as last alias */
						aliasmember->next = new_am;
						new_am->next = (Aliases *)0;
					}
						
					strcpy(new_am->aname, ralias);
					new_am->aliasfile = aliasf;

					if (ralias) free(ralias);
					if (writef) aux_put_AliasList(aliasf);

					return(0);
				}
				aliasmember = aliasmember->next;
			}
		}
		aa = aa->next;
	}


	/* else: new dname entry */

 	new_aa = (AliasList *)malloc(sizeof(AliasList));
 	if(!new_aa) goto malloc_err;
 	new_aa->a = (Aliases *)malloc(sizeof(Aliases)); 
 	if(!new_aa->a) goto malloc_err;
	aliasmember = new_aa->a;
  	aliasmember->aname = (char *)malloc(strlen(ralias) + 1); 
 	if(!aliasmember->aname) goto malloc_err;
  	strcpy(aliasmember->aname, ralias);
  	aliasmember->aliasfile = aliasf;
  	aliasmember->next = (Aliases *) 0;
 	new_aa->dname = (char *)malloc(strlen(n) + 1);
 	if(!new_aa->dname) goto malloc_err;
 	strcpy(new_aa->dname, n);

	aa = aliaslist;
	while (aa && strcmp(aa->dname, n) < 0)  {
		bb = aa; 
		aa = aa->next;
	}
	if(aa == aliaslist)  {
		new_aa->next = aliaslist;
		aliaslist = new_aa;
	} else  {
		new_aa->next = bb->next;
		bb->next = new_aa;
	} 
  
  	if (ralias) free(ralias);
  	if (writef) aux_put_AliasList(aliasf);
  
  	return(0);

malloc_err:
	aux_add_error(EMALLOC, "", CNULL, 0, proc);
	return(-1);


}



/*
 *	delete alias with given flags for USER/SYSTEM-file and immediate file writing
 *	return 0 on success, else -1
 */

RC
aux_delete_alias(alias, aliasf, writef)
	char    *alias;
	AliasFile aliasf;
	Boolean writef;
{
	register Aliases *aliasmember, *aliasmemberpre;
	register AliasList *aa, *aapre;
	char	*proc = "aux_delete_alias";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(0);  /* no alias names read */

	/*
         *  Try to find alias in aliaslist->aname fitting to given alias file. 
	 *  If found, chain out. Chain out dname entry, too, if last alias is deleted
         */

	aa = aliaslist;
	aapre = (AliasList * ) 0;
	while (aa)  {
		aliasmember = aa->a;
		aliasmemberpre = (Aliases * ) 0;
		while (aliasmember)  {

			if (!strcmp(aliasmember->aname, alias) && (aliasmember->aliasfile == aliasf))  {
  				if(aliasmemberpre) aliasmemberpre->next = aliasmember->next;
  				else if (aliasmember->next) aa->a = aliasmember->next;
  				else  {
 					if(aapre) aapre->next = aa->next;
 					else aliaslist = aa->next;
  
 					free(aa->dname);
 					free(aa);
  				}
  
  				free(aliasmember->aname);
				free(aliasmember);

				if (writef) aux_put_AliasList(aliasf);

				return(0);

			}					
			aliasmemberpre = aliasmember;
			aliasmember = aliasmember->next;
		}
		aapre = aa;
		aa = aa->next;
	}


	return(-1);
}



/*
 *  Print contents of AliasList 
 */

RC
aux_fprint_AliasList(ff, aliaslist)
FILE * ff;
AliasList * aliaslist;
{
	register Aliases   * aliasmember, * am;
	register AliasList * aa;
	char	           * proc = "aux_fprint_AliasList";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!aliaslist) 
		return(0); 

	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
                        fprintf(ff, "%s --> <%s>\n", aliasmember->aname, aa->dname);
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	return(0);
}



/*
 *	search DName to which alias belongs and print to file
 *	if alias is NULL, print complete list to file
 *	return always 0
 */

RC
aux_fprint_alias2dname(ff, alias)
	FILE *ff;
	char *alias;
{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char	*proc = "aux_fprint_alias2dname";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(0);  /* no alias names read */

	/*
         *  Try to find alias in aliaslist->aname. If found, return aliaslist->dname, else return alias
         */

	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
			if (!alias || strmtch(aliasmember->aname, alias)) {
                                fprintf(ff, "%s --> <%s>\n", aliasmember->aname, aa->dname);
                        }
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	return(0);
}



/*
 *	print all aliases which belong to DName to given file
 *	if DName is NULL, print complete list to file
 *	return always 0
 */

RC
aux_fprint_dname2alias(ff, dname)
	FILE *ff;
	char *dname;
{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char	*proc = "aux_fprint_dname2alias";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(0);  /* no alias names read */

	/*
         *  Try to find alias in aliaslist->aname. If found, return aliaslist->dname, else return alias
         */

	aa = aliaslist;
	while (aa) {
        	if (!dname || strmtch(aa->dname, dname)) {
	        	aliasmember = aa->a;
        		while (aliasmember) {
                                fprintf(ff, "<%s> --> %s\n", aa->dname, aliasmember->aname);
        			aliasmember = aliasmember->next;
                        }
		}
		aa = aa->next;
	}

	return(0);
}



/*
 *	find pattern in any text element of all alias list entries beginning at entry after name
 *	if end of alias list is reached, continue at top until last found entry is reached
 *	comparisons are non-case-sensitive
 *	return pointer to name on success, else NULL
 *	NOTICE: uses aux_next_AliasList(), same name parameter behaviour
 */

Name
*aux_search_AliasList(name, pattern)
	Name			*name;
	char			*pattern;
{
	char			*proc = "aux_search_AliasList";
	AliasList		*aa, *last_aa;
	register Aliases 	*aliasmember;
	register char		*s, *p, *last_name;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);

	if (! (p = aux_cpy_ReducedString(pattern)) ) return(CNULL);
	p = str_up(p);

	last_name = aux_next_AliasList(name);	/* init */
	if (!last_name) return(CNULL);

	last_aa = last_aliaslist;		/* point of entrance */
	do  {
		aa = last_aliaslist;
		if (! (s = aux_cpy_String(aa->dname)) ) return(CNULL);
		s = str_up(s);
		if (strstr(s, p))  {
			if (p) free(p);
			if (s) free(s);
			return(last_name);
		}
		if (s) free(s);
                aliasmember = aa->a;
                while (aliasmember)  {
			if (! (s = aux_cpy_String(aliasmember->aname)) ) return(CNULL);
			s = str_up(s);
			if (strstr(s, p))  {
				if (p) free(p);
				if (s) free(s);
				return(last_name);
			}
			if (s) free(s);
			aliasmember = aliasmember->next;

		}
		if (last_name) free(last_name);
		last_name = aux_next_AliasList("");

	} while (last_aa != last_aliaslist);

	if (p) free(p);
	if (last_name) free(last_name);

	return(CNULL);

}


/*
 *	return TRUE if DName has alias in given alias file, else FALSE
 */

Boolean
aux_alias_chkfile(name, aliasf)
	Name			*name;
	AliasFile		aliasf;
{
	char			*proc = "aux_alias_chkfile";
	register AliasList	*aa;
	register Aliases 	*aliasmember;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!name) return(FALSE);
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(FALSE);

	aa = aliaslist;
	while (aa)  {
		if (!strcmp(aa->dname, name))  {
			aliasmember = aa->a;
			while (aliasmember) {
				if (aliasmember->aliasfile == aliasf) return(TRUE);		
				aliasmember = aliasmember->next;
			}
		}
		aa = aa->next;
	}
	return(FALSE);
}


/*
 *	get next name in AliasList after given name; if end of list is reached, return NULL
 *	if name is empty (""), get name after last found entry, begin with top entry at first time / if end of list is reached
 *	if name is NULL, reset and get name of top entry
 *	return pointer to allocated string on success, else NULL
 *	local pointer last_aliaslist is set
 *	NOTICE: called by aux_find_AliasList()
 */

Name
*aux_next_AliasList(name)
	Name			*name;
{
	char			*proc = "aux_next_AliasList";


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);
	if (name)  {
		if (strcmp(name, ""))  {				/* search for name */
			last_aliaslist = aliaslist;
			while (last_aliaslist)  {
				if (!strcmp(last_aliaslist->dname, name)) break;
				last_aliaslist = last_aliaslist->next;
			}
			if (!last_aliaslist) return(CNULL); 		/* name not found */
		} else if (last_aliaslist) last_aliaslist = last_aliaslist->next;
	} else  last_aliaslist = (AliasList *) 0;

	if (!last_aliaslist) last_aliaslist = aliaslist;

	return(aux_cpy_String(last_aliaslist->dname));
}



/*
 *	get name in AliasList after last found entry
 *	alias list is always passed through continual from top to end
 *	first entry's name is returned at first call, after end is reached, and when reset is TRUE
 *	if end of list is reached, return NULL, reset to top for next call
 *	independant of aux_find_AliasList() and aux_next_AliasList()
 */

Name
*aux_alias_nxtname(reset)
	Boolean			reset;
{
	char			*proc = "aux_alias_nxtname";
	
	static AliasList	*la = (AliasList *) 0;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!aliaslist)  {
		aliaslist = get_AliasList();
		la = (AliasList *) 0;
	}
	if (!aliaslist) return(CNULL);
	if (!la || reset) la = aliaslist;
	else la = la->next;

	if (!la)  {
		la = (AliasList *) 0;
		return(CNULL);
	} else return(aux_cpy_String(la->dname));
}


/*
 *	get all aliases of name's entry
 *	return NULL-terminated string including all aliases separated by ':'
 */

char
*aux_alias_getall(name)
	char			*name;
{
	char			*proc = "aux_alias_getall";
	AliasList		*aa;
	register Aliases	*aliasmember;
	char			*alias_string;
	

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);

	aa = aliaslist;
	while (aa)  {
		if (!strcmp(aa->dname, name))  {
			if (! (alias_string = (char *)malloc(1)) ) goto malloc_err;
			*alias_string = '\0';
			aliasmember = aa->a;
			while (aliasmember)  {
				if (strcmp(alias_string, "")) strcat(alias_string, ":");
				if (! (alias_string = (char *)realloc(alias_string,
					strlen(alias_string) + strlen(aliasmember->aname) + 2)) ) goto malloc_err;
				strcat(alias_string, aliasmember->aname);
				aliasmember = aliasmember->next;
			}
			return(alias_string);
		}
		aa = aa->next;
	}

	return(CNULL);

malloc_err:
	aux_add_error(EMALLOC, "", CNULL, 0, proc);
	return(CNULL);

}



/*
 *	read alias files (via get_AliasList())
 *	return TRUE if OK, else FALSE
 */

Boolean
aux_get_AliasList()
{
	char	*proc = "aux_get_AliasList";


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (aliaslist) free_AliasList();
	aliaslist = get_AliasList();
	if (aliaslist) return(TRUE);
	else return(FALSE);

}

void
aux_free_AliasList(alist)
AliasList **alist;
{

	register Aliases *aliasmember, *am;
	register AliasList *aa, *bb;
	char	*proc = "aux_free_AliasList";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif
        
        /*
         *  free alist
         */

        if(!alist || ! *alist) return;
        aa = *alist;
        while (aa) {
                aliasmember = aa->a;
                while (aliasmember) {
                        free(aliasmember->aname);
                        am = aliasmember->next;
                        free(aliasmember);
                        aliasmember = am;
                }
                free(aa->dname);
                bb = aa->next;
                free(aa);
                aa = bb;
        }
	free(*alist);
	*alist = (AliasList *) 0;
}




/*
 *	read alias list from USER- and SYSTEM-aliasfile
 *	DNames are sorted in alphabetical order, aliases are inserted from left-to-right in a FIFO-list
 *	USER-aliases are inserted prior to SYSTEM-aliases (affects transforming routines aux_this2that())
 *	reset last_aliaslist to NULL (used by aux_find_AliasList(), aux_alias_next())
 *	return pointer to first entry
 */

static
AliasList
*get_AliasList()
{
	AliasList   		* alist = (AliasList *)0;
	AliasList		* alist_from_pse = (AliasList *)0;
	register AliasList 	* aa, * bb, * bb_prev;
	char	      		  afile[128], * adir[2];
	FILE        		* aff;
	int	      		  dir;
	AliasFile     		  aliasf;
	OctetString 		* asn1_aliaslist;

	char	    		* proc = "get_AliasList";

	/*
         *  Read ( PSE-object AliasList or $HOME/.af-alias ) and secude/.af-alias
         *  into alist
         *
         */

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

#ifndef MAC
        if(!(adir[0] = getenv("HOME"))) adir[0] = "";
#else
        if(!(adir[0] = MacGetEnv("HOME"))) adir[0] = "";
#endif /* MAC */

	adir[1] = ALIASDIR;

	for (dir = 1; dir >= 0; dir--) {

		/* list insert: user's aliases will be taken prior to system's */
		if(dir == 0) 
			aliasf = useralias;
		else 
			aliasf = systemalias;
		strcpy(afile, adir[dir]);
#ifndef MAC
                if(afile[strlen(afile)-1] != '/') strcat(afile, "/");
#else
                if(afile[strlen(afile)-1] != ':') strcat(afile, ":");
#endif /* MAC */
        	strcat(afile, ALIASFILE);


		/* Try to read user aliasfile from PSE */
		if (aliasf == useralias) {
			alist_from_pse = af_pse_get_AliasList();
			if (alist_from_pse) {
				useralias_from_PSE = TRUE;
				if (! alist)
					alist = alist_from_pse;
				else {
					bb_prev = alist;
					bb = alist->next;
					while (bb) {
						bb_prev = bb;
						bb = bb->next;
					}
					bb_prev->next = alist_from_pse;
				}
				/* Do NOT consider $HOME/.af-alias */
				continue;
			}
			else {
				useralias_from_PSE = FALSE;
				aux_free_error();
			}
		}
			
		if ((aff = fopen(afile, "r"))) {

			if (accept_alias_without_verification == TRUE)
				asn1_aliaslist = aux_file2OctetString(afile);
			else {
				asn1_aliaslist = af_SignedFile2OctetString(afile);
				aux_free_VerificationResult(&verifresult);
			}

			if (! asn1_aliaslist) {
				aux_add_error(aux_last_error(), "af_SignedFile2OctetString failed", CNULL, 0, proc);
				fclose(aff);
				continue;
			}
	
			aa = d_AliasList(asn1_aliaslist);
			if (! aa) {
				aux_add_error(EDECODE, "d_AliasList failed", CNULL, 0, proc);
				return ((AliasList *)0);
			}

			if (! alist)
				alist = aa;
			else {
				bb_prev = alist;
				bb = alist->next;
				while (bb) {
					bb_prev = bb;
					bb = bb->next;
				}
				bb_prev->next = aa;
			}

			fclose(aff);
		}
	}

	last_aliaslist = (AliasList *) 0;

	return(alist);

malloc_err:
	aux_add_error(EMALLOC, "", CNULL, 0, proc);
	last_aliaslist = (AliasList *) 0;
	return ((AliasList *)0);
}




/*
 *	write all fitting alias list entries to USER/SYSTEM-aliasfile
 */

void
aux_put_AliasList(aliasf)
AliasFile aliasf;
{
	OctetString 	   * asn1_aliaslist;
	char 	 	     afile[128], * adir, aline[512];
	FILE 		   * aff;
	AlgId 		   * signAI;
	int		     rc;

	char		   * proc = "aux_put_AliasList";


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif
		
        if(! aliaslist) return;

	if(aliasf == useralias) {

#ifndef MAC
        	if(!(adir = getenv("HOME"))) adir = "";
#else
        	if(!(adir = MacGetEnv("HOME"))) adir = "";
#endif /* MAC */
	}
	else adir = ALIASDIR;

	strcpy(afile, adir);
#ifndef MAC
        if(afile[strlen(afile)-1] != '/') strcat(afile, "/");
#else
        if(afile[strlen(afile)-1] != ':') strcat(afile, ":");
#endif /* MAC */
       	strcat(afile, ALIASFILE);

	if (aliasf == useralias && useralias_from_PSE == TRUE) {
		if (af_pse_update_AliasList (aliaslist) < 0)
			aux_add_error(EWRITEPSE, "af_pse_update_AliasList failed", CNULL, 0, proc);
		return;
	}

	asn1_aliaslist = e_AliasList(aliaslist, aliasf);
	if (! asn1_aliaslist) {
		aux_add_error(EENCODE, "e_AliasList failed", CNULL, 0, proc);
		return;
	} 

	if (aliasf == useralias)
		rc = af_OctetString2SignedFile(afile, asn1_aliaslist, FALSE, NULLALGID);
	else
		rc = af_OctetString2SignedFile(afile, asn1_aliaslist, TRUE, NULLALGID);
	if (rc < 0) {
		aux_add_error(aux_last_error(), "af_OctetString2SignedFile failed", CNULL, 0, proc);
		return;
	}
	
	return;
}
	 


/*
 *	check alias list for consistency (double aliases as a result of alias file editing)
 */

Boolean
aux_check_AliasList(ff)
	FILE			*ff;
{
	char			*proc = "aux_check_AliasList";
	register Aliases	*aliasmember, *am;
	register AliasList 	*aa, *bb;
	Boolean			ret = TRUE;
	Boolean			found_first = FALSE;
	Boolean			found;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif
        
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist)  {

		fprintf(stderr, "aux_check_AliasList: Can't read alias files\n");
		return(FALSE);
	}
		
	aa = aliaslist;
	while (aa)  {
		aliasmember = aa->a;
		while (aliasmember)  {
			found = FALSE;
			bb = aliaslist;
			while (bb)  {
				if (strcmp(aa->dname, bb->dname))  {	/* ignore myself */
					am = bb->a;
					while (am)  {
						if (!strcmp(am->aname, aliasmember->aname))  {
							if (!found_first)  {
								fprintf(ff, "aux_check_AliasList: double alias found\n");
								fprintf(ff, " File   <Alias> = DName\n");
								found_first = TRUE;
							}
							fprintf(ff, "%s <%s> = %s\n",
								aliasmember->aliasfile == useralias ? " USER " : "SYSTEM",
								aliasmember->aname, aa->dname);
							ret = FALSE;
							found = TRUE;
							break;
						}
						am = am->next;
					}
				}
				if (found) break;

				bb = bb->next;
			}
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}


	return(ret);

}











/*
 *	free local alias list entries, set pointer of first entry to NULL
 */

void
free_AliasList()
{

	register Aliases *aliasmember, *am;
	register AliasList *aa, *bb;
	char	*proc = "free_AliasList";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif
        
        /*
         *  free alist
         */

        if(!aliaslist) return;
        aa = aliaslist;
        while (aa) {
                aliasmember = aa->a;
                while (aliasmember) {
                        free(aliasmember->aname);
                        am = aliasmember->next;
                        free(aliasmember);
                        aliasmember = am;
                }
                free(aa->dname);
                bb = aa->next;
                free(aa);
                aa = bb;
        }
	aliaslist = (AliasList *) 0;
}





/*
 *	search substring b in string a
 *	return pointer to character in a after first substring b found in a, else NULL
 */

static
char *strmtch(a, b)
	char *a, *b;
{
	char	*proc = "strmtch";
	register char *aa, *bb;


#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	while (*a) {
		aa = a;
		bb = b;
		while (*aa) {
			if(*aa != *bb) break;
                        bb++;
			if(*bb == '\0') return(aa + 1);
                        aa++;
		}
		a++;   
	}
	return (CNULL);
}











