#ifndef BITSETH
#define BITSETH
/*  t. lord	Mon May 11 00:03:42 1992	*/
/*	Copyright (C) 1992 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include "basics.h"


#ifndef UT_subset
#define UT_subset 	unsigned int
#define UT_subset_bits	(32)
#define UT_subset_mask	(0x1f)
#endif

typedef UT_subset * ut_Bitset;

extern int ut_bitset_equal P_((int size, ut_Bitset, ut_Bitset));
extern int ut_bitset_is_subset P_((int size, ut_Bitset, ut_Bitset));
extern int ut_bitset_empty P_((int size, ut_Bitset));
extern void ut_bitset_assign P_((int size, ut_Bitset, ut_Bitset));
extern void ut_bitset_null P_((int size, ut_Bitset));
extern void ut_bitset_universe P_((int, ut_Bitset));
extern void ut_bitset_complement P_((int, ut_Bitset));
extern void ut_bitset_union P_((int, ut_Bitset, ut_Bitset));
extern void ut_bitset_intersection P_((int, ut_Bitset, ut_Bitset));
extern void ut_bitset_difference P_((int, ut_Bitset, ut_Bitset));
extern void ut_bitset_revdifference P_((int, ut_Bitset, ut_Bitset));
extern void ut_bitset_xor P_((int, ut_Bitset, ut_Bitset));
extern unsigned long ut_bitset_hash P_((int, ut_Bitset));
extern UT_subset ut_subset_singletons[UT_subset_bits];

#define ut_bitset_subset(N)  ((N) / UT_subset_bits)
#define ut_bitset_subset_val(B,N)  ((B)[ut_bitset_subset(N)])

#define UT_bitset_access(B,N,OP) \
  ((B)[ut_bitset_subset(N)] OP ut_subset_singletons[(N) & UT_subset_mask])

#define UT_bitset_member(B,N)   UT_bitset_access(B, N, &)
#define UT_bitset_enjoin(B,N)   UT_bitset_access(B, N, |=)
#define UT_bitset_remove(B,N)   UT_bitset_access(B, N, &= ~)
#define UT_bitset_toggle(B,N)   UT_bitset_access(B, N, ^= )
#define ut_bitset_numb_subsets(N) (((N) + UT_subset_bits - 1) / UT_subset_bits)
#define ut_sizeof_bitset(N)	(ut_bitset_numb_subsets(N) * sizeof(UT_subset))


#endif

