.\" @(#)nlc.mm	1.5 07 Apr 1994 23:54:23
.\"
.\" To format:
.\"	groff -p -t -e -mm -Tps filename > /var/tmp/foo; ghostview /var/tmp/foo
.\"
.\" ***************
.\"
.\" document setup
.\"
.\" equations ate delimited by %'s
.EQ
delim %%
.EN
.\" right side justification
.SA 1
.\" hyphenation, right margin justification,
.\" text indent, left label justification
.FD 1
.\" begin the title and affiliation
.\" title continues until the next command so there can be no comment
.\" within or after the title
.\" Document date
.ND "95/05/13"
.TL
Noll Lightning Cypher
.AF "chongo@toad.com"
.AU "Landon Curt Noll" chongo
.\" start cover sheet abstract
.AS 0
.ce
Draft: \*(DT
.SP
As need to communicate and store sensitive digital information
increases, so does the need to protect it from unwanted disclosure.
Block cyphers are often used to protect data because good ones are
both fast and resistant to attack.
Public-key cryptography has not diminished the need for block cyphers.
Hybrid systems where public-key is used to exchange block cypher keys
provides draws on the strengths of both disciplines.
.SP
The Noll Lightning Algorithm (NLA) shows how one may implement a
block chaining cypher given given a one-way hash transformation function.
This paper outlines the NLA.
The Noll Lightning Cypher (NLC) is presented as an example
implementation of the NLA.
The NLC is a high speed block cypher that currently appears to
be resilient to a number forms of cryptographic attack.
.SP
Both the NLA and the NLC have been placed into the public domain
in order to maximize their availability.
.\" end abstract
.AE
.\" external paper document type
.MT 4
.\" skip page
.SK
.\"
.\" ***************
.\"
.\" The main paper
.\"
.H 1 Introduction
XXX - This is the introduction.
.H 1 "Noll Lightning Algorithm"
XXX - This will talk about thr NLA.
.H 2 "The big picture"
XXX - Here is where the NLA will be shown in pic form.
.\" display start for a centered block
.DS CB
.PS
dx = 0.63;
dy = 0.53;
textht = dy;
textwid = dx;
moveht = dy;
movewid = dx;
boxht = 1.15*dy/2;
boxwid = 1.45*dx/2;
drad = 0.05
tmp = 0;

define pos X
    tmpx = $1;
    tmpy = $2;
    if (tmpx >= 7) then {
	tmpx = tmpx + 0.5;
    }
    if (tmpx >= 3) then {
	tmpx = tmpx + 0.5;
    }
    if (tmpy >= 2) then {
	tmpy = tmpy + 0.5;
    }
    move to (tmpx*dx, tmpy*dy)
X

pos(1,5)
P15: box invis "% space 0 {m sub i}%"

pos(2,4)
P24: box "\fRHash\fP"
arrow from P15.e right (dx - boxwid/2) then to P24.n

pos(0,4)
P04: box invis " % space 0 {y sub i}%" ljust

pos(1,1.85)
box invis "  % space 0 {p sub i}%" ljust

pos(1,4)
P14: box invis
arc from P14-(drad,0) to P14+(drad,0) with .c at P14 cw
line from P04.e to last arc.start
arrow from last arc.end to P24.w

pos(0.1575,3)
P03: box invis
line from P04.s+(.1,0) to P03.c

pos(2.75,3)
P23: box "\fRXor\fP"

pos(1,3)
P13: box invis
arc from P13-(drad,0) to P13+(drad,0) with .c at P13 cw
line from P03.c to last arc.start
arrow from last arc.end to P23.w

pos(0,2)
P02: box invis " % space 0 {a sub i}%" ljust

pos(1,2)
P12: box "\fRPerm\fP"
arrow from P02.e to P12.w
arrow from P15.s to P12.n

pos(0,1)
P01: box invis " % space 0 {b sub i}%" ljust

pos(1,1)
P11: box "\fRXor\fP"
arrow from P01.e to P11.w
arrow from P12.s to P11.n

pos(1,0)
P10: box invis "% space 0 {c sub i}%"
arrow from P11.s to P10.n

pos(3,3)
P33: box invis "   % space 0 {z sub i+1}%" ljust
line from P23.e to P33.c

pos(3,2)
P32: box "\fRExpand\fP"
arrow from P33.end to P32.n

pos(3,1)
P31: box invis
line from P32.s to P31.c

pos(3,4)
P34: box "\fRAdd\fP"
arrow from P24.e to P34.w "% space 0 {h sub i}%" " " " "
arrow from 1/2 <last arrow.start, last arrow.end> to P23.n
arrow from P33.end to P34.s

pos(4,4)
P44: box invis "% space 0 {y sub i+1}%"
arrow from P34.e to P44.w+(0.05,0)

pos(4,3)
P43: box invis
line from P44.s to P43.c

pos(4,2)
P42: box invis "% space 0 {a sub i+1}%"
arrow from P32.e to P42.w+(0.05,0)

pos(4,1)
P41: box invis "% space 0 {b sub i+1}%"
arrow from P31.c to P41.w+(0.05,0)

pos(5,5)
P55: box invis "% space 0 {m sub i+1}%"

pos(6,4)
P64: box "\fRHash\fP"
arrow from P55.e right (dx - boxwid/2) then to P64.n

pos(5,1.85)
box invis "  % space 0 {p sub i+1}%" ljust

pos(5,4)
P54: box invis
arc from P54-(drad,0) to P54+(drad,0) with .c at P54 cw
line from P44.e-(0.05,0) to last arc.start
arrow from last arc.end to P64.w

pos(6.75,3)
P63: box "\fRXor\fP"

pos(5,3)
P53: box invis
arc from P53-(drad,0) to P53+(drad,0) with .c at P53 cw
line from P43.c to last arc.start
arrow from last arc.end to P63.w

pos(5,2)
P52: box "\fRPerm\fP"
arrow from P42.e-(0.05,0) to P52.w
arrow from P55.s to P52.n

pos(5,1)
P51: box "\fRXor\fP"
arrow from P41.e-(0.05,0) to P51.w
arrow from P52.s to P51.n

pos(5,0)
P50: box invis "% space 0 {c sub i+1}%"
arrow from P51.s to P50.n

pos(7,3)
P73: box invis "   % space 0 {z sub i+2}%" ljust
line from P63.e to P73.c

pos(7,2)
P72: box "\fRExpand\fP"
arrow from P73.c to P72.n

pos(7,1)
P71: box invis
line from P72.s to P71.c

pos(7,4)
P74: box "\fRAdd\fP"
arrow from P64.e to P74.w "% space 0 {h sub i+1}%" " " " "
arrow from 1/2 <last arrow.start, last arrow.end> to P63.n
arrow from P73.c to P74.s

pos(8,4)
P84: box wid dx invis "% space 0 {y sub i+2}%" rjust
arrow from P74.e to P84.w

pos(8,2)
P82: box wid dx invis "% space 0 {a sub i+2}%" rjust
arrow from P72.e to P82.w

pos(8,1)
P81: box wid dx invis "% space 0 {b sub i+2}%" rjust
arrow from P71.c to P81.w

# end of pic object
.PE
.DE
.H 1 "Noll Lightning Cypher"
XXX - This will discuss a specific NLA implementation known as NLC.
.H 1 Conclusions
XXX - This is the conclusion.
.H 1 Acknowledgment
XXX - This is the Acknowledgment.
.\"
.\" ***************
.\"
.\" The paper trailer
.\"
.\" skip page
.SK
.\" reference page
.H 1 References
.\" variable mark list with indentation
.VL 5
.\" list item
.LI
B. Schneier
\fIApplied Cryptography\fP, John Wiley & Sons, Inc., New York, NY.
.\" end of list
.LE
