; --------------------------------------------------------------------------
; This code written by Colin Plumb

; polynomial x^32+x^17+x^3+x^2+1, suggested for v0.3.6

tap1    equ     2
tap2    equ     3
tap3    equ     17
tap4    equ     32      ; Must equal pool size (and be a power of 2)

;given a suitable polynomial (like x^32+x^19+x^6+x^2+1), you have a
;few taps:

;tap1    equ     2      ; from v0.3.5
;tap2    equ     6
;tap3    equ     19
;tap4    equ     32

	mov	bx, index
	add	bx, (tap4-tap3)*2 + 2
	and	bx, (tap4-1)*2
	xor	ax, WORD PTR pool[bx]
	add	bx, (tap3-tap2)*2
	and	bx, (tap4-1)*2
	xor	ax, WORD PTR pool[bx]
	add	bx, (tap2-tap1)*2
	and	bx, (tap4-1)*2
	xor	ax, WORD PTR pool[bx]
	add	bx, tap1*2
	and	bx, (tap4-1)*2
	xor	ax, WORD PTR pool[bx]
	rol	ax, 7
        mov     index, bx

;;        mov     WORD PTR pool[bx], ax

; -------------------------------------------------------------------------
; If you prefer the method used in v0.3.4 of the driver, change the
; taps above to 2, 15, 25 and 32 respectively.

; The accumulate function here is based on the irreducible polynomail
; x^32 + x^25 + x^15 x^2 + 1

; In pseudo-C code, for each new sampled word x,
;   x ^= pool[i] ^ pool[i-2 & 31] ^ pool[i-15 & 31] ^ pool[i-25 & 31]
;   rotate x left 7 bits
;   pool[i] = x
;   i = i+1 & 31;

;tap1    equ     2
;tap2    equ     15
;tap3    equ     25
;tap4    equ     32


