/****************************************************************************/
/* C.CMD -  V4.00   COMMAND FILE FOR LINKING C50 C PROGRAMS                 */
/*                                                                          */
/*    Usage:       dsplnk<obj files...>  -o <out file> -m <map file> c.cmd  */
/*                                                                          */
/*    Description: This file is a sample command file that can be used      */
/*                 for linking programs built with the TMS320C50 C          */
/*                 Compiler.   Use it a guideline; you may want to change   */
/*                 the allocation scheme according to the size of your      */
/*                 program and the memory layout of your target system.     */
/*                                                                          */
/*    Notes: (1)   You must specify the directory in which rts.lib is       */
/*                 located.  Either add a "-i<directory>" line to this      */
/*                 file, or use the system environment variable C_DIR to    */
/*                 specify a search path for libraries.                     */
/*                                                                          */
/*           (2)   When using the small (default) memory model, be sure     */
/*                 that the ENTIRE .bss section fits within a single page.  */
/*                 To satisfy this, .bss must be smaller than 128 words and */
/*                 must not cross any 128 boundaries.                       */
/****************************************************************************/

/* TMS320C50 memory map                                        */
/*                                                             */

/* The following ranges have been modified to run on the DSP Starter Kit
and DO NOT represent typical ranges for other hardware arrangements. */

MEMORY
{
    PAGE 0 : VECTORS:	origin = 00808h, length =  00006h
              IRAM_P:	origin = 00A00h, length =  00200h
	     IRAM_P1:	origin = 00C00h, length =  00400h
	  /* IRAM_P2:	origin = 01000h, length =  01C00h */
	     IRAM_P2:	origin = 01000h, length =  00800h

    PAGE 1 :
    /*
                REGS:	origin = 00000h, length =  00050h
		 I_O:	origin = 00050h, length =  00010h
	       RAMB2:	origin = 00060h, length =  00020h
	     RAMB0_D:	origin = 00100h, length =  00200h
	       RAMB1:	origin = 00300h, length =  00200h
    */
              IRAM_D:	origin = 00A00h, length =  00200h
	     IRAM_D1:	origin = 00C00h, length =  00400h
	     IRAM_D2:	origin = 01800h, length =  01400h
    /*
	     IRAM_D2:	origin = 01000h, length =  01C00h
			end of internal ram is 2BFF
	    EXT_DATA:	origin = 02C00h, length =  0D4FFh
    */
}

SECTIONS
{
/************************************************
	  vectors :  { }   > VECTORS
	    .text :  { }   > IRAM_P
	    .data :  { }   > IRAM_P1
	     .bss :  { }   > IRAM_D2
************************************************/
          vectors :  { }   > VECTORS
	    .text :  { }   > IRAM_P2
	    .data :  PAGE = 1
	     .bss :  PAGE = 1
}
