#include "stdio.h"
#include "stdlib.h"
#include "string.h"

char usage_string[] =
"iterate <command> <string1> <string2> <string3> ...\n"
"\n"
"    <command> is sequentially performed on the strings.\n"
"    Wherever <command> contains a \"%%\" sequence, the string\n"
"    is substituted for the double percent sign. Then the command\n"
"    is executed by the DOS shell. This is often convenient when\n"
"    the strings are filenames.\n"
"\n"
"    Examples:\n"
"        iterate \"type %%\" alpha.txt bravo.txt charlie.txt\n"
"            executes \"type alpha.txt\"\n"
"            then executes \"type bravo.txt\"\n"
"            then executes \"type charlie.txt\"\n"
"\n"
"        iterate \"grep %% foobar.txt\" alpha bravo charlie\n"
"            executes \"grep alpha foobar.txt\"\n"
"            then executes \"grep bravo foobar.txt\"\n"
"            then executes \"grep charlie foobar.txt\"\n"
;

char command_string[100];

void main(int argc, char *argv[])
    {
    int i;
    char *p, *q, *r;

    if (argc < 2) { printf("%s", usage_string); exit(0); }
    for (i = 2; i < argc; i++)
        {
        p = argv[1];
        q = command_string;
        while (*p != '\0')
            {
            if (*p == '%' && *(p+1) == '%')
                {
                r = argv[i];
                while (*r != '\0') *q++ = *r++;
                p += 2;
                }
            else *q++ = *p++;
            }
        *q = '\0';
        printf("Iterating: %s\n", command_string);
        system(command_string);
        }
    exit(0);
    }
