typedef unsigned int uint;

#define enable_interrupts()  asm(" CLRC INTM");
#define disable_interrupts() asm(" SETC INTM");

#define DATA_AT(n)  (*((int *) (n)))

#define IMR         DATA_AT(0x04)
#define GREG        DATA_AT(0x05)
#define IFR         DATA_AT(0x06)
#define PMST        DATA_AT(0x07)
#define RPTC        DATA_AT(0x08)
#define BRCR        DATA_AT(0x09)
#define PASR        DATA_AT(0x0A)
#define PAER        DATA_AT(0x0B)
#define TREG0       DATA_AT(0x0C)
#define TREG1       DATA_AT(0x0D)
#define TREG2       DATA_AT(0x0E)
#define DBMR        DATA_AT(0x0F)

#define AR0         DATA_AT(0x10)
#define AR1         DATA_AT(0x11)
#define AR2         DATA_AT(0x12)
#define AR3         DATA_AT(0x13)
#define AR4         DATA_AT(0x14)
#define AR5         DATA_AT(0x15)
#define AR6         DATA_AT(0x16)
#define AR7         DATA_AT(0x17)
#define INDX        DATA_AT(0x18)
#define ARCR        DATA_AT(0x19)
#define CBSR1       DATA_AT(0x1A)
#define CBER1       DATA_AT(0x1B)
#define CBSR2       DATA_AT(0x1C)
#define CBER2       DATA_AT(0x1D)
#define CBCR        DATA_AT(0x1E)
#define BMAR        DATA_AT(0x1F)

#define DRR         DATA_AT(0x20)
#define DXR         DATA_AT(0x21)
#define SPC         DATA_AT(0x22)
#define TIM         DATA_AT(0x24)
#define PRD         DATA_AT(0x25)
#define TCR         DATA_AT(0x26)
#define PDWSR       DATA_AT(0x28)
#define IOWSR       DATA_AT(0x29)
#define CWSR        DATA_AT(0x2A)

#define TRCV        DATA_AT(0x30)
#define TDXR        DATA_AT(0x31)
#define TSPC        DATA_AT(0x32)
#define TCSR        DATA_AT(0x33)
#define TRTA        DATA_AT(0x34)
#define TRAD        DATA_AT(0x35)

#define PA0         DATA_AT(0x50)
#define PA1         DATA_AT(0x51)
#define PA2         DATA_AT(0x52)
#define PA3         DATA_AT(0x53)
#define PA4         DATA_AT(0x54)
#define PA5         DATA_AT(0x55)
#define PA6         DATA_AT(0x56)
#define PA7         DATA_AT(0x57)
#define PA8         DATA_AT(0x58)
#define PA9         DATA_AT(0x59)
#define PA10        DATA_AT(0x5A)
#define PA11        DATA_AT(0x5B)
#define PA12        DATA_AT(0x5C)
#define PA13        DATA_AT(0x5D)
#define PA14        DATA_AT(0x5E)
#define PA15        DATA_AT(0x5F)


