/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "secure.h"

OctetString *aux_create_PKCSBlock(BT, D)
char BT;
OctetString *D;
{

/*
 *  aux_create_PKCSBlock returns a newly created OctetString
 *  of length blocksize = (keysize - 1) / 8 (e.g blocksize 63
 *  in case of RSA keysize 512 bits) which consists of a concatenation
 *  of BT || PS || 0x00 || D. This is the encryption block formatting
 *  of PKCS#1 without the leading 0x00.
 *  PS is a padding string dependant on blocktype BT. It consists of
 *  0x00 in case of BT = 0x00, 
 *  0xff in case of BT = 0x01,
 *  non-zero pseudo random numbers in case of BT = 0x02.
 */

	OctetString	*PKCSBlock, *PS;
	int		PS_length, CT_length;
	char            *dd, *bb, *ct;
	int		blocksize, i;
	char		*proc = "aux_create_PKCSBlock";

	if(BT < 0 || BT > PKCS_BT_TD) {
		aux_add_error(EINVALID, "Wrong BT", CNULL, 0, proc);
		return ((OctetString * )0);
	}

	if(!D || !D->noctets || !D->octets) {
		aux_add_error(EINVALID, "Wrong D", CNULL, 0, proc);
		return ((OctetString * )0);
	}

	blocksize = (RSA_PARM(rsaEncryption->parm) - 1) / 8;

	PS_length = blocksize - 2 - D->noctets;

	if(PS_length < 0) {
		aux_add_error(EINVALID, "D too long", CNULL, 0, proc);
		return ((OctetString *)0);
	}

	if(!(PKCSBlock = aux_new_OctetString(blocksize))) {
		aux_add_error(EMALLOC, "PKCSBlock", CNULL, 0, proc);
		return ((OctetString * )0);
	}

	/* First BT */

	PKCSBlock->octets[0] = BT;

	switch(BT) {
		case 0:
			break;
		case 1:
			dd = PKCSBlock->octets + 1;
			while(PS_length--) *dd++ = 0xff;
			break;
		case 2:
			if(!(PS = sec_random_ostr(PS_length))) {
				aux_add_error(EMALLOC, "PS", CNULL, 0, proc);
				return ((OctetString *)0);
			}
			bb = PS->octets;
			dd = PKCSBlock->octets + 1;
			while(PS_length--) {
				if(!(*bb)) *bb = 0xff;
				*dd++ = *bb++;
			}
			break;
		case PKCS_BT_TD:
			ct = (char *)aux_current_UTCTime();
			CT_length = strlen(ct);
			PS_length = PS_length - CT_length;
			dd = PKCSBlock->octets + 1;
			while(CT_length--) *dd++ = *ct++;
			while(PS_length--) *dd++ = 0xff;
			break;
			
	}

	bb = D->octets;
	dd = PKCSBlock->octets + blocksize - (int)D->noctets;
	i = D->noctets;
	while(i--) *dd++ = *bb++;
	return(PKCSBlock);
}

OctetString *aux_create_PKCS_MIC_D(hash_result, signatureAlgorithm)
OctetString *hash_result;
AlgId *signatureAlgorithm;

/*
 *  aux_create_PKCS_MIC_D returns a newly created OctetString
 *  which comprises the data quantity D in case of MIC encryption.
 *  The return value of aux_create_PKCS_MIC_D can be used as input
 *  parameter D of aux_create_PKCSBlock in case of BT = 01.
 *
 *  hash_result is the OctetString resulting from the hash-routine
 *  (e.g. the 16 octets from md2).
 *
 *  signatureAlgorithm is the algorithm identifier of the signature 
 *  algorithm which must be one of the PKCS signature algorithms
 *  (i.e. algspecial of that algorithm must be PKCS_BT_01). From this
 *  the digestAlgorithm is derived
 *
 *  aux_create_PKCS_MIC_D does the following 
 *  (according to PKCS#1 and RFC1423):
 *
 *  1. hash_result is ASN.1 encoded as an OCTET STRING.
 *
 *  2. The data quantity D is generated as the ASN.1 encoding of
 *
 *     SEQUENCE {
 *  		digestAlgorithm	AlgorithmIdentifier,
 *  		digest		OCTET STRING
 *     }
 *
 *     The octets of digest consist of the previously generated
 *     ASN.1 encoding of the hash_result as an OCTET STRING.
 */

{
	DigestInfo      digestinfo;
	AlgId 		*digestAlgorithm;
	AlgSpecial	algspecial;
	AlgHash		alghash;
	OctetString	*encodedDigest;
	char		*proc = "aux_create_PKCS_MIC_D";

	algspecial = aux_ObjId2AlgSpecial(signatureAlgorithm->objid);
	if(algspecial != PKCS_BT_01 && algspecial != PKCS_BT_TD) {
		aux_add_error(EINVALID, "algspecial is not PKCS_BT_01", CNULL, 0, proc);
		return((OctetString *)0);
	}
	alghash = aux_ObjId2AlgHash(signatureAlgorithm->objid);
	switch(alghash) {
		case MD2:
			digestAlgorithm = md2;
			break;
		case MD4:
			digestAlgorithm = md4;
			break;
		case MD5:
			digestAlgorithm = md5;
			break;
		default:
			aux_add_error(EINVALID, "alghash is not MD2, MD4, MD5", CNULL, 0, proc);
			return((OctetString *)0);
	}	

	digestinfo.digestAI = digestAlgorithm;
	digestinfo.digest.noctets = hash_result->noctets;
	digestinfo.digest.octets = hash_result->octets;
	encodedDigest = e_DigestInfo(&digestinfo);

	return(encodedDigest);
}

