// === Starter Application 1.0.0 === //


/* ======================================================

FUNCTION:  PrintFmtError()

INPUT:     premsg - string indicating the first message to be printed.
		This first message is usually the "title" of the error.
	   fmtmsg - string that describes the error.  Used in this
		sampleapplication to pass the status message from
		the processor method "getStatusMessage()"

RETURN:    none.   none.  Sets CLIENT object properties:  lpErrno, 
	lpMsg1 and lpMsg2, then redirects to "error.html"

NOTES:  This function is called when an error message is generated
       from the processor, e.g. if a transaction does not complete
       correctly, or if a database operation fails.  The "premsg"
       parameters generally contains general information about
       the error, and "fmtmsg" generally contains the error message
       that was generated by a status method, such as "getStatusMessage()"


====================================================== */

function PrintFmtError(premsg, fmtmsg)
{
  client.lpErrno = 1;
  client.lpErrTitle = premsg;
  client.lpErrMsg = fmtmsg;
  redirect(addClient("../error.html"));

}  // END PrintFmtError()




/* ======================================================

FUNCTION:  PrintError()

INPUT:     premsg - string indicating the first message to be printed.
		This first message is usually the "title" of the error.
	   info - the description of the error
	   postmsg - usually a string containing a suggested course
		of action to resolve the error.

RETURN:    none.  Sets CLIENT object properties:  lpErrno, 
	lpMsg1, lpMsg2 and lpMsg3, then redirects to "error.html"

DESCRIPTION:  Used for general errors that the developer wishes to
	report to the user.   These errors are usually of a more
	general nature than processor/database errors 
        (see PrintFmtError above).



====================================================== */

function PrintError(premsg, info, postmsg)
{
  client.lpErrno = 2;
  client.lpErrTitle = premsg;
  client.lpErrMsg = info;
  client.lpErrEnd = postmsg;
  redirect(addClient("../error.html"));

} // END PrintError



/* ======================================================

FUNCTION:  PrintAVSError()

INPUT:     avsFail - an integer indicating the failure/success status
	of the AVS data returned by the Acquirer after an auth.

RETURN:   none.

OUTPUT:   Prints an appropriate error message depending on whether
	the avsFailure occurred from an Address or Zip code mismatch.
	Outputs nothing and simply returns if avsFail is not 1 or 2.

NOTES:    This function currently produces an error on either an
	address mismatch or a zip code mismatch.  However, it could
	be made configurable in the future so that you can fail
	on either one, or neither depending on your business rules.

====================================================== */

function PrintAVSError(avsFail)
{

       if (avsFail == 1)
       {
               PrintError("Purchase Failed.", "Address given does not exactly match billing address.",
		"<a href=\"purchase.html?productID=" + escape(request.productID) + 
		"\">Return</a> to the purchase page");
       }
       else
       {
            if (avsFail == 2)
            {
               PrintError("Purchase Failed.", "Zip code given does not exactly match billing zip code.",
		"<a href=\"purchase.html?productID=" + escape(request.productID) + 
		"\">Return</a> to the purchase page");
            }
	}

} // END PrintAVSError()
