// === Starter Application 1.0.0 === //


/* ===================================================
 FUNCTION:  QueryCleanup()

 INPUT:     none.

 RETURN:    none.

 DESCRIPTION:  Deletes all records from  the LP_MATCHQUERY table
		from the previous query to prepare for a new 
		set of results.

 =================================================== */

function QueryCleanup() {

	// Delete current user's entries to start a new query
	database.execute("delete from LP_MATCHQUERY");				

} // END QueryCleanup()



/* ===================================================
 FUNCTION:  CountActiveParams()

 INPUT:  none.

 RETURN:  the number of items in the query form which contain
	values to be matched.  

 DESCRIPTION:  This function counts the number of non-blank fields
		in the HTML query form that was submitted.  If
		a field is left blank, it is assumed that the user
		did not want to match on that field, so the count
		is not incremented.  If the field is NOT blank, then
		the count is incremented by one indicating that 
		it is a field that will be matched upon.

		This function is used in conjunction with CalcScore()
		to perform a query on certain parameters selected
		by the user.  See the descriptions for CalcScore()
		and Query() for more information.

 =================================================== */

function CountActiveParams()
{

var fieldcount = 0;

	if (request.status != "")
		fieldcount++;


	if (request.amount != "")
		fieldcount++;
	if (request.cardtype != "")
		fieldcount++;

	if (request.mo != "")
		fieldcount++;
	if (request.day != "")
		fieldcount++;
	if (request.year != "")
		fieldcount++;

	return fieldcount;

}  // END FUNCTION CountActiveParams()



/* ===================================================
 FUNCTION:  CalcScore()

 INPUT:  scursor - a cursor pointing to a particular record
		in the LP_PURCHASE table.

 RETURN:  a numeric value representing how many of the parameters
	on the HTML query form matched values of the corresponding
	fields in the database.

 DESCRIPTION:  This function compares the value of each field in
	the HTML Query form to it's corresponding field in the
	database.  If the values are identical, the score is
	incremented by one.  
		The score that is returned can then be used
	in conjunction with CountActiveParams() to determine an
	exact match (i.e. if score() == CountActiveParams() )
	or can be used to sort resulting records in terms of
	those who had the highest score (i.e. those who had the
	most matched parameters) and those that had the lowest
	score (i.e. fewest matched parameters).  If the score
	equals = 0, that means that no parmaeters in the HTML
	form matched the values of the corresponding fields
	in the database.

 =================================================== */

function  CalcScore( scursor ) 
{

var	score = 0;
var	cardtype = "";
var 	amount = 0.0;


/* Below is a section of rules and search parameters.  Any rule may be modified
and deleted easily in this one section since this is the only place that the rules checking takes place.  New rules can be added very simply by adding an if statement patterned after
the ones below. 

	This scoring scheme can be altered in many ways.  For example, we could weight each score so that attributes which may be more important score higher if they match. 
*/


	if (scursor.status == request.status) 
		score++;
	
	amount = DollarStrToCents(request.amount) + "";
	if ( (scursor.amount + "") == amount)
		score++;

	cardtype = GetCardType(scursor.slipid);

	if (cardtype == null)
		PrintError("Cannot read slip #" + scursor.slipid,
			"Be sure the slip is not corrupted in the database.");

	if ( cardtype == request.cardtype )
		score++;
	
	eventMo = (scursor.eventTime.getMonth() + 1) + "";

	eventDay = scursor.eventTime.getDate() + "";

	eventYear = (scursor.eventTime.getYear() + 1900) + "";
	
	if (eventMo == request.mo)
		score++;
	if (eventDay == request.day)
		score++;
	if (eventYear == request.year)
		score++;

	return score;

} // END CalcScore()



/* ===================================================
 FUNCTION:  Query

 INPUT:     None.

 RETURNS:   None.

 DESCRIPTION:  Runs a query against the LP_PURCHASE table to find records which meet
	criteria specified in the "query.html" input form.  Stores ID's of the resulting
	records in the LP_MATCHQUERY table.  The function then redirects to "querylist.html"
	which outputs the list of transactions for viewing.

 =================================================== */

function Query()
{

// **********
// ASSUMPTION:  Only one administrator at at time will be running queries.
// **********

var score = 0;
var hits = 0;   // Number of matches
var today = new Date();
var paramcountstr = "", scorestr = "";
var redirectstr = "";

	QueryCleanup();

	// Get the list of transactions
	cursor = database.cursor("select * from LP_PURCHASE");
	paramcountstr = CountActiveParams() + "";

	// Loop through each job and score it.
	
	while (cursor.next()) 
	{
		scorestr = CalcScore(cursor) + "";
		
		// if all parameters matched, insert the transaction 
		// id into the query result table
		
		if ( scorestr == paramcountstr ) 
		{
		  error = database.execute("insert into LP_MATCHQUERY values('" + 
			cursor.id + "')");
		  if ((error == 5) || (error == 7))
			PrintError("Database Error.", "Could not insert into LP_MATCHQUERY table.  " +
				"Error code " + error + ": " + database.majorErrorMessage());
		  else if (error)
			PrintError("Database Error.", "Could not insert into LP_MATCHQUERY table." +
				"Error code " + error + " returned from the database.");
		  else
			hits += 1;
		} // END if

		
	} // End while loop


	 cursor.close();

	return hits;	// Return the number of successful matches.
			// At this point, the results are currently
			// stored in the LP_MATCHQUERY table.
	
}  // END FUNCTION Query
