/* change system id on IRIX 5.3 - only minimally tested on an Indigo II
   consider this a very early alpha - mch@squirrel.com 

   placed in the public domain by the author - 1996

   since the system ID on different types of SGI hardware is obtained in
   different ways, YMMV. This may even crash your machine.

   compile by   --  cc -o change-sid change-sid.c -lmld 

   run this with no parameters first and make sure it reports the
   correct system id

   if all is well, you can run it with the system id you want (in hex)
   as the first parameter
*/

#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <nlist.h>
struct nlist nl[2];
 
main(argc,argv)
int argc;
char *argv[];
{
    int kmem;
    int just_read = 0;
    unsigned int new_id, cur_id;
    off_t where;
    just_read = (argc <= 1);
    if (argc > 1) 
         new_id = strtoul(argv[1], NULL, 16);

    if ((kmem = open("/dev/kmem", O_RDWR)) < 0) {
        fprintf(stderr, "cannot open /dev/kmem\n");
        exit(1);
    }
    nl[0].n_name="eccf_addr";
    nl[1].n_name = NULL;
    if (nlist("/unix", nl) < 0) {
        fprintf(stderr, "cannot read namelist out of /unix\n");
        exit(1);
    }
    if ((where = nl[0].n_value) == 0) {
        fprintf(stderr, "unknown kernel variable eccf_addr\n");
        exit(1);
    }
    if (lseek(kmem, where + 4, SEEK_SET) == (-1)) {
        fprintf(stderr, "lseek on /dev/kmem failed\n");
        exit(1);
    }
    if (!just_read) {
        if (write (kmem, &new_id, 4) < 4) {
            fprintf(stderr, "write to /dev/kmem failed\n");
            exit(1);
        }
    }
    else {
        if (read(kmem, &cur_id, 4) < 4) {
            fprintf(stderr, "read failed\n");
            exit(1);
        }
        printf("hexadecimal system id seems to be %08x\n", cur_id);
    }
    close(kmem);
    exit(0);
}

