/* change the hostid reported by sysinfo and gethostid on Solaris 2.4 x86
   - run the script this produces on stdout to actually make the change. Note
     that you must have adb installed to use this 

    e.g. hid_solaris2 b0b1fb0b | sh -v

Mark Henderson <mch@squirrel.com>
Placed in the public domain by the author - June 1995
 
This program is distributed in the hope that it will be useful,
but without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose. You use
this program at your own risk. The author disclaims responsibility for
any damages that might result from the use of this program, even
if they result from negligence on the part of the author.

Also, please don't use this program to steal software. The intended
use is for emergency situations where an application has to be moved from
one computer to another (e.g. in the event of a hardware malfunction)
and licence keys cannot be obtained quickly from the vendor. Many
vendors will not supply licence keys outside of business hours.

The hostid is stored in ASCII decimal form in the kernel variable
hw_serial. We simply change the in-core value of the string pointed
to by hw_serial.

*/

#include <stdio.h>
main(argc,argv)
int argc;
char *argv[];
{
    unsigned int hid;
    int i;
    char obuf[15];
    for (i=0; i<15; i++)
        obuf[i] = '\0';

    if (argc != 2) {
        fprintf(stderr, "usage: %s hostid\n",argv[0]);
        exit(1);
    }
    sscanf(argv[1],"%08x",&hid);
    sprintf(obuf,"%u", hid);  /* should this be %010u ? */

    printf("#!/bin/sh\n");
    printf("# this script sets the hostid to %08x\n",hid);
    printf("adb -w -k /dev/ksyms /dev/mem <<END\n");
    printf("hw_serial/W 0x");
    for (i=3; i>=0; i--)
        printf("%02x", obuf[i]);
    printf("\n");
    printf("hw_serial+4/W 0x");
    for (i=7; i>=4; i--)
        printf("%02x", obuf[i]);
    printf("\n");
    printf("hw_serial+8/W 0x");
    for (i=11; i>=8; i--)
        printf("%02x", obuf[i]);
    printf("\n");
    printf("END\n");
	return(0);
}
