/* 
 * based on an anonymous contribution  
 * 
 * modified for Solaris 2.5 by Cyber Buddha 
 */

/* make sure that errno is set correctly in MT applications */
#define _REENTRANT

#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include <errno.h>
#include <sys/systeminfo.h>

#define HOSTIDLEN 40
 
long gethostid(void)
{
    char name[HOSTIDLEN+1], *end;
    int output;
 
    if (sysinfo(SI_HW_SERIAL, name, HOSTIDLEN) == -1)
        return (-1);
    output = strtoul(name, &end, 10);
    if (end == name)
        return (-1);
 
    return ((long)output);
}

int sysinfo(command, buf, count)
int command; char *buf; long count;
{
switch (command)
  {
  case SI_HW_SERIAL:
    {
      char *hid;

      if ((hid = getenv ("SI_HW_SERIAL")) != 0)
	{
	  strncpy (buf, hid, count);
	  buf[count - 1] = '\0';
	  return strlen (hid) + 1;
	}
    }
  default:
    {
      long (*real_sysinfo) ();

      if ((real_sysinfo = (long (*)()) dlsym (RTLD_NEXT, "sysinfo")) == 0)
	{
	  errno = EINVAL;
	  return -1;
	}
      return real_sysinfo (command, buf, count);
    }
  }
}
