/* desloop.c */
/*
The contents of this file contain text and code describing and 
implementing the 'DES' encryption algorithm. Despite the fact 
that this information is freely available overseas, it remains 
a violation of ITAR and/or EAR to export this information 
from inside the US or Canada to outside the US or Canada, or 
to pass it to a non-US or non-Canadian citizen within the US 
or Canada. The US Government evidently defines 'Export' to 
include placing this information on a non-restricted FTP server 
or Web site. Please do not do so, and be sure that any person you
pass this on to is made aware of this restriction.
									Peter Trei
									ptrei@acm.org

 * THIS SOFTWARE IS PROVIDED BY PETER TREI ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.

This software is copyright (c) 1997 Peter Trei (ptrei@acm.org), except for
those portions written by Phil Karn, which retain their
original ownership.

This software may be redistributed freely for use in the RSA DES Challenge,
but please obey the restrictions imposed by the US Government, and make
sure that anyone you pass it to is also aware of them.

This software may not be used for commercial purposes without the written
permission of Peter Trei and the other owners.

Please redistribute only as a complete, unmodified package, including 
source code, and ptrei@acm.org's PGP signature file and key.

 */

#include "deskr.h"

unsigned long xSpboxa[8][64] = {
0x04041000,0x00000000,0x00040000,0x04041010,
0x04040010,0x00041010,0x00000010,0x00040000,
0x00001000,0x04041000,0x04041010,0x00001000,
0x04001010,0x04040010,0x04000000,0x00000010,
0x00001010,0x04001000,0x04001000,0x00041000,
0x00041000,0x04040000,0x04040000,0x04001010,
0x00040010,0x04000010,0x04000010,0x00040010,
0x00000000,0x00001010,0x00041010,0x04000000,
0x00040000,0x04041010,0x00000010,0x04040000,
0x04041000,0x04000000,0x04000000,0x00001000,
0x04040010,0x00040000,0x00041000,0x04000010,
0x00001000,0x00000010,0x04001010,0x00041010,
0x04041010,0x00040010,0x04040000,0x04001010,
0x04000010,0x00001010,0x00041010,0x04041000,
0x00001010,0x04001000,0x04001000,0x00000000,
0x00040010,0x00041000,0x00000000,0x04040010,
0x00420082,0x00020002,0x00020000,0x00420080,
0x00400000,0x00000080,0x00400082,0x00020082,
0x00000082,0x00420082,0x00420002,0x00000002,
0x00020002,0x00400000,0x00000080,0x00400082,
0x00420000,0x00400080,0x00020082,0x00000000,
0x00000002,0x00020000,0x00420080,0x00400002,
0x00400080,0x00000082,0x00000000,0x00420000,
0x00020080,0x00420002,0x00400002,0x00020080,
0x00000000,0x00420080,0x00400082,0x00400000,
0x00020082,0x00400002,0x00420002,0x00020000,
0x00400002,0x00020002,0x00000080,0x00420082,
0x00420080,0x00000080,0x00020000,0x00000002,
0x00020080,0x00420002,0x00400000,0x00000082,
0x00400080,0x00020082,0x00000082,0x00400080,
0x00420000,0x00000000,0x00020002,0x00020080,
0x00000002,0x00400082,0x00420082,0x00420000,
0x00000820,0x20080800,0x00000000,0x20080020,
0x20000800,0x00000000,0x00080820,0x20000800,
0x00080020,0x20000020,0x20000020,0x00080000,
0x20080820,0x00080020,0x20080000,0x00000820,
0x20000000,0x00000020,0x20080800,0x00000800,
0x00080800,0x20080000,0x20080020,0x00080820,
0x20000820,0x00080800,0x00080000,0x20000820,
0x00000020,0x20080820,0x00000800,0x20000000,
0x20080800,0x20000000,0x00080020,0x00000820,
0x00080000,0x20080800,0x20000800,0x00000000,
0x00000800,0x00080020,0x20080820,0x20000800,
0x20000020,0x00000800,0x00000000,0x20080020,
0x20000820,0x00080000,0x20000000,0x20080820,
0x00000020,0x00080820,0x00080800,0x20000020,
0x20080000,0x20000820,0x00000820,0x20080000,
0x00080820,0x00000020,0x20080020,0x00080800,
0x02008004,0x00008204,0x00008204,0x00000200,
0x02008200,0x02000204,0x02000004,0x00008004,
0x00000000,0x02008000,0x02008000,0x02008204,
0x00000204,0x00000000,0x02000200,0x02000004,
0x00000004,0x00008000,0x02000000,0x02008004,
0x00000200,0x02000000,0x00008004,0x00008200,
0x02000204,0x00000004,0x00008200,0x02000200,
0x00008000,0x02008200,0x02008204,0x00000204,
0x02000200,0x02000004,0x02008000,0x02008204,
0x00000204,0x00000000,0x00000000,0x02008000,
0x00008200,0x02000200,0x02000204,0x00000004,
0x02008004,0x00008204,0x00008204,0x00000200,
0x02008204,0x00000204,0x00000004,0x00008000,
0x02000004,0x00008004,0x02008200,0x02000204,
0x00008004,0x00008200,0x02000000,0x02008004,
0x00000200,0x02000000,0x00008000,0x02008200,
0x00000400,0x08200400,0x08200000,0x08000401,
0x00200000,0x00000400,0x00000001,0x08200000,
0x00200401,0x00200000,0x08000400,0x00200401,
0x08000401,0x08200001,0x00200400,0x00000001,
0x08000000,0x00200001,0x00200001,0x00000000,
0x00000401,0x08200401,0x08200401,0x08000400,
0x08200001,0x00000401,0x00000000,0x08000001,
0x08200400,0x08000000,0x08000001,0x00200400,
0x00200000,0x08000401,0x00000400,0x08000000,
0x00000001,0x08200000,0x08000401,0x00200401,
0x08000400,0x00000001,0x08200001,0x08200400,
0x00200401,0x00000400,0x08000000,0x08200001,
0x08200401,0x00200400,0x08000001,0x08200401,
0x08200000,0x00000000,0x00200001,0x08000001,
0x00200400,0x08000400,0x00000401,0x00200000,
0x00000000,0x00200001,0x08200400,0x00000401,
0x80000040,0x81000000,0x00010000,0x81010040,
0x81000000,0x00000040,0x81010040,0x01000000,
0x80010000,0x01010040,0x01000000,0x80000040,
0x01000040,0x80010000,0x80000000,0x00010040,
0x00000000,0x01000040,0x80010040,0x00010000,
0x01010000,0x80010040,0x00000040,0x81000040,
0x81000040,0x00000000,0x01010040,0x81010000,
0x00010040,0x01010000,0x81010000,0x80000000,
0x80010000,0x00000040,0x81000040,0x01010000,
0x81010040,0x01000000,0x00010040,0x80000040,
0x01000000,0x80010000,0x80000000,0x00010040,
0x80000040,0x81010040,0x01010000,0x81000000,
0x01010040,0x81010000,0x00000000,0x81000040,
0x00000040,0x00010000,0x81000000,0x01010040,
0x00010000,0x01000040,0x80010040,0x00000000,
0x81010000,0x80000000,0x01000040,0x80010040,
0x00800000,0x10800008,0x10002008,0x00000000,
0x00002000,0x10002008,0x00802008,0x10802000,
0x10802008,0x00800000,0x00000000,0x10000008,
0x00000008,0x10000000,0x10800008,0x00002008,
0x10002000,0x00802008,0x00800008,0x10002000,
0x10000008,0x10800000,0x10802000,0x00800008,
0x10800000,0x00002000,0x00002008,0x10802008,
0x00802000,0x00000008,0x10000000,0x00802000,
0x10000000,0x00802000,0x00800000,0x10002008,
0x10002008,0x10800008,0x10800008,0x00000008,
0x00800008,0x10000000,0x10002000,0x00800000,
0x10802000,0x00002008,0x00802008,0x10802000,
0x00002008,0x10000008,0x10802008,0x10800000,
0x00802000,0x00000000,0x00000008,0x10802008,
0x00000000,0x00802008,0x10800000,0x00002000,
0x10000008,0x10002000,0x00002000,0x00800008,
0x40004100,0x00004000,0x00100000,0x40104100,
0x40000000,0x40004100,0x00000100,0x40000000,
0x00100100,0x40100000,0x40104100,0x00104000,
0x40104000,0x00104100,0x00004000,0x00000100,
0x40100000,0x40000100,0x40004000,0x00004100,
0x00104000,0x00100100,0x40100100,0x40104000,
0x00004100,0x00000000,0x00000000,0x40100100,
0x40000100,0x40004000,0x00104100,0x00100000,
0x00104100,0x00100000,0x40104000,0x00004000,
0x00000100,0x40100100,0x00004000,0x00104100,
0x40004000,0x00000100,0x40000100,0x40100000,
0x40100100,0x40000000,0x00100000,0x40004100,
0x00000000,0x40104100,0x00100100,0x40000100,
0x40100000,0x40004000,0x40004100,0x00000000,
0x40104100,0x00104000,0x00104000,0x00004100,
0x00004100,0x00100100,0x40000000,0x40104000,
};


 #define keyupdatemacro(i)\
	{\
	__asm mov ebx,		[eax+i]\
	__asm mov esi,		[eax+i+4]\
	__asm mov edx,		[ecx+i]\
	__asm mov edi,		[ecx+i+4]\
	__asm xor ebx,		edx\
	__asm xor esi,		edi\
	__asm mov [eax+i],	ebx\
	__asm mov [eax+i+4],esi\
	}
/* this is one I'm working on for key bit 0 only */
#define key0updatemacro(a,b,c,d)\
	{\
	__asm  mov ebx, [eax+a]\
	__asm  mov ecx, [eax+c]\
	__asm  xor ebx, b\
	__asm  xor ecx, d\
	__asm  mov [eax+a], ebx\
	__asm  mov [eax+c], ecx\
	}
#define	F(l,r,key)\
	{\
\
	__asm xor ebx,ebx				/* 1   uv B */\
	__asm mov eax,r					/* 1   uv A */\
	__asm mov ecx,[ebp+key+4]		/* 1   uv B */\
	__asm ror eax,4					/* 1   np A */\
	__asm xor eax,[ebp+key]			/* 1   uv A */\
	__asm xor ecx,r					/* 1   uv B */\
	__asm and eax,0fcfcfcfch		/* 1   uv A */\
	__asm and ecx,0fcfcfcfch		/* 1   uv B */\
/* eax now contains even sbox indices: b0i, b2i, b4i, b6i */\
/* ecx now contains odd  sbox indices: b1i, b3i, b5i, b7i */\
	__asm mov bl, al					/* 1     move b6i to ebx */\
	__asm mov dl, ah					/* 2     move b4i to edx */\
	__asm mov ebp, xSpboxa[ebx+0600h]	/* 3     move b6 to ebp  */\
	__asm mov bl, cl					/* 4     move b7i to ebx */\
	__asm xor l, ebp					/* 5     xor b6 into l   */\
	__asm mov ebp, xSpboxa[edx+0400h]	/* 6     move b4 to ebp  */\
	__asm xor l, ebp					/* 7     xor b4 into l   */\
	__asm mov dl, ch					/* 8     move b5i to edx */\
	__asm shr eax, 16					/* 9     shift eax. It now contains 0 0 b0i, b2i */\
	__asm mov ebp, xSpboxa[ebx+0700h]	/* 10    move b7 to ebp  */\
	__asm xor l, ebp					/* 11    xor b7 into l   */\
	__asm mov bl, ah					/* 12    move b0i to ebx */\
	__asm shr ecx, 16					/* 13    shift ecx. It now contains 0 0 b1i, b3i */\
	__asm mov ebp, xSpboxa[edx+0500h]	/* 14,15 move b5 to ebp  */\
	__asm xor l, ebp					/* 16    xor b5 into l   */\
	__asm mov ebp, dword ptr [sks]		/* 17    restore key schedule pointer */\
    __asm mov dl, ch					/* 18    move b1i to edx */\
	__asm and ecx, 0FFh					/* 20    ecx now contains b3i */\
	__asm and eax, 0FFh					/* 19    eax now contains b2i */\
	__asm mov ebx, xSpboxa[ebx]			/* 21    mov b0 to ebx   */\
	__asm xor l, ebx					/* 22    xor b0 into l   */\
	__asm mov ebx, xSpboxa[ecx+0300h]	/* 23    mov b3 to ebx   */\
	__asm xor l, ebx                    /* 24    xor b3 into l   */\
	__asm mov ebx, xSpboxa[eax+0200h]    /* 25    mov b2 to ebx   */\
	__asm xor l, ebx                    /* 26    xor b2 into l   */\
	__asm mov ebx, xSpboxa[edx+0100h]    /* 27    mov b1 to ebx   */\
	__asm xor l, ebx                    /* 28    xor b1 into l   */\
	}

/*********************/
int x86_do_lower_16()
{
static unsigned long sks;
	int z;

	static unsigned long pkdf;

/*
This routine steps through the most swiftly changing 16 bits of the key
chunk under test. This tests 65536 keys (a mini-chunk) and is the minimum 
number of keys tested before an interruption. On an Intel, it will 
take, at worst, a few seconds to execute. 

If it is entered with the key schedule already set up, and the values 
of b0 and b1 above zero, it will continue to the end of the 16 bit
mini-chunk

This routine, and all the code below, it, will benefit greatly from 
conversion to assembly language. Converting above this point is not
worth the effort.

This routine returns:
  0: No match found
  1: half match found - needs check for full match.
*/
#ifdef TESTGRAY
unsigned long hw,lw;
/*unsigned char wk[8];*/
#endif /* TESTGRAY */

sks = (unsigned long)&knd[0][0];

done_lower = 0;
while (done_lower == 0)
	{
	left =  round1_output_left;		/* initialize left and right */
	right = round1_output_right;

	/*do_middle_rounds(knd); *//* do des rounds 2 through 15 */
	/*+++++++++++++++++++++*/
	__asm{
	mov ebx,0;	/* u 1 cyc 1 Upper 3 bytes must be zero */

	mov edi, right; /* v 1 cyc 1 CHANGE */
	mov esi, left; /* u 1 cyc 2 CHANGE */
	push ebp;
	/* Do the rounds */
	xor edx, edx;            /* testing new round */
	mov ebp, dword ptr [sks]; /* testing new round */

	F(edi,esi,8);  /*round 1  */
	F(esi,edi,16); /*round 2  */
	F(edi,esi,24); /*round 3  */
	F(esi,edi,32); /*round 4  */
	F(edi,esi,40); /*round 5  */
	F(esi,edi,48); /*round 6  */
	F(edi,esi,56); /*round 7  */
	F(esi,edi,64); /*round 8  */
	F(edi,esi,72); /*round 9  */
	F(esi,edi,80); /*round 10 */
	F(edi,esi,88); /*round 11 */
	F(esi,edi,96); /*round 12 */
	F(edi,esi,104);/*round 13 */
	F(esi,edi,112);/*round 14 */

	pop ebp;
	mov left, esi;
	mov right, edi;
	} /* _asm */

		/*+++++++++++++++++++++*/
#ifdef TESTGRAY
	ks_to_key(knd,&hw,&lw);
	q[lw & 0xffff]++;
	count++;
#endif /* testgray */		
	
	
	checksum ^= left;
	if (final_perm_input_right == left)
		{
		/* we've got a half match. We need to run the final round
		and test the output */
		return 1;
		}
	/* update the key schedule to the next key */
	/* byte 0, the low order, most swiftly changing bits.*/

	bi = gray8[b0++];/* which bit varies on this key change?*/

	if (!bi)
		{
		/* special case code for bit 0, flipped 1/2 of the time. */
		__asm mov eax, sks;
		__asm clc;
		key0updatemacro(0x1c,0x00040000, 0x30,0x00040000);
		key0updatemacro(0x08,0x00080000, 0x4c,0x00080000);
		key0updatemacro(0x20,0x00100000, 0x2c,0x10000000);
		key0updatemacro(0x70,0x00800000, 0x3c,0x04000000);
		key0updatemacro(0x6c,0x08000000, 0x60,0x00400000);
		key0updatemacro(0x40,0x20000000, 0x54,0x20000000);
		key0updatemacro(0x14,0x40000000, 0x58,0x40000000);
		}
	else
		if (bi == 1)
			{
			/* bit 1 only changes 11 subkeys! executed 1/4 of the time */
			__asm mov eax, sks;
			__asm clc;
			key0updatemacro(0x24 ,0x00800000, 0x10 ,0x00200000);
			key0updatemacro(0x34 ,0x00100000, 0x18 ,0x80000000);
			key0updatemacro(0x54 ,0x00200000, 0x0c ,0x04000000);
			key0updatemacro(0x64 ,0x80000000, 0x40 ,0x00800000);
			key0updatemacro(0x74 ,0x00400000, 0x58 ,0x08000000);
			key0updatemacro(0x00 ,0x00000000, 0x68 ,0x04000000);
			}
		else
			{
			/* slower general code, executed 1/4 of the time */
			pkdf = (unsigned long)&drkeydiffs[bi][0][0];
			__asm	mov eax, sks;
			__asm	mov ecx, pkdf;
			__asm	clc; /* this looks superfluous, but improves the pairing */
    
			keyupdatemacro(0x08);
			keyupdatemacro(0x10);
			keyupdatemacro(0x18);
			keyupdatemacro(0x20);
		 	keyupdatemacro(0x28);
			keyupdatemacro(0x30);
 	 		keyupdatemacro(0x38);
			keyupdatemacro(0x40);
 	 		keyupdatemacro(0x48);
			keyupdatemacro(0x50);
			keyupdatemacro(0x58);
			keyupdatemacro(0x60);
			keyupdatemacro(0x68);
			keyupdatemacro(0x70);
			keyupdatemacro(0x78);
			}
	if (b0 == 256) 		
		{
		/*
		this code is entered when it's time to update the next higher
		byte - defined by b1.
		*/
		b0=0;
		bi = gray8[b1++]+8;
		for (z = 0; z<15; z++)
			{
			knd[z][0] ^= drkeydiffs[bi][z][0];
			knd[z][1] ^= drkeydiffs[bi][z][1];
			}
		/* the bit reshuffle in crunchkey means that we dont need
		to run the first round until the higher bits change */
		
		left  = initial_perm_output_left;
		right = initial_perm_output_right;
		do_first_round(knd);
		round1_output_left = left;
		round1_output_right = right;
		
		if (b1 == 256) done_lower = 1;
		}	
	/*++++++++++++++++++++++++*/
	}
return 0;
}
/*-----------------------------*/