/* pkcrack - stage3.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: stage3.c,v 1.4 1996/06/12 09:47:27 conrad Release $
 *
 * $Log: stage3.c,v $
 * Revision 1.4  1996/06/12 09:47:27  conrad
 * Release version
 *
 * Revision 1.3  1996/06/11 20:15:30  conrad
 * Several speedups using more table lookup and less function calls.
 *
 * Revision 1.2  1996/06/11 10:26:56  conrad
 * fixed small bug when printing passwords
 * inserted fflush(stdout) to keep track of progress
 *
 * Revision 1.1  1996/06/10 18:07:56  conrad
 * Initial revision
 *
 */

static char RCSID[]="$Id: stage3.c,v 1.4 1996/06/12 09:47:27 conrad Release $";

#include <stdio.h>
#include "pkcrack.h"
#include "crc.h"
#include "mktemptbl.h"
#include "keystuff.h"

#define	CONST		0x08088405	/* 134775813 */
#define	INVCONST	0xd94fa8cd

#define	MULT(x)		((mulTab[((x)>>24)&0xff]<<24) + \
			 (mulTab[((x)>>16)&0xff]<<16) + \
			 (mulTab[((x)>> 8)&0xff]<< 8) + \
			 (mulTab[((x)    )&0xff]    ))

static uword	mulTab[256];
static byte	mTab2[256][16];
static byte	mTab2Counter[256];
static byte	invCrcTab[256][4];
static byte	invCrcTabCounter[256];

static byte	pwd[15];
static int	pwdLen;

static uword	l0, l1, l2, m0, m1, m2;
static uword	key1list[12], key0list[12];

#ifndef	SLOW
static void updateKeys( byte plainbyte )
/* we don't need temp and key3... */
{
    key0 = CRC32( key0, plainbyte );
    key1 = (key1 + (key0&0xff))*134775813 + 1;
    key2 = CRC32( key2, (key1>>24)&0xff );
}
#endif

static int recursion1( int i, int (*foundFunc)() )
/* given a value for key1_i, compute all possible values of key1_{i-1} that
 * fit the MSB of key1_{i-2} */
{
int	k, res=0;
uword	MSBiminus1, MSBiminus2, lsbkey0, lsbkey0pluskey1iminus1, test, temp2;
byte	diff;

/*    if( i == 3 )
    {
	return foundFunc( );
    }*/
/*    if( key1list[12] == 0xc3066eb6 )
	printf( "%s%08x\n", "            "+i, key1list[i] );*/

    MSBiminus1 = key1list[i-1]&0xff000000;
    MSBiminus2 = key1list[i-2]&0xff000000;
    lsbkey0pluskey1iminus1 = MULT(key1list[i]-1);
    temp2 = MULT(lsbkey0pluskey1iminus1-1);
    diff = (((temp2&0xff000000)-MSBiminus2)>>24)&0xff;
    for( k = 0; k < mTab2Counter[diff]; k++ )
    {
	test = temp2 - mulTab[mTab2[diff][k]];
	if( test >= MSBiminus2 && test <= MSBiminus2 + 0x010000fe )
	{
	    lsbkey0 = mTab2[diff][k];
	    key1list[i-1] = lsbkey0pluskey1iminus1-lsbkey0;
	    key0list[i]   = lsbkey0;
	    if( i > 4 )
		res |= recursion1( i-1, foundFunc );
	    else
		res |= foundFunc();
	}
    }
    diff--;
    for( k = 0; k < mTab2Counter[diff]; k++ )
    {
	test = temp2 - mulTab[mTab2[diff][k]];
	if( test >= MSBiminus2 && test <= MSBiminus2 + 0x010000fe )
	{
	    lsbkey0 = mTab2[diff][k];
	    key1list[i-1] = lsbkey0pluskey1iminus1-lsbkey0;
	    key0list[i]   = lsbkey0;
	    if( i > 4 )
		res |= recursion1( i-1, foundFunc );
	    else
		res |= foundFunc();
	}
    }
    key1list[i-1] = MSBiminus1;

    return res;
}

static int testPwd( )
{
int	i, res=0;
uword	k0, k1, k2;

    k0 = key0;
    k1 = key1;
    k2 = key2;
#ifdef SLOW
    initkeys();
#else
    key0 = 0x12345678;
    key1 = 0x23456789;
    key2 = 0x34567890;
#endif
    for( i = 0; i < pwdLen; i++ )
	updateKeys( pwd[i] );
    if( key0 == l0 && key1 == l1 && key2 == l2 )
	res = 1;

    key0 = k0;
    key1 = k1;
    key2 = k2;

    return res;
}

static int printPwd( )
{
int	i;

    if( testPwd() )
    {
	printf( "Key:" );
	for( i = 0; i < pwdLen; i++ )
	    printf( " %02x", pwd[i] );
	printf( "\nOr as a string: '" );
	for( i = 0; i < pwdLen; i++ )
	    printf( "%c", pwd[i] );
	printf( "' (without the enclosing single quotes)\n" );
	fflush( stdout );
	return 1;
    }

    return 0;
}

static int print4Bytes( byte b1, byte b2, byte b3, byte b4 )
{
    pwd[0] = b1;
    pwd[1] = b2;
    pwd[2] = b3;
    pwd[3] = b4;
    pwdLen = 4;
    return printPwd();
}

static int find4Bytes( uword init, uword result, int (*foundFunc)( byte b1, byte b2, byte b3, byte b4 ) )
/* Find 4 bytes with crc(crc(crc(crc(init,byte1),byte2),byte3),byte4) == result.
 *   crc(crc(crc(crc(init,byte1),byte2),byte3),byte4)
 * = crc(crc(crc((init>>8)^crctab[init&0xff^byte1],byte2),byte3),byte4)
 * = crc(crc((init>>16)^(crctab[init&0xff^byte1]>>8)^
 *	     crctab[((init>>8)^crctab[init&0xff^byte1])&0xff)^byte2]),byte3),byte4)
 * = crc((init>>24)^(crctab[init&0xff^byte1]>>16)^
 *	 (crctab[((init>>8)^crctab[init&0xff^byte1])&0xff)^byte2]>>8)^
 *	 crctab[(init>>16)^(crctab[init&0xff^byte1]>>8)^
 *		((crctab[(((init>>8)^crctab[init&0xff^byte1])&0xff)^byte2])&0xff)^byte3],
 *	 byte4)
 * = (crctab[init&0xff^byte1]>>24)^
 *   (crctab[((init>>8)^crctab[init&0xff^byte1])&0xff)^byte2]>>16)^
 *   (crctab[(init>>16)^(crctab[init&0xff^byte1]>>8)^
 *	     ((crctab[(((init>>8)^
 *			crctab[init&0xff^byte1])&0xff)^byte2])&0xff)^byte3]>>8)^
 *   crctab[(((init>>24)^(crctab[init&0xff^byte1]>>16)^
 *	      (crctab[((init>>8)^crctab[init&0xff^byte1])&0xff)^byte2]>>8)^
 *	      crctab[(init>>16)^(crctab[init&0xff^byte1]>>8)^
 *		     ((crctab[(((init>>8)^
 *			      crctab[init&0xff^byte1])&0xff)^byte2])&0xff)^byte3])&0xff)^byte4]
 *
 * The MSB of result depends only on the last of the above XOR-Terms. So we can find
 * the index in crctab that produces the correct result. Then we apply the same
 * procedure to the secondmost significant byte, and so on...
 * Finally we can calculate b1, and then backwards b2, b3 and b4.
 */
{
int	i, j, k, l, found=0;
uword	temp1, temp2, temp3, temp4;
byte	b1, b2, b3, b4;

    for( i = 0; i < invCrcTabCounter[(result>>24)&0xff]; i++ )
    {
	temp1 = result^crctab[invCrcTab[(result>>24)&0xff][i]];
	for( j = 0; j < invCrcTabCounter[(temp1>>16)&0xff]; j++ )
	{
	    temp2 = temp1 ^ (crctab[invCrcTab[(temp1>>16)&0xff][j]]>>8);
	    for( k = 0; k < invCrcTabCounter[(temp2>>8)&0xff]; k++ )
	    {
		temp3 = temp2 ^ (crctab[invCrcTab[(temp2>>8)&0xff][k]]>>16);
		for( l = 0; l < invCrcTabCounter[temp3&0xff]; l++ )
		{
		    b1 = invCrcTab[temp3&0xff][l]^init;
		    temp4 = CRC32( init, b1 );
		    b2 = invCrcTab[(temp2>>8)&0xff][k]^temp4;
		    temp4 = CRC32( temp4, b2 );
		    b3 = invCrcTab[(temp1>>16)&0xff][j]^temp4;
		    temp4 = CRC32( temp4, b3 );
		    b4 = invCrcTab[(result>>24)&0xff][i]^temp4;
		    temp4 = CRC32( temp4, b4 );
		    if( temp4 != result )
			fprintf( stderr, "Huh? This can't happen...\n" );
		    else
			found |= foundFunc( b1, b2, b3, b4 );
		}
	    }
	}
    }

    return found;
}

static int find5c( byte b1, byte b2, byte b3, byte b4 )
{
int	res;

    pwd[pwdLen++] = b1;
    pwd[pwdLen++] = b2;
    pwd[pwdLen++] = b3;
    pwd[pwdLen++] = b4;
    pwdLen++;

    res = printPwd( );

    pwdLen -= 5;

    return res;
}

static int find5b( )
{
int	i, res=0;
uword	key00;

    for( i = 0; i < 256; i++ )
    {
	key00 = INVCRC32(l0,i);
	if( (key00&0xff) == (key0list[5]&0xff) )
	{
	    pwd[pwdLen+4] = i;
	    res |= find4Bytes( key0, key00, find5c );
	}
    }

    return res;
}

static int find5a( byte b1, byte b2, byte b3, byte b4 )
{
    key1list[2] = b1<<24;
    key1list[3] = b2<<24;
    key1list[4] = b3<<24;
    key1list[5] = b4<<24;
    return recursion1( 6, find5b );
}

static int find5Bytes( )
{
uword	key20;

    initkeys();

    key20 = INVCRC32( l2, (l1>>24)&0xff );
    key1list[6] = l1;

    return find4Bytes( 0x34567890, key20, find5a );
}

static int find6c( byte b1, byte b2, byte b3, byte b4 )
{
int	res;

#ifndef SLOW
uword	k0, k1, k2;

    k0 = key0;
    k1 = key1;
    k2 = key2;
    key0 = m0;
    key1 = m1;
    key2 = m2;

    updateKeys( b1 );
    updateKeys( b2 );
    updateKeys( b3 );
    updateKeys( b4 );
    updateKeys( pwd[pwdLen+4] );
    updateKeys( pwd[pwdLen+5] );

    if( key0 == l0 && key1 == l1 && key2 == l2 )
    {
#endif

    pwd[pwdLen++] = b1;
    pwd[pwdLen++] = b2;
    pwd[pwdLen++] = b3;
    pwd[pwdLen++] = b4;
    pwdLen += 2;

    res = printPwd( );

    pwdLen -= 6;

#ifndef SLOW
    }
    else
	res = 0;

    key0 = k0;
    key1 = k1;
    key2 = k2;
#endif

    return res;
}

static int find6b( )
{
uword	i, j;
uword	key00, key0minus1;

    i = (key0list[6]^crcinvtab[(l0>>24)&0xff])&0xff;
    key00 = INVCRC32(l0,i);
    j = (key0list[5]^crcinvtab[(key00>>24)&0xff])&0xff;
    key0minus1 = INVCRC32(key00,j);
    pwd[pwdLen+4] = j;
    pwd[pwdLen+5] = i;
    return find4Bytes( key0, key0minus1, find6c );
}

static int find6a( byte b1, byte b2, byte b3, byte b4 )
{
    key1list[2] = b1<<24;
    key1list[3] = b2<<24;
    key1list[4] = b3<<24;
    key1list[5] = b4<<24;
    return recursion1( 6, find6b );
}

static int find6Bytes( )
{
uword	key10, key20, key2minus1;
int	i;

#ifdef SLOW
    initkeys();
    for( i = 0; i < pwdLen; i++ )
	updateKeys( pwd[i] );
#else
    key0 = m0;
    key1 = m1;
    key2 = m2;
#endif

    key20 = INVCRC32( l2, (l1>>24)&0xff );
    key10 = (l1-1)*INVCONST-(l0&0xff);
    key2minus1 = INVCRC32( key20, (key10>>24)&0xff );

    key1list[6] = key10;
    return find4Bytes( key2, key2minus1, find6a );
}

void findPwd( uword key0, uword key1, uword key2 )
{
int	i;
uword	key0list[20], key1list[20], key2list[20];

    l0 = key0;
    l1 = key1;
    l2 = key2;

    if( !find4Bytes( 0x12345678, key0, print4Bytes ) )
    {
	pwdLen = 0;
	m0 = key0list[0] = 0x12345678;
	m1 = key1list[0] = 0x23456789;
	m2 = key2list[0] = 0x34567890;
	if( !find5Bytes( ) && !find6Bytes( ) )
	{
	    pwdLen = 1;
	    pwd[0] = 0;
	    do{
		for( i = pwdLen-1; i >= 0 && !(++pwd[i]); i-- );
		if( i < 0 )
		{
		    pwd[pwdLen++] = 0;
		    printf( "Trying length %d bytes...\n", pwdLen+6 );
		    fflush( stdout );
		}
		for( ; i < pwdLen-1; i++ )
		{
		    pwd[i+1]++;		/* We don't want 0x00 in the password... */
		    if( i >= 0 )
		    {
		        key0list[i+1] = CRC32( key0list[i], pwd[i] );
		        key1list[i+1] = (key1list[i] + (key0list[i+1]&0xff))*134775813 + 1;
		        key2list[i+1] = CRC32( key2list[i], (key1list[i+1]>>24)&0xff );
		    }
		}
		m0 = CRC32( key0list[pwdLen-1], pwd[pwdLen-1] );
		m1 = (key1list[pwdLen-1] + (m0&0xff))*134775813 + 1;
		m2 = CRC32( key2list[pwdLen-1], (m1>>24)&0xff );		
	    } while( !find6Bytes( ) );
	}
    }
}

void initStage3Tab( )
{
uword	i, prod;
byte	j;

    for( i = 0; i < 256; i++ )
    {
	mTab2Counter[i] = 0;
	mTab2[i][0] = 0;
	invCrcTabCounter[i] = 0;
    }

    for( i = 0; i < 256; i++ )
    {
	prod = i*INVCONST;
	mulTab[i] = prod;
	j = (prod>>24)&0xff;
	mTab2[j][mTab2Counter[j]++] = i;
	mTab2[j][mTab2Counter[j]] = 0;
	if( mTab2Counter[j] > 14 )
	    fprintf( stderr, "Error! Inverse mTab too small!\n" );

	j = (crctab[i]>>24)&0xff;
	invCrcTab[j][invCrcTabCounter[j]] = i;
	if( invCrcTabCounter[j]++ == 3 )
	    fprintf( stderr, "Error! Inverse crcTab too small!\n" );
    }
}
