/*********************blowfish.c*********************/

/* TODO: test with zero length key */
/* TODO: test with a through z as key and plain text */
/* TODO: make this byte order independent */

#include <stdio.h>		/* used for debugging */
#ifdef MACINTOSH
   #include <Types.h>		/* FIXME: do we need this? */
#endif

#include "blowfish.h"
#include "bf_tab.h"		/* P-box P-array, S-box  */

#define S(x,i) (bf_S[i][x.w.byte##i])
#define bf_F(x) (((S(x,0) + S(x,1)) ^ S(x,2)) + S(x,3))
#define ROUND(a,b,n) (a.word ^= bf_F(b) ^ bf_P[n])

void Blowfish_encipher(UWORD_32bits blk[], bfkey *tbl)
{
  union aword  Xl;
  union aword  Xr;

  Xl.word = blk[0];
  Xr.word = blk[1];

  Xl.word ^= tbl->bf_P[0];

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[1];
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[2];

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[3];
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[4];

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[5];
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[6];

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[7];
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[8];

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[9];
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[10];

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[11];
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[12];

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[13];
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[14];

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[15];
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[16];

  Xr.word ^= tbl->bf_P[17];

  blk[1] = Xl.word;
  blk[0] = Xr.word;
}

void Blowfish_decipher(UWORD_32bits blk[], bfkey *tbl)
{
  union aword  Xl;                                                                                                                                  
  union aword  Xr;                                                                                                                                  

  Xl.word = blk[0];                                                                                                                                 
  Xr.word = blk[1];                                                                                                                                 

  Xl.word ^= tbl->bf_P[17];                                                                                                                         

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[16];       
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[15];       

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[14];       
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[13];       

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[12];       
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[11];       

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[10];       
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[9];        

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[8];        
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[7];        

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[6];        
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[5];        

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[4];        
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[3];        

  Xr.word ^= (((tbl->bf_S[0][Xl.w.byte0] + tbl->bf_S[1][Xl.w.byte1]) ^ tbl->bf_S[2][Xl.w.byte2]) + tbl->bf_S[3][Xl.w.byte3]) ^ tbl->bf_P[2];        
  Xl.word ^= (((tbl->bf_S[0][Xr.w.byte0] + tbl->bf_S[1][Xr.w.byte1]) ^ tbl->bf_S[2][Xr.w.byte2]) + tbl->bf_S[3][Xr.w.byte3]) ^ tbl->bf_P[1];        



  Xr.word ^= tbl->bf_P[0];                                                                                                                          

  blk[0] = Xr.word;                                                                                                                                 
  blk[1] = Xl.word;                                                                                                                                   
}

void Blowfish_Initialize(UBYTE_08bits key[], short keybytes, bfkey *tbl)
{
  short          i;		/* FIXME: unsigned int, char? */
  short          j;		/* FIXME: unsigned int, char? */
  UWORD_32bits  data;
  UWORD_32bits  dataa[2];
  union aword temp;

  bcopy(bf_P, &tbl->bf_P,4*(bf_N+2));
  bcopy( bf_S, &tbl->bf_S,4*4*256);	


/*  fprintf (stderr, "0x%x 0x%x ", tbl->bf_P[0], tbl->bf_P[1]); /* DEBUG */
/*  fprintf (stderr, "%d %d\n", tbl->bf_P[0], tbl->bf_P[1]); /* DEBUG */

  j = 0;
  for (i = 0; i < bf_N + 2; ++i) {
    temp.word = 0;
    temp.w.byte0 = key[j];
    temp.w.byte1 = key[(j+1)%keybytes];
    temp.w.byte2 = key[(j+2)%keybytes];
    temp.w.byte3 = key[(j+3)%keybytes];
    data = temp.word;
    tbl->bf_P[i] = tbl->bf_P[i] ^ data;
    j = (j + 4) % keybytes;
  }

  dataa[0] = 0x00000000;
  dataa[1] = 0x00000000;

  for (i = 0; i < bf_N + 2; i += 2) {
    Blowfish_encipher(&(dataa[0]), tbl);

    tbl->bf_P[i] = dataa[0];
    tbl->bf_P[i + 1] = dataa[1];
  }

  for (i = 0; i < 4; ++i) {
    for (j = 0; j < 256; j += 2) {

      Blowfish_encipher(&(dataa[0]), tbl);
   
      tbl->bf_S[i][j] = dataa[0];
      tbl->bf_S[i][j + 1] = dataa[1];
    }
  }
  /*return 0;*/
}
