/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)descbc.c	1.18 95/11/28 Sun Microsystems"

#ifdef SYSV
#include <skip_sysv.h>
#endif

#ifdef SUNOS
#include <skip_sunos.h>
#endif

#if !defined(SYSV) && !defined(SUNOS)
#include <skip_os.h>
#endif

#include <bdcmod.h>
#include <skip_proto.h>
#include "skip_crypt.h"

struct des_cbc_state {
	unsigned long keysched[16][2];
	int pad;
};

#define MODULE_NAME		"des_cbc"
char				des_cbc_name[]= MODULE_NAME " v1.18";

#if defined(_KERNEL) || defined(KERNEL)
STATIC
#endif
void *			des_cbc_open_nopad(	char *,
						unsigned int,
						char *,
						unsigned int
				);

STATIC 
void *			des_cbc_open(		char *,
						unsigned int,
						char *,
						unsigned int
				);

STATIC 
void *			des_cbc_open1(		int, 
						char *,
						unsigned int,
						char *,
						unsigned int
				);

#if defined(KERNEL) || defined(_KERNEL)
STATIC 
#endif
void			des_cbc_close(		void *
				);

STATIC 
void			endes_cbc(		void *,
						char *,
						unsigned int *,
						char *,
						char *,
						unsigned int ,
						unsigned char *
				);

#if defined(_KERNEL) || defined(KERNEL)
STATIC 
#endif
void			endes_cbc_v1(		void *,
						char *,
						unsigned int *,
						char *,
						char *,
						unsigned int,
						unsigned char *
				);

#if defined(_KERNEL) || defined(KERNEL)
STATIC 
#endif
void			dedes_cbc_v1(		void *,
						char *,
						unsigned int *,
						char *,
						char *,
						unsigned int,
						unsigned char *
				);
STATIC 
void			dedes_cbc(void		*,
						char *,
						unsigned int *,
						char *,
						char *,
						unsigned int,
						unsigned char *
				);

STATIC 
unsigned int		des_cbc_outlen(		unsigned int
				);

#ifdef DEBUG
int				des_cbc_busy = 0;
static int			des_cbc_debug = 1;
#else
int				des_cbc_busy = 1;
static int			des_cbc_debug = 0;
#endif

/*
 * module number - this is used to install the module in the
 * table of cryptors used by the screen
 */
const unsigned int		des_cbc_id = 1;

const skip_cryptor_t		des_cbc_module_v1 = {
	MODULE_NAME,
	des_cbc_open,		/* open */
	des_cbc_close,		/* close */
	endes_cbc_v1,		/* encrypt */
	dedes_cbc_v1,		/* decrypt */
	des_cbc_outlen,		/* getoutputlen */
	8,			/* kp_len  */
	8,			/* ekp_len */
	8,			/* mid_len */
	SKIP_BLOCK_CIPHER,	/* flags */
	SKIP_DES_CBC,		/* Kij alg */
	SKIP_DES_CBC		/* Crypt alg */
};

const skip_cryptor_t		des_cbc_module = {
	MODULE_NAME,
	des_cbc_open,		/* open */
	des_cbc_close,		/* close */
	endes_cbc,		/* encrypt */
	dedes_cbc,		/* decrypt */
	des_cbc_outlen,		/* getoutputlen */
	8,			/* kp_len  */
	8,			/* ekp_len */
	8,			/* mid_len */
	SKIP_BLOCK_CIPHER,	/* flags */
        SKIP_KIJ_DES_CBC,       /* kij Alg */
        SKIP_CRYPT_DES_CBC,     /* kp alg */
};

const skip_cryptor_t		des_cbc_nopad_module_v1 = {
	MODULE_NAME,
	des_cbc_open_nopad,	/* open */
	des_cbc_close,		/* close */
	endes_cbc_v1,		/* encrypt */
	dedes_cbc_v1,		/* decrypt */
	des_cbc_outlen,		/* getoutputlen */
	8,			/* kp_len  */
	8,			/* ekp_len */
	8,			/* mid_len */
	SKIP_BLOCK_CIPHER,	/* flags */
	SKIP_DES_CBC,		/* kij alg # */
	SKIP_DES_CBC		/* kp alg # */
};

const skip_cryptor_t		des_cbc_nopad_module = {
	MODULE_NAME,
	des_cbc_open_nopad,	/* open */
	des_cbc_close,		/* close */
	endes_cbc_v1,		/* encrypt */
	dedes_cbc_v1,		/* decrypt */
	des_cbc_outlen,		/* getoutputlen */
	8,			/* kp_len  */
	8,			/* ekp_len */
	8,			/* mid_len */
	SKIP_BLOCK_CIPHER,	/* flags */
	SKIP_KIJ_DES_CBC,	/* kij alg */
	SKIP_CRYPT_DES_CBC	/* kp alg # */
};


STATIC
void *
des_cbc_open(char  *keyp, unsigned int keylen, char *ivp, unsigned int ivlen)
{
	return des_cbc_open1(1,keyp, keylen, ivp, ivlen);
}

#if defined(_KERNEL) || defined(KERNEL)
STATIC
#endif
void *
des_cbc_open_nopad(char  *keyp, unsigned int keylen, char *ivp, 
		   unsigned int ivlen)
{
	return des_cbc_open1(0,keyp, keylen, ivp, ivlen);
}

STATIC
void *
des_cbc_open1(int padding, char  *keyp, unsigned int keylen,
		char *ivp, unsigned int ivlen)
{
	struct des_cbc_state *cs;

	cs = (struct des_cbc_state *)MEM_ALLOC(sizeof(struct des_cbc_state));
	des_cbc_busy++;

	if (cs == (void *)0)
		return cs;
	cs->pad=padding;
	setkey(cs->keysched, keyp);
	return (cs);
}

STATIC
unsigned int
des_cbc_outlen(unsigned int inlen)
{
	/* Worst-case padding, rounded down to a multiple of 8 bytes */
	return (inlen + 9) & (unsigned)-8;
}

static char all_8_pad_block[] = { 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 };

/*
 * DES CBC encryption using Phil Karn's/Richard Outerbridge's 
 * DES ECB implementation. Written for a 32-bit machine. *lenp can be 
 * arbitrary as this routine will perform padding according to
 * PKCS #5. length of out buffer must be large enough to guarantee 
 * that the output after being padded will fit in it. Adding 8 to the 
 * length of the input buffer will guarantee this. iv must point to 
 * an 8 byte array. The cs needs to be initialized using the 
 * des_cbc_open() operation. Upon return, iv will be set to
 * be equal to the last encrypted block. The "in" and "out"
 * buffers must be 32-bit aligned, as the software starts
 * doing 32-bit operations to move the data in and out of
 * the encryption engine.
 */

#if defined(_KERNEL) || defined(KERNEL)
STATIC
#endif
void
endes_cbc_v1(void *csp, char *in, unsigned int *lenp, char *out, char *iv, 
		unsigned int ivlen, unsigned char *payload)
{
	char ecbio[8];
	char block[8];
	char pad;
	int i,j, mod8, l;
	unsigned long *ks;
	struct des_cbc_state *cs;
	int len = *lenp;

	cs=(struct des_cbc_state *)csp;
	if (len == 0)
		return;
	ks = (unsigned long *)(cs->keysched);
	mod8 = (len & 0x07);	/* technically this is (len % 8) */
	if (len < 8 ) {
		/* 
		 * First, and only block processing 
		 */
		if (cs->pad == 0) {
			if (des_cbc_debug) {
				printf("endes_cbc error: "
				"Blocksize is not multiple  of 8\n");
			}
			*lenp=0;
			return;
		}
			
		BCOPY((caddr_t)in, (caddr_t)block, len);
		pad = 8 - mod8;
		for (j = 0; j < pad; j++) {
			block[mod8 + j] = pad;
		}
		*(unsigned int *)ecbio = *(unsigned int *)iv ^
						*(unsigned int *)&block[0];
		*(unsigned int *)(ecbio + 4) = *(unsigned int *)(iv + 4) ^
						*(unsigned int *)&block[4];
		endes(ks, ecbio);
		*(unsigned int *)&out[0] = *(unsigned int *)ecbio;
		*(unsigned int *)&out[4] = *(unsigned int *)(ecbio + 4);
		*lenp = 8;
		return;
	}

	/* 
	 * First block processing 
	 */

	*(unsigned int *)ecbio = *(unsigned int *)iv ^
					*(unsigned int *)&in[0];
	*(unsigned int *)(ecbio + 4) = *(unsigned int *)(iv + 4) ^
					*(unsigned int *)&in[4];
	endes(ks, ecbio);
	*(unsigned int *)&out[0] = *(unsigned int *)ecbio;
	*(unsigned int *)&out[4] = *(unsigned int *)(ecbio + 4);

	for (i = 8; i <= len - 8; i += 8) {
		/* 
		 * Middle blocks processing, no padding required here 
		 */
		*(unsigned int *)ecbio = *(unsigned int *)&out[i - 8] ^ 
					*(unsigned int *)&in[i];
		*(unsigned int *)(ecbio + 4) = *(unsigned int *)&out[i - 4] ^ 
					*(unsigned int *)&in[i + 4];
		endes(ks, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)(ecbio + 4);
	}

	/* 
	 * Final block processing, i falls through and is used 
	 */

	if (mod8 != 0) {
		if (cs->pad == 0) {
			printf("Error: Blocksize is not multiple  of 8\n");
			*lenp=0;
			return;
		}
		/* 
		 * Need to pad last block upto full 8 bytes 
		 */
		BCOPY((caddr_t)&in[i], (caddr_t)block, len - i);
		pad = 8 - mod8;
		for (j = 0; j < pad; j++) {
			block[mod8 + j] = pad;
		}
		*(unsigned int *)ecbio = *(unsigned int *)&out[i - 8] ^ 
					*(unsigned int *)&block[0];
		*(unsigned int *)(ecbio + 4) = *(unsigned int *)&out[i - 4] ^ 
					*(unsigned int *)&block[4];
		endes(ks, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)(ecbio + 4);
		*lenp = len + pad;
	} else {
		if (cs->pad) {
			/* 
	 	 	* length is multiple of 8, add the all 08 pad block 
		 	*/
			*(unsigned int *)ecbio = 
					*(unsigned int *)&out[i - 8] ^ 
					*(unsigned int *)&all_8_pad_block[0];
			*(unsigned int *)(ecbio + 4) = 
					*(unsigned int *)&out[i - 4] ^ 
					*(unsigned int *)&all_8_pad_block[4];
			endes(ks, ecbio);
			*(unsigned int *)&out[i] = *(unsigned int *)ecbio;
			*(unsigned int *)&out[i + 4] = 
					*(unsigned int *)(ecbio + 4);
			*lenp = len + 8;
		}
	}
	/*
	 * Set the iv to be the last
	 * encrypted block;
	 */
	BCOPY((caddr_t)&out[i], (caddr_t)iv, 8);
	return;
}

#if defined(_KERNEL) || defined(KERNEL)
STATIC
#endif
void
dedes_cbc_v1(void *csp, char *in, unsigned int *lenp, char *out, char *iv, 
	     unsigned int ivlen, unsigned char *payload)
{
	char ecbio[8];
	int i, mod8, l, padlen;
	unsigned long *ks;
	struct des_cbc_state *cs;
	int len = *lenp;
	if (len == 0)
		return;
	cs=(struct des_cbc_state *)csp;

	ks = (unsigned long *)(cs->keysched);
	mod8 = (len & 0x07);	/* technically this is (len % 8) */
	if (mod8 != 0)	{/* CBC decryption always expects block-size multiple */
		if (des_cbc_debug) {
			printf("dedes_cbc error: "
				"Blocksize %d is not multiple  of 8\n", len);
		}
		*lenp = 0;
		return;
	}

	/* 
	 * First block processing 
	 */

	*(unsigned int *)ecbio = 	*(unsigned int *)&in[0];
	*(unsigned int *)(ecbio + 4) =  *(unsigned int *)&in[4];
	dedes(ks, ecbio);
	*(unsigned int *)&out[0] = *(unsigned int *)iv ^ 
					*(unsigned int *)ecbio;
	*(unsigned int *)&out[4] = *(unsigned int *)(iv + 4) ^ 
					*(unsigned int *)(ecbio + 4);

	for (i = 8; i < len ; i += 8) {
		*(unsigned int *)ecbio = 	*(unsigned int *)&in[i];
		*(unsigned int *)(ecbio + 4) =  *(unsigned int *)&in[i+4];
		dedes(ks, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)&in[i - 8] ^ 
					*(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)&in[i - 4] ^ 
					*(unsigned int *)(ecbio + 4);
	}

	if ( cs->pad ) {
		if ((padlen = (int)((unsigned char)(out[i-1]))) > 0x08) {
			if (des_cbc_debug) {
				printf("dedes_cbc: "
					"error in pad block, pad > 08\n");
			}
			*lenp = 0;
			return;
		}

	/*
	 * Adjust the length of the output
	 * for padding. The last byte of the
	 * output will always indicate the
	 * length of the pad.
	 */
		*lenp = len - padlen;
		return;
	}
}

STATIC
void
endes_cbc(void *csp, char *in, unsigned int *lenp, char *out, char *iv, 
          unsigned int ivlen, unsigned char *payload)
{
	char ecbio[8];
	unsigned char *buf = (unsigned char *) in;

	int i,j;
	unsigned long *ks;
	struct des_cbc_state *cs;
	int len = *lenp;


	cs=(struct des_cbc_state *)csp;
	if (len == 0)
		return;
	ks = (unsigned long *)(cs->keysched);

	while ((len &0x07)!=6) {
		buf[len]=len;
		len++;
	}

	buf[len]=len-*lenp;	/* pad length */
	len++;
	buf[len]=*payload;	/* payload type */
	len++;

	*lenp = len;

	/* 
	 * First, and only block processing 
	 */

	*(unsigned int *)ecbio=*(unsigned int *)iv ^ *(unsigned int *)&buf[0];
	*(unsigned int *)(ecbio + 4) =  *(unsigned int *)(iv + 4) ^ 
					*(unsigned int *)&buf[4];
	endes(ks, ecbio);
	*(unsigned int *)&out[0] = *(unsigned int *)ecbio;
	*(unsigned int *)&out[4] = *(unsigned int *)(ecbio + 4);

	for (i = 8; i < len ; i += 8) {
		/* 
		 * Middle blocks processing, no padding required here 
		 */
		*(unsigned int *)ecbio = *(unsigned int *)&out[i - 8] ^ 
					*(unsigned int *)&buf[i];
		*(unsigned int *)(ecbio + 4) = *(unsigned int *)&out[i - 4] ^ 
					*(unsigned int *)&buf[i + 4];
		endes(ks, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)(ecbio + 4);
	}
	BCOPY((caddr_t)&out[i-8], (caddr_t)iv, 8);
	return;
}

STATIC
void
dedes_cbc(void *csp, char *in, unsigned int *lenp, char *out, char *iv, 
	  unsigned int ivlen, unsigned char *payload)
{
	char ecbio[8];
	int i, mod8, l, padlen;
	unsigned long *ks;
	struct des_cbc_state *cs;
	int len = *lenp;
	if (len == 0)
		return;
	cs=(struct des_cbc_state *)csp;

	ks = (unsigned long *)(cs->keysched);
	mod8 = (len & 0x07);	/* technically this is (len % 8) */
	if (mod8 != 0)	{/* CBC decryption always expects block-size multiple */
		*lenp = 0;
		return;
	}
					
	/* 
	 * First block processing 
	 */

	*(unsigned int *)ecbio = 	*(unsigned int *)&in[0];
	*(unsigned int *)(ecbio + 4) =  *(unsigned int *)&in[4];
	dedes(ks, ecbio);
	*(unsigned int *)&out[0] = *(unsigned int *)iv ^ 
					*(unsigned int *)ecbio;
	*(unsigned int *)&out[4] = *(unsigned int *)(iv + 4) ^ 
					*(unsigned int *)(ecbio + 4);

	for (i = 8; i < len ; i += 8) {
		*(unsigned int *)ecbio = 	*(unsigned int *)&in[i];
		*(unsigned int *)(ecbio + 4) =  *(unsigned int *)&in[i+4];
		dedes(ks, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)&in[i - 8] ^ 
					*(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)&in[i - 4] ^ 
					*(unsigned int *)(ecbio + 4);
	}
	
	if ((padlen = (int)((unsigned char)(out[len-2]))) > 0x08){
			printf("dedes_cbc: error in pad block, pad > 07\n");
			*lenp = 0;
			return;
	}
	*payload = out[len-1];

	/*
	 * Adjust the length of the output
	 * for padding. 
	 */

	*lenp = len - padlen - 2; /* strip off payload and pad bytes */
	return;
}

#if defined(KERNEL) || defined(_KERNEL)
STATIC
#endif
void
des_cbc_close(void *cs)
{
	BZERO(cs, sizeof(struct des_cbc_state));
	MEM_FREE(cs, sizeof(struct des_cbc_state));
	des_cbc_busy--;
	return;
}
