/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_es_bypass.c	1.6 95/11/15 Sun Microsystems"

/*
 * System includes
 */
#ifdef SYSV
#include <skip_sysv.h>
#endif
#ifdef SUNOS
#include <skip_sunos.h>
#endif
#if !defined(SYSV) && !defined(SUNOS)
#include <skip_os.h>
#endif

/*
 * SKIP includes
 */
#include <bdcmod.h>
#include <skip_types.h>
#include <skip_proto.h>
#include <skip_ioctl.h>
#include <skip_keymgrmsgs.h>
#include <skip_key.h>
#include <skip_es.h>

#define	SKIP_ES_FRAGCACHE_SZ	16	/* # of fragment details to cache */

/*
 * pair of ports for bypass communications
 */
int			skip_client_port = 0;
int			skip_server_port = 0;
static struct ip	skip_es_fragcache[SKIP_ES_FRAGCACHE_SZ];


/* skip_es_fragcache_init()
 *
 * Initialise fragmentation cache
 * 
 * Returns: none
 */
void 
skip_es_fragcache_init()
{
	bzero((char *)skip_es_fragcache, sizeof(skip_es_fragcache));
}

/* skip_es_fragcache_add()
 *
 * Maintain a circular buffer of fragmentation information.
 * 
 * Returns: none
 */
static void
skip_es_fragcache_add(struct ip *iphdr)
{
	static int	writer = 0;

	skip_es_fragcache[writer++] = *iphdr;

	if (writer == SKIP_ES_FRAGCACHE_SZ) {
		writer = 0;
	}
}

/* skip_es_in_fragcache()
 *
 * Returns: B_TRUE if we passed the first fragment, B_FALSE otherwise
 */
static boolean_t
skip_es_in_fragcache(struct ip *iphdr)
{
	static int		reader = 0;
	register int		r;
	register struct ip	*ip;
	boolean_t		found = B_FALSE;

	r = reader;

	do {
		ip = &skip_es_fragcache[r];

		if ((ip->ip_id == iphdr->ip_id) &&
			(ip->ip_src.s_addr == iphdr->ip_src.s_addr) &&
			(ip->ip_dst.s_addr == iphdr->ip_dst.s_addr)) {

			/*
			 * first fragment is present in cache
			 */

			reader = r;
			found = B_TRUE;
			break;
		}
		r++;
		if (r == SKIP_ES_FRAGCACHE_SZ) {
			r = 0;
		}
	} while (r != reader);
	return (found);
}

/* skip_es_bypass()
 * 
 * Returns: B_TRUE if message can bypass security, B_FALSE otherwise
 */
boolean_t
skip_es_bypass(struct ip *iphdr, int size)
{
	register int		hdrsz;
	struct udphdr		*udphdr; 

	if ((skip_client_port == 0) || (skip_server_port == 0)) {
		return (B_FALSE);
	}

	if (iphdr->ip_off & htons(IP_OFFSET)) {
		/*
		 * not first fragment - check to see if we passed the 1st frag
		 */
		return (skip_es_in_fragcache(iphdr));
	}

	hdrsz = iphdr->ip_hl << 2;

	/*
	 * check IP message size is valid: ip header + udp header
	 */
	if (size < (hdrsz + sizeof (struct udphdr))) {
		return (B_FALSE);
	}

	udphdr = (struct udphdr *) ((char *) iphdr + hdrsz);

	/*
	 * check for an incoming request for local server
	 */
	if ((udphdr->uh_sport == skip_client_port) &&
		(udphdr->uh_dport == skip_server_port)) {

		/*
		 * allow message, creating fragment cache entry if a fragment
		 */
		if (iphdr->ip_off & htons(IP_MF)) {
			skip_es_fragcache_add(iphdr);
		}
		return (B_TRUE);
	}

	/*
	 * check for an incoming reply to local client
	 */
	if ((udphdr->uh_sport == skip_server_port) &&
		(udphdr->uh_dport == skip_client_port)) {

		/*
		 * allow message, creating fragment cache entry if a fragment
		 */
		if (iphdr->ip_off & htons(IP_MF)) {
			skip_es_fragcache_add(iphdr);
		}
		return (B_TRUE);
	}

	/*
	 * don't allow bypass
	 */
	return (B_FALSE);
}
