/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
/*
 * Copyright 1994 Sun Microsystems, Inc. All Rights Reserved
 */
#pragma ident "@(#)test_dh.C      @(#)test_dh.C	1.10 %V% Sun Microsystems"

/*
 * Author: Ashar Aziz
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include "Bigint.h"
#include "Bstream.h"
#include "malloc.h"
#include "SkipCert.h"

#include "skip_conf.h"
#include "skip_keymgr.h"
#include "skip_log.h"

#include "my_types.h"

extern Bstream dhparams;
extern Bstream mydhsecret;
extern int verbose;
extern SkipCert *my_cert;

extern Bigint master_mod, master_base;
void
usage()
{
	fprintf(stderr, "Usage: test_dh [-n nsid] [-t certtype] <boxid>\n");
	exit (1);
}

void
printsecret()
{
	Bstream mysecret, seed;
	mysecret=mydhsecret;
	printf("my dh secret :\n "); mysecret.print(); fflush(stdout);

}


main(int argc, char **argv)
{
	u_long expiration;
	hrtime_t start, end;
	int c,n;
	u_char nsid=0, certtype=0;
	n=1;

	while ((c=getopt(argc,argv,"n:t:"))!= -1) {
                switch (c) {
                        case 'n':
                                nsid = atoi(optarg);
				n++;n++;
                                break;
                        case 't':
				certtype = atoi(optarg);
				n++;n++;
                                break;
			default:
				usage();
		}
	}
	if (skip_keymgr_init()) {
		skip_log(SKIP_ERROR,"Error loading parameters");
		exit(1);
	}

	if (n >= argc) 
		usage();

        Bstream boxid = Bigint_to_Bstr(Bigint(argv[n]));

	start=gethrtime();
	Bstream secret_ij = skip_dh_key_agree(boxid, nsid, expiration);	
	end=gethrtime();
	if (secret_ij.getlength() == 0) {
		skip_log(SKIP_ERROR,"Unable to find other public value");
		exit(1);
	}

	printsecret();

	printf("time spent calculating secret=%lldms\n",(end-start)/1000000);
	Bstream base=Bigint_to_Bstr(master_base);
	Bstream mod=Bigint_to_Bstr(master_mod);
	printf("secret_ij = "); secret_ij.print();
	printf("modulus = "); mod.print();
	printf("base = "); base.print();
}
